# coding=utf-8
__author__ = '******'
# 获取oracle数据库的ASM信息

from common import util
from common import constants

CLI = None
LANGUAGE = None
CHECK_FAIL = 0
CHECK_PASS = 1
sql_info = {"sql_info_asm_disk":
                "select * from v$asm_disk",
            "sql_info_asm_diskgroup":
                "select group_number gno,name,state,type,total_mb,free_mb,sector_size from v$asm_diskgroup",
            "sql_info_asm_diskstring":
                "select name,value from v$parameter where name = 'asm_diskstring'",
            "sql_info_asm_info":
                "select path,group_number, disk_number,mount_status,header_status,mode_status,state,sector_size"
                " from v$asm_disk",
            "sql_info_asm_failgroup":
                "select group_number,disk_number,name,failgroup,path from v$asm_disk order by failgroup",
            "sql_info_asm_disk_timeoutparms":
                r"select a.ksppinm name,b.ksppstvl value,a.ksppdesc describe from x$ksppi a,x$ksppcv b"
                r" where a.inst_id = userenv('instance') and b.inst_id = userenv('instance') and a.indx = b.indx"
                r" and a.ksppinm like '\_asm_hbeatio%' escape '\'",
            }


def switchToSql(CLI):

    exitCmd = 'exit'
    whoamiCmd = 'whoami'
    sqlEnter = "sqlplus \"/as sysdba\""
    sqlSize = 'set linesize 3000'
    #如果通过SSH连接，则要退到root用户

    if not str(CLI.execSql(whoamiCmd).getSqlResult()).lower().__contains__('root'):
        CLI.execSql(exitCmd)
    if not str(CLI.execSql(whoamiCmd).getSqlResult()).lower().__contains__('root'):
        CLI.execSql(exitCmd)

    CLI.execSql('su - oracle')
    CLI.execSql(sqlEnter)
    CLI.execSql(sqlSize)

def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("DBConn")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    sql_display = context.get("ret_map")
    global useJdbc
    useJdbc = context.get("isUseJdbc")
    iswitchSucc, cmd = switchDBConnToASMInstanceConn(context, CLI)
    if iswitchSucc and cmd == "JDBC":
        return sql_execute(sql_display, CLI, LANGUAGE,context)
    elif iswitchSucc and cmd == "SSH":
        result = sql_execute(sql_display, CLI, LANGUAGE,context)
        switchToSql(CLI)
        return result
    else:
        util.log.error(context, "the item collect failed!")
        cmdErrMsg = ''
        if "en" == LANGUAGE:
            cmdErrMsg = cmd + ":\texecute failed\r\n"
        else:
            cmdErrMsg = cmd + u":\t执行失败\r\n"
        switchToSql(CLI)
        sql_display.put("err_msg", cmdErrMsg)
        return sql_display

# 由当前数据库切换到ASM实例数据库
def switchDBConnToASMInstanceConn(context, CLI):
    
    exitCmd = 'exit'
    whoamiCmd = 'whoami'
    queryCurrentOracleCmd = 'ps -ef |grep asm_pmon'
    
    asmInstance = {}
    #如果是通过JDBC连接，由数据库名称访问数据库，则不需要进行切换
    try:
        if context.get("isUseJdbc"):
            util.log.info(context, "query the oracle by JDBC connect, need not switch user.")
            util.updateItemProgress(context, constants.PROG15)
            return True, "JDBC"
        else:
            util.log.info(context, "query the oracle by SSH connect, need switch user.")
    except Exception, e:
        util.log.error(context, "Exception occurred while switching the oracle to asm instance oracle:%s" % str(e))
        raise Exception, e
    return True, "SSH"

def sql_execute(sql_display, CLI, LANGUAGE,context):
    fun_err_msg = ''
    totalPreg = constants.PROG75 if useJdbc else constants.PROG50
    perPreg = totalPreg / len(sql_info)
    for item in sql_info:
        sql_display_temp = CLI.execSql(sql_info.get(item))
        util.addItemProgress(context, perPreg)
        sql_display.put("sql_display" + (item)[8:], sql_display_temp)
        if None == sql_display_temp.getSqlResult() or '' == sql_display_temp.getSqlResult() or 'TOOLKIT_SEND_SQL_TIME_OUT' == sql_display_temp.getSqlResult() or 'TOOLKIT_EXE_CMD_FAILED' == sql_display_temp.getSqlResult():
            if "en" == LANGUAGE:
                fun_err_msg += sql_info.get(item) + ":\texecute failed\r\n"
            else:
                fun_err_msg += sql_info.get(item) + u":\t执行失败\r\n"
        else:
            if "en" == LANGUAGE:
                fun_err_msg += sql_info.get(item) + ":\texecute success\r\n"
            else:
                fun_err_msg += sql_info.get(item) + u":\t执行成功\r\n"
    sql_display.put("err_msg", fun_err_msg)

    return sql_display
   
def getOSType(context, CLI):
    """
    @summary: 查询当前系统的类型
    @param context: 上下文参数
    @return: 命令查询返回结果
    """

    """先判断是否是windows"""
    cliRet = CLI.execSql("wmic OS get Caption /value").getSqlResult()
    if constants.OS_TYPE_WINDOWS_LOW in cliRet.lower():
        return constants.OS_TYPE_WINDOWS_LOW, cliRet

    """再判断其他系统"""
    cliRet = CLI.execSql("uname -a").getSqlResult()
    if constants.OS_TYPE_VMWARE_LOW in cliRet.lower():
        return constants.OS_TYPE_VMWARE_LOW, cliRet

    if constants.OS_TYPE_SOLARIS_LOW in cliRet.lower() or constants.OS_TYPE_SUNOS_LOW in cliRet.lower():
        return constants.OS_TYPE_SOLARIS_LOW, cliRet

    if constants.OS_TYPE_LINUX_LOW in cliRet.lower():
        return constants.OS_TYPE_LINUX_LOW, cliRet

    if constants.OS_TYPE_AIX_LOW in cliRet.lower():
        return constants.OS_TYPE_AIX_LOW, cliRet

    return "NA" , cliRet
