# coding=utf-8
# 获取oracle数据库的版本信息
import sys
import os
import string
CURRENT_PATH = os.path.dirname(os.path.abspath(__file__))
sys.path.append(CURRENT_PATH)
CURRENT_PATH = os.path.join(CURRENT_PATH, "..\\..")
sys.path.append(CURRENT_PATH)
from common import util
from common import constants
from com.huawei.ism.tool.infograb.entity import DBCmdResultSet
import re
CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
sql_info = {"sql_info_cdb"      :       "select name, decode(cdb, 'YES', 'Multitenant Option enabled', 'Regular 12c Database: ') \"Multitenant Option\" , open_mode, con_id from v$database",
            "sql_info_pdb"      :       "select con_id,name,open_mode,total_size,restricted from v$pdbs"}

sql_info_version = "select * from v$version"

sql_width = 'set linesize 3000'

def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("DBConn")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    sql_display = context.get("ret_map")
    CLI.execSql(sql_width)
    fun_flag, result, fun_err_msg = sql_execute(context, sql_display, CLI, LANGUAGE)
    util.log.info(context, "result keys:" + str(result.keys()))
    util.log.info(context, "result values:" + str(result.values))
    return check_and_get_result(fun_flag, result, fun_err_msg)


# 取中间一个有效值
def check_and_get_result(fun_flag, result, fun_err_msg):
    """
    :rtype : object
    """
    
    return result


def sql_execute(context, sql_display, CLI, LANGUAGE):
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    util.updateItemProgress(context, constants.PROG25)
    global version_num
    version_num = ''
    sql_display_temp = CLI.execSql(sql_info_version)
    sql_display.put("sql_display_version", sql_display_temp)
    SqlResTemp = sql_display_temp.getSqlResult()
    util.updateItemProgress(context, constants.PROG45)
    if None == SqlResTemp or '' == SqlResTemp or 'TOOLKIT_SEND_SQL_TIME_OUT' == SqlResTemp:
        if "en"==LANGUAGE:
            fun_err_msg        +=sql_info_version + ":\texecute failed\r\n"
        else:
            fun_err_msg        +=sql_info_version + u":\t执行失败\r\n"
    else:
        if "en"==LANGUAGE:
            fun_err_msg        +=sql_info_version + ":\texecute success\r\n"
        else:
            fun_err_msg        +=sql_info_version + u":\t执行成功\r\n"
    version_list_line = []
    if isinstance(SqlResTemp,unicode):
        version_list_line = SqlResTemp.splitlines()
    else:    
	    while(SqlResTemp. next()):
	        version_list_line.append(str(SqlResTemp.getString(1)))
    version_info = ''
    for curLine in version_list_line:
        if "Edition Release" in curLine:
            version_info = curLine
            version_info_list = version_info.split()
            if len(version_info_list)-1 >= 6:
                version = version_info_list[6]
                version_split = version.split(".")
                if len(version_split)-1 >= 0:
                    version_num = version_split[0]
    util.updateItemProgress(context, constants.PROG65)
    if version_num.isdigit():               
	    if string.atoi(version_num) >= 12:     
		    for item in sql_info:   
		        sql_display_temp = CLI.execSql(sql_info.get(item))
		        sql_display.put("sql_display"+(item)[8:], sql_display_temp)
		        SqlResTemp = sql_display_temp.getSqlResult()
		        if None == SqlResTemp or '' == SqlResTemp or 'TOOLKIT_SEND_SQL_TIME_OUT' == SqlResTemp:
		            if "en"==LANGUAGE:
		                fun_err_msg        +=sql_info.get(item) + ":\texecute failed\r\n"
		            else:
		                fun_err_msg        +=sql_info.get(item) + u":\t执行失败\r\n"
		        else:
		            if "en"==LANGUAGE:
		                fun_err_msg        +=sql_info.get(item) + ":\texecute success\r\n"
		            else:
		                fun_err_msg        +=sql_info.get(item) + u":\t执行成功\r\n"
    sql_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    util.updateItemProgress(context, constants.PROG85)
    return fun_flag, sql_display, fun_err_msg