# coding=utf-8
__author__ = '******'
# 获取oracle数据库的数据文件大小信息
import re
import sys
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import util
from common import constants
CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
sql_info = {"sql_info_data_files_size"      :       "select tablespace_name,file_name,bytes from dba_data_files"}


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("DBConn")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    sql_display = context.get("ret_map")
    return check_and_get_result(sql_execute(sql_display, CLI, LANGUAGE,context))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def sql_execute(sql_display, CLI, LANGUAGE,context):
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    prgStep = constants.PROG45 / len(sql_info)
    curstep = constants.PROG45
    util.updateItemProgress(context, curstep)
    for item in sql_info:
        sql_display_temp = CLI.execSql(sql_info.get(item))
        curstep += prgStep
        util.updateItemProgress(context, curstep)
        sql_display.put("sql_display"+(item)[8:], sql_display_temp)
        if None == sql_display_temp.getSqlResult() or '' == sql_display_temp.getSqlResult() or 'TOOLKIT_SEND_SQL_TIME_OUT' == sql_display_temp.getSqlResult():
            if "en"==LANGUAGE:
                fun_err_msg        +=sql_info.get(item) + ":\texecute failed\r\n"
            else:
                fun_err_msg        +=sql_info.get(item) + u":\t执行失败\r\n"
        else:
            if "en"==LANGUAGE:
                fun_err_msg        +=sql_info.get(item) + ":\texecute success\r\n"
            else:
                fun_err_msg        +=sql_info.get(item) + u":\t执行成功\r\n"
    sql_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, sql_display, fun_err_msg