# coding=utf-8
__author__ = '******'
# 获取oracle数据库的ASM信息

from common import util
from common import constants

CLI = None
LANGUAGE = None
CHECK_FAIL = 0
CHECK_PASS = 1
sql_info = {
    "sql_info_pst_disk": "select instance_name,host_name from v$instance",
    "sql_info_pst_local_listener": "select NAME,VALUE from v$parameter where NAME like 'local_listener'",
    "sql_info_pst_v$version": "select * from v$version",
    "sql_info_pst_v$asm_diskgroup":
        "select group_number gno,name,state,type,total_mb,free_mb,sector_size from v$asm_diskgroup",
    "sql_info_pst_x$ksppi_x$ksppcv":
        "select a.ksppinm name,b.ksppstvl value,a.ksppdesc describe from x$ksppi a,x$ksppcv b"
        " where a.inst_id = userenv('instance') and b.inst_id = userenv('instance') and a.indx = b.indx"
        " and a.ksppinm like '\_asm_hbeatio%' escape '\\\'",
    "sql_info_pst_v$asm_disk":
        "select name,path,group_number, disk_number,mount_status,header_status,mode_status,state,sector_size"
        " from v$asm_disk",
}


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("DBConn")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    sql_display = context.get("ret_map")
    return sql_execute(sql_display, context)


def sql_execute(sql_display, context):
    fun_err_msg = ''
    util.updateItemProgress(context, constants.PROG25)
    for item in sql_info:
        sql_display_temp = CLI.execSql(sql_info.get(item))
        util.updateItemProgress(context, constants.PROG75)
        sql_display.put("sql_display" + item[8:], sql_display_temp)
        if sql_display_temp.getSqlResult() is None or '' == sql_display_temp.getSqlResult() \
                or 'TOOLKIT_SEND_SQL_TIME_OUT' == sql_display_temp.getSqlResult():
            if "en" == LANGUAGE:
                fun_err_msg += sql_info.get(item) + ":\texecute failed\r\n"
            else:
                fun_err_msg += sql_info.get(item) + u":\t执行失败\r\n"
        else:
            if "en" == LANGUAGE:
                fun_err_msg += sql_info.get(item) + ":\texecute success\r\n"
            else:
                fun_err_msg += sql_info.get(item) + u":\t执行成功\r\n"
    sql_display.put("err_msg", fun_err_msg)
    util.updateItemProgress(context, constants.PROG90)
    return sql_display
