# coding=utf-8
__author__ = '******'
# 获取oracle数据库的ASM信息

from common import util
from common import constants

CLI = None
LANGUAGE = None
CHECK_FAIL = 0
CHECK_PASS = 1

sql_info_id = ["sql_display_database_basic_instance_name",
               "sql_display_database_basic_local_listener",
               "sql_display_database_basic_v$version",
               "sql_display_database_basic_v$asm_diskgroup",  # memory
               "sql_display_database_basic_x$ksppi_x$ksppcv",
               "sql_display_database_basic_v$asm_disk"]

sql_info_dese = ["select instance_name,host_name from v$instance",
                 "select NAME,VALUE from v$parameter where NAME like 'local_listener'",
                 "select * from v$version",
                 "select group_number gno,name,state,type,total_mb,free_mb,sector_size from v$asm_diskgroup",
                 r"select a.ksppinm name,b.ksppstvl value,a.ksppdesc describe from x$ksppi a,x$ksppcv b"
                 r" where a.inst_id = userenv('instance') and b.inst_id = userenv('instance')"
                 r" and a.indx = b.indx and a.ksppinm like '\_asm_hbeatio%' escape '\'",
                 "select name,path,group_number, disk_number,mount_status,header_status,mode_status,state,sector_size"
                 " from v$asm_disk"]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("DBConn")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    sql_display = context.get("ret_map")
    LOGGER = context.get('Logger')
    fun_err_msg = ''
    fun_err_msg_temp = ''
    global useJdbc
    util.updateItemProgress(context, constants.PROG5)
    curstep = constants.PROG5
    util.updateItemProgress(context, curstep)
    try:
        fun_err_msg += ssh_oracle_execute(CLI, sql_display, fun_err_msg_temp,
                                          context, LOGGER)
        util.updateItemProgress(context, constants.PROG90)
    except Exception as ex:
        LOGGER.error(
            "get oracle rac cluster info error: " +
            ex)
        util.updateItemProgress(context, constants.PROG90)
    sql_display.put("err_msg", fun_err_msg)
    return sql_display


# Oracle数据库版本查询方法
def ssh_oracle_execute(CLI, sql_display, fun_err_msg_temp, context, LOGGER):
    exitCmd = 'exit'
    sql_whoami = CLI.execSql("whoami").getSqlResult()
    # dbcon 框架已经已经进入sql模式，执行数据库外部命令需要退出sql到root权限。
    if "SQL>" in sql_whoami:
        CLI.execSql(exitCmd)
    if "root" not in sql_whoami:
        CLI.execSql(exitCmd)

    sql_display_temp = CLI.execSql("ps -ef|grep pmon|cat").getSqlResult()
    sql_display.put("sql_display_database_basic_asm", sql_display_temp)
    fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                         "ps -ef | grep pmon",
                                         fun_err_msg_temp)
    # 解析获取ASM值
    splitlines = sql_display_temp.splitlines()
    ORACLE_SID = ""
    ORACLE_HOME = ""
    ASMUSER = ""
    for line in splitlines:
        if "asm_pmon_" in line:
            splits = line.strip().split()
            str = splits[len(splits) - 1]
            ORACLE_SID = str[str.find("asm_pmon_") + constants.NINE:]

    util.updateItemProgress(context, constants.PROG40)
    sql_display_temp = CLI.execSql("ps -ef|grep "
                                   "ocssd.bin|cat").getSqlResult()
    sql_display.put("sql_display_database_basic_ocssd_bin",
                    sql_display_temp)
    fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                         "ps -ef|grep ocssd.bin|cat",
                                         fun_err_msg_temp)
    splitlines = sql_display_temp.splitlines()

    for line in splitlines:
        if "/bin/ocssd.bin" in line:
            splits = line.strip().split()
            ASMUSER = splits[0].strip()
            str = splits[len(splits) - 1]
            ORACLE_HOME = str[0:str.find("/bin/ocssd.bin")]
    util.updateItemProgress(context, constants.PROG45)
    sql_display_temp = CLI.execSql(
        ORACLE_HOME + "/bin/crsctl check cluster").getSqlResult()
    sql_display.put("sql_display_database_basic_crsctl", sql_display_temp)
    fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                         ORACLE_HOME + "/bin/crsctl "
                                                       "check cluster;",
                                         fun_err_msg_temp)

    sql_display_temp = CLI.execSql(
        ORACLE_HOME + "/bin/olsnodes -s").getSqlResult()
    sql_display.put("sql_display_database_basic_olsnodes", sql_display_temp)
    fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                         ORACLE_HOME + "/bin/olsnodes -s",
                                         fun_err_msg_temp)

    sql_display_temp = CLI.execSql(
        ORACLE_HOME + "/bin/cemutlo -n").getSqlResult()
    sql_display.put("sql_display_database_basic_cemutlo", sql_display_temp)
    fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                         ORACLE_HOME + "/bin/cemutlo -n",
                                         fun_err_msg_temp)
    util.updateItemProgress(context, constants.PROG50)
    if ASMUSER and ORACLE_HOME and ORACLE_SID:
        LOGGER.info(
            "ASMUSER: " + ASMUSER + " ORACLE_HOME: " + ORACLE_HOME +
            " ORACLE_SID :" + ORACLE_SID)
        # 切换至ASMUSER权限，前提为root权限
        sql_display_temp = CLI.execSql("su - " + ASMUSER).getSqlResult()
        sql_display.put("sql_display_database_basic_su_" + ASMUSER,
                        sql_display_temp)
        fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                             "su - " + ASMUSER,
                                             fun_err_msg_temp)

        sql_display_temp = CLI.execSql("srvctl config scan").getSqlResult()
        sql_display.put("sql_display_database_basic_scan",
                        sql_display_temp)
        fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                             "srvctl config scan",
                                             fun_err_msg_temp)

        sql_display_temp = CLI.execSql("srvctl config "
                                       "nodeapps").getSqlResult()
        sql_display.put("sql_display_database_basic_nodeapps",
                        sql_display_temp)
        fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                             "srvctl config nodeapps",
                                             fun_err_msg_temp)
        util.updateItemProgress(context, constants.PROG55)
        # SQL命令查询
        # 环境变量设置
        CLI.execSql("export ORACLE_SID=" + ORACLE_SID)
        CLI.execSql("export ORACLE_HOME=" + ORACLE_HOME)
        sql_display_temp = CLI.execSql("sqlplus / as "
                                       "sysasm").getSqlResult()
        sql_display.put("sql_display_database_basic_sqlplus",
                        sql_display_temp)
        fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                             "sqlplus / as sysasm;",
                                             fun_err_msg_temp)

        # 设置回显格式
        CLI.execSql("set linesize 1000")
        CLI.execSql("col path for a40")
        CLI.execSql("col name for a20")
        CLI.execSql("col path for a50")
        CLI.execSql("col value for a20")
        CLI.execSql("col describe for a100")

        sql_display_temp = CLI.execSql(
            "select instance_name,host_name from "
            "v$instance").getSqlResult()
        sql_display.put("sql_display_database_basic_instance_name",
                        sql_display_temp)
        fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                             "select instance_name,"
                                             "host_name from v$instance",
                                             fun_err_msg_temp)
        util.updateItemProgress(context, constants.PROG60)
        sql_display_temp = CLI.execSql(
            "select NAME,VALUE from v$parameter where NAME "
            "like 'local_listener'").getSqlResult()
        sql_display.put("sql_display_database_basic_local_listener",
                        sql_display_temp)
        fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                             "select NAME,VALUE "
                                             "from v$parameter "
                                             "where NAME like "
                                             "'local_listener'",
                                             fun_err_msg_temp)
        util.updateItemProgress(context, constants.PROG65)
        sql_display_temp = CLI.execSql(
            "select * from v$version").getSqlResult()
        sql_display.put("sql_display_database_basic_v$version",
                        sql_display_temp)
        fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                             "select * from v$version",
                                             fun_err_msg_temp)

        asm_diskgroup_sql = "select group_number gno,name,state,type,total_mb,free_mb,sector_size from v$asm_diskgroup"
        sql_display_temp = CLI.execSql(asm_diskgroup_sql).getSqlResult()
        sql_display.put("sql_display_database_basic_v$asm_diskgroup", sql_display_temp)
        fun_err_msg_temp += deal_fun_err_msg(sql_display_temp, asm_diskgroup_sql, fun_err_msg_temp)

        sql_display_temp = CLI.execSql(
            r"select a.ksppinm name,b.ksppstvl value,a.ksppdesc "
            r"describe from x$ksppi a,x$ksppcv b "
            r"where a.inst_id = userenv('instance') and b.inst_id = "
            r"userenv('instance') and a.indx = "
            r"b.indx and a.ksppinm like '\_asm_hbeatio%' "
            r"escape '\'").getSqlResult()
        sql_display.put("sql_display_database_basic_x$ksppi_x$ksppcv",
                        sql_display_temp)
        fun_err_msg_temp += deal_fun_err_msg(sql_display_temp,
                                             r"select a.ksppinm name,"
                                             r"b.ksppstvl value,a.ksppdesc"
                                             r" describe "
                                             r"from x$ksppi a,x$ksppcv b "
                                             r"where a.inst_id = "
                                             r"userenv('instance') and"
                                             r" b.inst_id = "
                                             r"userenv('instance') "
                                             r"and a.indx = b.indx "
                                             r"and a.ksppinm "
                                             r"like '\_asm_hbeatio%' "
                                             r"escape '\'",
                                             fun_err_msg_temp)

        asm_disk_sql = "select name,path,group_number, disk_number,mount_status,header_status,mode_status,state," \
                       "sector_size from v$asm_disk"
        sql_display_temp = CLI.execSql(asm_disk_sql).getSqlResult()
        sql_display.put("sql_display_database_basic_v$asm_disk", sql_display_temp)
        fun_err_msg_temp += deal_fun_err_msg(sql_display_temp, asm_disk_sql, fun_err_msg_temp)
        util.updateItemProgress(context, constants.PROG70)

    return fun_err_msg_temp


def deal_fun_err_msg(sql_display_temp, cmd, fun_err_msg):
    if sql_display_temp is None or '' == sql_display_temp or \
            'TOOLKIT_SEND_SQL_TIME_OUT' == sql_display_temp:
        if "en" == LANGUAGE:
            fun_err_msg = cmd + ":\texecute failed\r\n"
        else:
            fun_err_msg = cmd + u":\t执行失败\r\n"
    else:
        if "en" == LANGUAGE:
            fun_err_msg = cmd + ":\texecute success\r\n"
        else:
            fun_err_msg = cmd + u":\t执行成功\r\n"

    return fun_err_msg
