# coding=utf-8
__author__ = '******'
# 获取oracle数据库的表空间大小
import re
import sys
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import util
from common import constants
CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
sql_info = {"sql_info_tablespace_size"          :       "select tablespace_name,sum(bytes)/1024/1024 M from dba_segments group by tablespace_name",
          "sql_info_tablespace_mrtempsize"      :       "select username,DEFAULT_TABLESPACE,TEMPORARY_TABLESPACE from dba_users where account_status='OPEN'", 
          "sql_info_tablespace_configuration"   :       "select TABLESPACE_NAME, INITIAL_EXTENT, NEXT_EXTENT,MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE, MIN_EXTLEN, STATUS, CONTENTS, LOGGING, EXTENT_MANAGEMENT, ALLOCATION_TYPE, BLOCK_SIZE, FORCE_LOGGING, SEGMENT_SPACE_MANAGEMENT from dba_tablespaces",
          
          
          "sql_info_tablespace_constraints"     :       "select count(*) from dba_constraints",
          
          "sql_info_tablespace_owner"          :       "select owner,count(*) from dba_constraints where owner in (select owner from dba_constraints) group by owner" ,
          "sql_info_tablespace_ dba_indexes"    :       "select count(*) from dba_indexes" ,
          "sql_info_tablespace_indexes"         :       " select owner,count(*) from dba_indexes where owner in (select owner from dba_indexes) group by owner",
          "sql_info_tablespace_function"        :       "select count(*) from sys.all_objects where upper(object_type) = upper('function')",
          
          "sql_info_tablespace_upper"           :       "select owner,count(*) from sys.all_objects where upper(object_type) = upper('function') group by owner",
          "sql_info_tablespace_procedure"       :       " select count(*) from sys.all_objects where upper(object_type) = upper('procedure')",
          "sql_info_tablespace_object_type"     :       "select owner,count(*) from sys.all_objects where upper(object_type) = upper('procedure') group by owner",
          "sql_info_tablespace_package"         :       "select count(*) from sys.all_objects where upper(object_type) = upper('package')",
          
           "sql_info_tablespace_sysalL"         :       "select owner,count(*) from sys.all_objects where upper(object_type) = upper('package') group by owner" , 
           "sql_info_tablespace_dba_views"      :       "select count(*) from dba_views",
           "sql_info_tablespace_owner_count"    :       "select owner,count(*) from dba_views group by owner",
           "sql_info_tablespace_synonyms"       :       "select count(*) from sys.all_synonyms",
           
           "sql_info_tablespace_owner_synonyms" :       "select owner,count(*) from sys.all_synonyms group by owner",
           "sql_info_tablespace_dba_sequences"  :       "select count(*) from dba_sequences",
           "sql_info_tablespace_countseq"       :       "select sequence_owner,count(*) from dba_sequences where sequence_owner in (select sequence_owner from dba_sequences) group by sequence_owner",
           "sql_info_tablespace_counttrigger"   :       "select count(*) from dba_triggers",
           
           "sql_info_tablespace_ownerconunt"    :       "select owner,count(*) from dba_triggers where owner in (select owner from dba_triggers) group by owner",
           "sql_info_tablespace_dbajobs"        :       "select * from dba_jobs",
           "sql_info_tablespace_countdbajobs"   :       "select count(*) from dba_jobs",
           
           "sql_info_tablespace_countuser"      :       "select SCHEMA_USER,count(*) from dba_jobs group by schema_user"
           
          }






def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("DBConn")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    sql_display = context.get("ret_map")
    return check_and_get_result(sql_execute(sql_display, CLI, LANGUAGE,context))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def sql_execute(sql_display, CLI, LANGUAGE,context):
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    prgStep = constants.PROG75 / len(sql_info)
    curstep = constants.PROG15
    util.updateItemProgress(context, curstep)
    for item in sql_info:
        sql_display_temp = CLI.execSql(sql_info.get(item))
        curstep += prgStep
        util.updateItemProgress(context, curstep)
        sql_display.put("sql_display"+(item)[8:], sql_display_temp)
        if None == sql_display_temp.getSqlResult() or '' == sql_display_temp.getSqlResult() or 'TOOLKIT_SEND_SQL_TIME_OUT' == sql_display_temp.getSqlResult():
            if "en"==LANGUAGE:
                fun_err_msg        +=sql_info.get(item) + ":\texecute failed\r\n"
            else:
                fun_err_msg        +=sql_info.get(item) + u":\t执行失败\r\n"
        else:
            if "en"==LANGUAGE:
                fun_err_msg        +=sql_info.get(item) + ":\texecute success\r\n"
            else:
                fun_err_msg        +=sql_info.get(item) + u":\t执行成功\r\n"
    sql_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, sql_display, fun_err_msg