# coding=utf-8
__author__ = '******'
# 获取oracle数据库的归档信息
import re
import sys
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import util
from common import constants
CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
sql_info = {"sql_info_vote_disk"      :       "crsctl query css votedisk"}

sql_exit = 'exit'
sql_enter = "sqlplus \"/as sysdba\""
sql_size = 'set linesize 3000'
sql_whoami = 'whoami'
sql_cmd = 'ocssd.bin'
sql_find = "ps -ef |grep ocssd|awk '{print $8}'"
sql_export_path_example = 'export PATH=$PATH:YOUR_VIVID_PATH'
def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("DBConn")
    global ctx
    ctx = context
    global LANGUAGE
    LANGUAGE = context.get("lang")
    sql_display = context.get("ret_map")
    global path
    util.updateItemProgress(context, constants.PROG5)
    back2root()
    if None != CLI.execSql(sql_find).getSqlResult() and '' != CLI.execSql(sql_find).getSqlResult():
        util.updateItemProgress(context, constants.PROG30)
        pathStr = str(CLI.execSql(sql_find).getSqlResult()).splitlines()[1]
        util.updateItemProgress(context, constants.PROG35)
        path = pathStr.replace(sql_cmd, '')
    else:
        path = ''
    sql_export_path = sql_export_path_example.replace('YOUR_VIVID_PATH', path)
    CLI.execSql(sql_export_path)
    util.updateItemProgress(context, constants.PROG45)
    (fun_flag, result, fun_err_msg) = sql_execute(sql_display, CLI, LANGUAGE)
    back2sql()
    return check_and_get_result((fun_flag, result, fun_err_msg))

def back2root():
    global name
    CLI.execSql(sql_exit)
    util.updateItemProgress(ctx, constants.PROG10)
    name = str(CLI.execSql(sql_whoami).getSqlResult()).lower()
    util.updateItemProgress(ctx, constants.PROG15)
    if not name.__contains__('root'):
        CLI.execSql(sql_exit)
        util.updateItemProgress(ctx, constants.PROG20)

def back2sql():
    CLI.execSql('su - oracle')
    util.updateItemProgress(ctx, constants.PROG70)
    CLI.execSql(sql_enter)
    util.updateItemProgress(ctx, constants.PROG80)
    CLI.execSql(sql_size)
    util.updateItemProgress(ctx, constants.PROG90)

# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def sql_execute(sql_display, CLI, LANGUAGE):
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    prgStep = constants.PROG15 / len(sql_info)
    curstep = constants.PROG45
    for item in sql_info:
        sql_display_temp = CLI.execSql(sql_info.get(item))
        curstep += prgStep
        util.updateItemProgress(ctx, curstep)
        sql_display.put("sql_display"+(item)[8:], sql_display_temp)
        if None == sql_display_temp.getSqlResult() or '' == sql_display_temp.getSqlResult() or sql_display_temp.getSqlResult().find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or  sql_display_temp.getSqlResult().find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en"==LANGUAGE:
                fun_err_msg        +=sql_info.get(item) + ":\texecute failed\r\n"
            else:
                fun_err_msg        +=sql_info.get(item) + u":\t执行失败\r\n"
        else:
            if "en"==LANGUAGE:
                fun_err_msg        +=sql_info.get(item) + ":\texecute success\r\n"
            else:
                fun_err_msg        +=sql_info.get(item) + u":\t执行成功\r\n"
    sql_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, sql_display, fun_err_msg