# -*- coding: UTF-8 -*-
import re
import sys
import traceback
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common.contentParse import singleCmdExecute, saveAluaStatusAndCliRet2ForeEval
from common import util
from common import constants

cliRets = []
LINE_BREAK = "\n"
NUM_INT_3 = 3
queryAluaStatusFailedDisks = []
ALUA_ENABLED = 'enabled'
ALUA_NOT_ENABLED = 'not enabled'
ALUA_UNKNOW = 'unknown'
NOT_SUPPORT = 'Not Support'
ALUA_UNBUSINESS = 'noBusiness'

def execute(context):
    '''
    @param context: execute context 
    '''
    global LOGGER
    LOGGER = context.get("Logger")
    try:
        executeStatus, disks = queryHuaweiDisk(context)
        util.updateItemProgress(context, constants.PROG10)
        if not executeStatus:
            util.updateItemProgress(context, constants.PROG95)
            return saveAluaStatusAndCliRet2ForeEval(ALUA_UNKNOW, LINE_BREAK.join(cliRets), context)
        if not disks:
            util.updateItemProgress(context, constants.PROG95)
            return saveAluaStatusAndCliRet2ForeEval(ALUA_NOT_ENABLED, LINE_BREAK.join(cliRets), context)
        executeResult = getAluaStatus(disks, context)
        util.updateItemProgress(context, constants.PROG95)
        saveAluaStatusAndCliRet2ForeEval(executeResult, LINE_BREAK.join(cliRets), context)   
    except:
        msg = traceback.format_exc()
        LOGGER.error("execute alua configure info ==> " + msg)
        saveAluaStatusAndCliRet2ForeEval(ALUA_UNKNOW, LINE_BREAK.join(cliRets), context)   

def queryHuaweiDisk(context):
    '''
    @summary: query the available huawei disks
    @return: (execute status: True or False, disk list)
    '''
    try:
        disks = []
        command = 'lsdev -Cc disk | grep -i huawei'
        executeStatus, cliRet = singleCmdExecute(context, command, 'query_huawei_disk', True)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.info("***[execute queryHuaweiDisk failure]***")
            return False, disks 
        for line in cliRet.splitlines():
            avilableDisk = filter(lambda item : item.lower() == 'available', line.split())
            if not avilableDisk:
                continue
            diskName = line.strip().split()[0]
            if diskName:
                disks.append(diskName)
        LOGGER.info("execute queryHuaweiDisk, disks is : %s" % disks)
        return True, disks
    except:
        msg = traceback.format_exc() 
        LOGGER.error("queryHuaweiDisk ==> " + msg)
        return False, []

def getAluaStatus(disks, context):
    '''
    @summary: get the final status of all disks
    '''
    stepProgress = int(constants.PROG80 / len(disks))
    currentProgress = constants.PROG10
    noBusinessFlag = False
    unKnowFlag = False
    for disk in disks:
        currentProgress += stepProgress
        executeResult = queryAndCheckDiskAlua(disk, context)
        util.updateItemProgress(context, currentProgress)
        if executeResult == ALUA_ENABLED:
            return executeResult
        if executeResult == ALUA_UNBUSINESS:
            noBusinessFlag = True
        if executeResult == ALUA_UNKNOW:
            unKnowFlag = True
    if unKnowFlag:
        return ALUA_UNKNOW
    if noBusinessFlag:
        return ALUA_UNBUSINESS       
    return ALUA_NOT_ENABLED
    
def queryAndCheckDiskAlua(disk, context):
    '''
    @summary: query the alua configure information of disk and check the information
    @return: (check result: True or False)
    '''
    try:
        executeStatus, executeResult = checkPathStatus(disk, context)
        LOGGER.info("query the path status of disk: %s, the status: %s, the result: %s" % (disk, executeStatus, executeResult))
        if executeStatus != NOT_SUPPORT:
            return executeResult
        executeStatus, executeResult = checkAluaRoundRobin(disk, context)
        LOGGER.info("query the round robin of disk: %s , the status: %s, the result: %s" % (disk, executeStatus, executeResult))
        return executeResult
    except:
        msg = traceback.format_exc() 
        LOGGER.error("queryAndCheckDiskAlua ==> " + msg)
        return ALUA_UNKNOW

def checkAluaRoundRobin(disk, context):
    '''
    @summary: check if there is "round_robin" 
    '''
    try:
        command = 'lsattr -EHl %s' % disk
        executeStatus, cliRet = singleCmdExecute(context, command, 'query_alua_disk_%s' % disk, True)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.info("***[query the disk : %s alua info failure]***" % disk)
            return False, ALUA_UNKNOW  
        for line in cliRet.splitlines():
            stripLine = line.strip()
            if not stripLine.lower().startswith('algorithm'):
                continue
            if 'round_robin' in stripLine.lower():
                return True, ALUA_ENABLED
            else:
                return True, ALUA_NOT_ENABLED
        return False, ALUA_UNKNOW 
    except:
        msg = traceback.format_exc() 
        LOGGER.error("checkAluaRoundRobin ==> " + msg)
        return False, ALUA_UNKNOW

def checkPathStatus(disk, context):
    '''
    @summary: check the disk path status
    '''
    try:
        command = 'lsmpio -l %s' % disk
        executeStatus, cliRet = singleCmdExecute(context, command, 'query_alua_disk_path_status%s' % disk, True)
        cliRets.append(cliRet)
        if 'not found' in cliRet:
            return NOT_SUPPORT, ALUA_UNKNOW 
        if executeStatus != True:
            LOGGER.info("***[query the disk path status : %s info failure]***")
            return False, ALUA_UNKNOW  
        optFlag = False
        nonFlag = False
        cloFlag = False
        for line in cliRet.splitlines():
            stripLine = line.strip().lower()
            if not stripLine.startswith(disk):
                continue
            datas = re.split('\s+', stripLine)
            if len(datas) != 6:
                return False, ALUA_UNKNOW 
            if 'opt' in datas[NUM_INT_3]:
                optFlag = True
            if 'non' in datas[NUM_INT_3]:
                nonFlag = True
            if 'clo' in datas[NUM_INT_3]:
                cloFlag = True
        if optFlag and nonFlag:
            return True, ALUA_ENABLED
        if cloFlag:
            return True, ALUA_UNBUSINESS           
        return True, ALUA_NOT_ENABLED 
    except:
        msg = traceback.format_exc() 
        LOGGER.error("checkPathStatus ==> " + msg)
        return False, ALUA_UNKNOW
