# coding=utf-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import util
from common import constants
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import AIX

cmd_info_id = [
    "cmd_info_database_object_grid",
    "cmd_info_database_grid_cluster_name",
    "cmd_info_database_grid_cluster_status",
    "cmd_info_database_grid_cluster_vote",
    "cmd_info_database_grid_ocr_disk_path",
    "cmd_info_database_sqlplus",
    "cmd_info_database_set_linesize",
    "cmd_info_database_set_pagesize",
    "cmd_info_database_set_colpath",
    "cmd_info_database_set_colname",
]

cmd_info_desc = [
    "su - grid",
    "olsnodes -s",
    "crsctl stat res -t",
    "crsctl query css votedisk",
    "ocrcheck",
    "sqlplus / as sysdba",
    "set linesize 200",
    "set pagesize 300",
    "column path for a40",
    "column name for a30",
]

select_asm_disk_group = "select group_number,name,state,total_mb,free_mb,sector_size from v$asm_diskgroup;"
select_asm_disk = "select group_number,disk_number,name,mount_status,header_status,path,state,total_mb,free_mb," \
                  "sector_size from v$asm_disk;"
sql_info = {
    "sql_info_cluster_ora_cversion": "select * from v$version;",
    "sql_info_cluster_database": "select value from v$parameter where name='cluster_database';",
    "sql_info_cluster_ora_diskgroupinfo": select_asm_disk_group,
    "sql_info_cluster_ora_diskinfo": select_asm_disk,
    "sql_info_cluster_ora_asmdiskpathinfo": "show parameter asm_diskstring",
}


def execute(context):
    """
    :param context: 上下文
    :return: 以字典格式返回命令执行结果
    """
    cli = context.get("SSH")
    lan = context.get("lang")
    cmd_display = context.get("ret_map")
    return cmd_execute(context, cmd_display, cli, lan)


def cmd_execute(context, cmd_display, cli, lan):
    prg_step = constants.PROG25 / len(cmd_info_id)
    cur_step = prg_step
    sql_flag = True
    oracle_flag = True
    fun_err_msg = ''
    for rg in range(len(cmd_info_id)):
        cmd_display_tmp = cli.execCmdHasLogTimout(
            get_sudo_cmd(cmd_info_desc[rg], AIX, context), 60)
        cur_step += prg_step
        util.updateItemProgress(context, cur_step)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_tmp)
        if cmd_display_tmp is None or '' == cmd_display_tmp \
                or cmd_display_tmp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                or cmd_display_tmp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en" == lan:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行失败\r\n"
        elif "en" == lan:
            fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
        else:
            fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"

        if cmd_display_tmp.find('not-found') > 0 \
                or cmd_display_tmp.find('not found') > 0 \
                or cmd_display_tmp.find('Permission denied') > 0:
            sql_flag = False
        if cmd_info_desc[rg] == "su - grid" \
                and cmd_display_tmp.find("not exist") > 0:
            cmd_display_tmp = cli.execCmdHasLogTimout(
                get_sudo_cmd("su - oracle", AIX, context), 60)
            if cmd_display_tmp.find("not exist") > 0:
                oracle_flag = False
        if cmd_info_desc[rg] == "sqlplus / as sysdba" \
                and "SQL>".lower() not in cmd_display_tmp.lower():
            sql_flag = False
    cmd_display.put("err_msg", fun_err_msg)

    cmd_ret_tmp = cli.execCmdHasLogTimout("whoami", 60)
    # 有命令失败，sql_flag = False，但是sqlplus / as sysdba进入sql模式，需退出
    if "SQL>" in cmd_display_tmp and not sql_flag:
        cli.execDbCmdNoLogTimout("exit", 60)
        cli.execDbCmdNoLogTimout("exit", 60)
    if "oracle" not in cmd_ret_tmp.lower() \
            and "grid" not in cmd_ret_tmp.lower():
        oracle_flag = False

    if oracle_flag and not sql_flag:
        cli.execDbCmdNoLogTimout("exit", 60)
        cmd_ret_tmp = cli.execCmdHasLogTimout("whoami", 60)
        if "oracle" in cmd_ret_tmp or "grid" in cmd_ret_tmp:
            cli.execDbCmdNoLogTimout("exit", 60)
    if sql_flag:
        prg_step = constants.PROG65 / len(sql_info)
        cur_step = constants.PROG25
        for item in sql_info:
            cur_step += prg_step
            util.updateItemProgress(context, cur_step)
            cmd_display_tmp = cli.execDbCmdNoLogTimout(sql_info.get(item), 60)
            cmd_display.put("sql_display" + (item)[8:], cmd_display_tmp)
            if cmd_display_tmp is None or '' == cmd_display_tmp or \
                    cmd_display_tmp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                    or cmd_display_tmp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en" == lan:
                    fun_err_msg += sql_info.get(item) + ":\texecute failed\r\n"
                else:
                    fun_err_msg += sql_info.get(item) + u":\t执行失败\r\n"
            elif "en" == lan:
                fun_err_msg += sql_info.get(item) + ":\texecute success\r\n"
            else:
                fun_err_msg += sql_info.get(item) + u":\t执行成功\r\n"
        cmd_display.put("err_msg", fun_err_msg)
        # 退出sqlplus
        cli.execDbCmdNoLogTimout("exit", 60)
        # 退出数据库当前用户
        cli.execDbCmdNoLogTimout("exit", 60)

    return cmd_display
