# coding=utf-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.
# 获取linux主机的集群信息
from common import constants
from common import util

CHECK_FAIL = 0
CHECK_PASS = 1
cmd_info_id = [
    "cmd_info_cluster_hacmp_powerHA_version",
    "cmd_info_cluster_hacmp_powerHA_cltopinfo",
    "cmd_info_cluster_hacmp_powerHA_clshowres",
    "cmd_info_cluster_hacmp_powerHA_process_status",
    "cmd_info_cluster_hacmp_powerHA_cllscf",
    "cmd_info_cluster_hacmp_powerHA_cllsclstr",
    "cmd_info_cluster_hacmp_powerHA_cllsnode",
    "cmd_info_cluster_hacmp_powerHA_cllsnw",
    "cmd_info_cluster_hacmp_powerHA_cllsif",
    "cmd_info_cluster_hacmp_powerHA_clrginfo_v",
]

cmd_info_desc = [
    "lslpp -L | grep -i cluster",
    "/usr/es/sbin/cluster/utilities/cltopinfo",
    "/usr/es/sbin/cluster/utilities/clshowres",
    "/usr/es/sbin/cluster/clstat -o",
    "/usr/es/sbin/cluster/utilities/cllscf",
    "/usr/es/sbin/cluster/utilities/cllsclstr",
    "/usr/es/sbin/cluster/utilities/cllsnode",
    "/usr/es/sbin/cluster/utilities/cllsnw",
    "/usr/es/sbin/cluster/utilities/cllsif",
    "/usr/es/sbin/cluster/utilities/clrginfo -v",
]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    cli = context.get("SSH")
    language = context.get("lang")
    cmd_display = context.get("ret_map")
    return cmd_execute(context, cmd_display, cli, language)


def cmd_execute(context, cmd_display, cli, language):
    tempStep = constants.PROG85 / len(cmd_info_id)
    curStep = tempStep
    fun_err_msg = ''
    for rg in range(len(cmd_info_id)):
        cmd_display_temp = cli.execCmdNoLogTimout(cmd_info_desc[rg], 60)
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_temp)
        if not cmd_display_temp \
                or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en" == language:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en" == language:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    return cmd_display
