# coding=utf-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.
__author__ = '******'
# 获取AIX主机的集群信息

from common import constants
from common import util
from common.contentParse import getCommandRet
from hosts.sudo_utils import get_sudo_cmd_desc
from hosts.sudo_utils import AIX

cmd_info_id = [
    "cmd_info_cluster_lslpp_cluster",
    "cmd_info_cluster_lslpp_i_cluster",
    "cmd_info_cluster_clstat",
    "cmd_info_cluster_clstat2",
    "cmd_info_cluster_cluster_nodes",
    "cmd_info_cluster_gpfs_cluster",
    "cmd_info_cluster_gpfs_conf",
    "cmd_info_cluster_gpfs_nodes",
    "cmd_info_cluster_gpfs_nsd_m",
    "cmd_info_cluster_gpfs_nsd_l",
    "cmd_info_cluster_gpfs_nsd_X",
    "cmd_info_cluster_gpfs_nsddevices_info",
]

cmd_info_desc = [
    "lslpp -l|grep cluster",
    "lslpp -L |grep -i cluster",
    "clstat -o",
    "/usr/sbin/cluster/clstat -o",
    "lssrc -g cluster",
    "mmlscluster",
    "mmlsconfig",
    "mmgetstate -a",
    "mmlsnsd -m",
    "mmlsnsd -L",
    "mmlsnsd -X",
    "cat /var/mmfs/etc/nsddevices",
]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    util.updateItemProgress(context, constants.PROG5)
    context["totalPgr"] = constants.PROG85
    return getCommandRet(context, cmd_info_id, get_sudo_cmd_desc(cmd_info_desc, AIX, context))
