# coding=utf-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.
__author__ = '******'
# 获取aix主机的磁盘管理信息

from common import constants
from common import util
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import AIX

CLI = None
LANGUAGE = None
CHECK_FAIL = 0
CHECK_PASS = 1
cmd_info_id = ["cmd_info_disk_mgt_lsdev_disk",
               "cmd_info_disk_mgt_lsdev_disk_type",
               "cmd_info_disk_mgt_lspv",
               "cmd_info_disk_mgt_lsattr_el",
               "cmd_info_disk_mgt_bootinfo_hdisk",
               "cmd_info_disk_mgt_ls_dev",
               "cmd_info_disk_mgt_lspv_u",
               "cmd_info_disk_mgt_mpio_info",
               ]

cmd_info_desc = ["lsdev -Cc disk",
                 "lsdev -Cc disk -F type",
                 "lspv",
                 "lsattr -El ",
                 "bootinfo -s ",
                 "ls -al /dev/*",
                 "lspv -u",
                 "lsmpio",
                 ]

cmd_info_disk_list = "lsdev -Cc disk|awk '{print $1}'"


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return cmd_execute(context, cmd_display)


def cmd_execute(context, cmd_display):
    temp_step = constants.PROG85 / len(cmd_info_id)
    cur_step = temp_step
    fun_err_msg = ''
    disk_list = CLI.execCmdHasLog(cmd_info_disk_list).splitlines()
    for rg in range(len(cmd_info_id)):
        cur_step += temp_step
        util.updateItemProgress(context, cur_step)
        if cmd_info_id[rg] == "cmd_info_disk_mgt_lsattr_el" or cmd_info_id[rg] == "cmd_info_disk_mgt_bootinfo_hdisk":
            for disk in disk_list[1:]:
                cmd_display_temp = CLI.execCmdHasLogTimout(
                    get_sudo_cmd(cmd_info_desc[rg], AIX, context) + disk, 60)
                cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:] + "_" + disk, cmd_display_temp)
                if cmd_display_temp is None or '' == cmd_display_temp \
                        or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                        or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en" == LANGUAGE:
                        fun_err_msg += cmd_info_desc[rg] + disk + ":\texecute failed\r\n"
                    else:
                        fun_err_msg += cmd_info_desc[rg] + disk + u":\t执行失败\r\n"
                else:
                    if "en" == LANGUAGE:
                        fun_err_msg += cmd_info_desc[rg] + disk + ":\texecute success\r\n"
                    else:
                        fun_err_msg += cmd_info_desc[rg] + disk + u":\t执行成功\r\n"
        else:
            cmd_display_temp = CLI.execCmdHasLogTimout(cmd_info_desc[rg], 60)
            cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_temp)
            if cmd_display_temp is None or '' == cmd_display_temp \
                    or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                    or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en" == LANGUAGE:
                    fun_err_msg += cmd_info_desc[rg] + ":\texecute failed\r\n"
                else:
                    fun_err_msg += cmd_info_desc[rg] + u":\t执行失败\r\n"
            else:
                if "en" == LANGUAGE:
                    fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
                else:
                    fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    return cmd_display
