# coding=utf-8
'''
    DocStr: collect HyperMetro feature configuration on aix host
    Since: V3R1C00RC2
'''
import os
import re
import sys
path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
CURRENT_PATH = os.path.dirname(os.path.abspath(__file__))
sys.path.append(CURRENT_PATH)
CURRENT_PATH = os.path.join(CURRENT_PATH, "..\\..")
sys.path.append(CURRENT_PATH)

from common import util
from common import constants
CMD_MAP_MAPPED_DISK = {'id':'aix_hypermetro_mapped_disk' ,
                  'cmd' : 'lsdev -Cc disk'}
CMD_MAP_HYPERMETRO_PATH = {'id':'aix_hypermetro_path_info' ,
                         'cmd' : 'lsattr -EHl '}
VENDER_HUAWEI_FLAG = 'huawei'

def execute(context):
    '''
    @Function describe  : collect hpux host HyperMetro information
    @param context: context
    '''
    #不需要返回，返回值都放context里面了
    doGrab(context)

def doGrab(context):
    '''
    @summary: 整个采集流程
    '''
    cmdDisplay = context.get("ret_map")
    errMsgs = ""

    util.updateItemProgress(context, constants.PROG25)
    #检查映射的磁盘
    util.log.info(context, "[AIX] start to fetch hyperMetro configuration.")
    status, errMsg, cmdMappedDiskResult = getResultMsg(context, CMD_MAP_MAPPED_DISK['cmd'])
    cmdDisplay.put("cmd_display_" + CMD_MAP_MAPPED_DISK['id'], cmdMappedDiskResult)
    errMsgs += errMsg
    util.updateItemProgress(context, constants.PROG55)
    #获取所有华为的磁盘路径
    diskPathList = getHuaweiDiskPathList(context, cmdMappedDiskResult)
    if not status or not diskPathList:
        cmdDisplay.put("err_msg", errMsgs)
        util.updateItemProgress(context, constants.PROG85)
        return

    #检查每个磁盘的路径信息
    for diskPath in diskPathList:
        cmd = CMD_MAP_HYPERMETRO_PATH["cmd"] + diskPath
        status, errMsg, diskPathInfo = getResultMsg(context, cmd)
        cmdDisplay.put("cmd_display_" + CMD_MAP_HYPERMETRO_PATH['id'] + diskPath, diskPathInfo)
        errMsgs += errMsg

    util.updateItemProgress(context, constants.PROG85)
    cmdDisplay.put("err_msg", errMsgs)

def getHuaweiDiskPathList(context, cmdMappedDiskResult):
    '''
    @summary: get huawei's disk path
    @return: disk path list
    '''
    huaweiDisks = []
    cmdMappedDiskResult = cmdMappedDiskResult.lower()
    for line in cmdMappedDiskResult.splitlines():
        if VENDER_HUAWEI_FLAG in line:
            #确认为华为盘,保存磁盘id
            huaweiDisks.append(line.split()[0])
    util.log.info(context, "[AIX] all the huawei disks are : " + str(huaweiDisks))
    return huaweiDisks

def getResultMsg(context, stepName):
    '''
    @summary: get result status's message
    @param stepName: 命令
    '''
    sshCon = context.get("SSH")
    lang = context.get("lang")

    cmdResultTemp = sshCon.execCmdWithTimout(stepName, constants.HOST_CMD_TIMEOUT)

    resultMsg = ""
    status = True
    if not cmdResultTemp or\
        'TOOLKIT_SEND_CMD_TIME_OUT' in  cmdResultTemp or\
            'TOOLKIT_EXE_CMD_FAILED' in cmdResultTemp:
        status = False

    if "en" == lang:
        if status:
            resultMsg += stepName + ":\texecute success\r\n"
        else:
            resultMsg += stepName + ":\texecute failed\r\n"
    else:
        if status:
            resultMsg += stepName + u":\t执行成功\r\n"
        else:
            resultMsg += stepName + u":\t执行失败\r\n"

    return status, resultMsg, cmdResultTemp
