#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
from common.cmd_execute import DES, CMD, BaseCmdExecute

CMD_LIST = [
    {DES: "cmd_display_logic_volune_lslpp_l_vxvm", CMD: "lslpp -l | grep vxvm"},
    {DES: "cmd_display_logic_volune_lspv", CMD: "lspv"},
    {DES: "cmd_display_logic_volune_lsvg_vgname_vg", CMD: "lsvg"},
    {DES: "cmd_display_logic_volune_lsvg_vgname_lv", CMD: "lsdev|grep 'Logical volume'|awk '{print $1}'"},

]
VG_CMD_DICTS = [
    {DES: "cmd_display_logic_volune_lsvg_vgname_l_", CMD: "lsvg -l %s"},
    {DES: "cmd_display_logic_volune_lsvg_vgname_p_", CMD: "lsvg -p %s"},
]

PV_CMD_DICTS = [
    {DES: "cmd_display_logic_volune_lspv_pvname_", CMD: "lspv %s"},
    {DES: "cmd_display_logic_volune_lspv_pvname_l_", CMD: "lspv -l %s"},
]

LV_CMD_DICTS = [
    {DES: "cmd_display_logic_volune_lslv_lvname_", CMD: "lslv %s"},
]


def execute(context):
    """
    采集Aix主机逻辑卷信息
    :param context: 上下文
    :return: 执行结果
    """
    LogicVolumeInfo(context).execute()


class LogicVolumeInfo(BaseCmdExecute):
    def __init__(self, context):
        BaseCmdExecute.__init__(self, context, CMD_LIST)

    def execute(self):
        self.generate_relative_cmd_list(self.get_param_from_cmd("lsvg", 1), VG_CMD_DICTS)
        self.generate_relative_cmd_list(self.get_param_from_cmd("lspv|grep active|awk '{print $1}'", 1), PV_CMD_DICTS)
        self.generate_relative_cmd_list(self.get_param_from_cmd("lsdev|grep 'Logical volume'|awk '{print $1}'", 1),
                                        LV_CMD_DICTS)
        self.execute_pure_cmd_list()
