#  coding=UTF-8
#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@version: SmartKit V200R006C00
@time: 209/10/26
@file: aix_lun_wwn_info.py
@function:
@modify:
"""

import sys
import os
import traceback

current_absolute_path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(current_absolute_path, "..\\..")
sys.path.append(path)
from common.contentParse import create_result_info
from common import constants
from common.util import log, HostResultInfo, HostLunInfo, \
    create_lun_info, get_host_wwn_info, qryUltrapathVersion, \
    check_ultrapath_is_pass

LAUNCHER = "lscfg -vpl fcs* or lsdev | grep iscsi or lsattr -El iscsiX"


def get_result_info(context):
    """
    :param context:
    :return:
    """
    host_result_info = HostResultInfo()
    host_lun_info = HostLunInfo()
    cli = context.get("SSH")
    host_lun_info.set_host_id(cli.getHost())
    cli_rets = ''

    try:
        # from launcher get initiator info
        _, cli_rets, initiator_wwn = get_host_wwn_info(context)
        if initiator_wwn:
            host_lun_info.set_initiator(initiator_wwn)
            host_result_info.set_hosts(host_lun_info)
        else:
            log.info(context, "Cannot find host initiator info, set pass.")
            create_result_info(context, "True", cli_rets, LAUNCHER,
                               host_result_info)
            return

        # 获取多路径版本
        is_ultrapath_qry_succ, ultrapath_version, cli_ret = \
            qryUltrapathVersion(context)
        cli_rets += cli_ret

        if not is_ultrapath_qry_succ:
            log.error(context, 'Query ultrapath version failed.')
            fail_cmd = constants.QRY_ULTRAPATH_CMD
            create_result_info(context, "False", cli_rets, fail_cmd,
                               host_result_info)
            return

        if check_ultrapath_is_pass(context, ultrapath_version,
                                   constants.AIX_CONSISTENCY_ULTRAPATH_VER):
            create_result_info(context, "True", cli_rets, "",
                               host_result_info)
            log.info(context, 'ultrapath pass, return.')
            return

        is_qry_succ, fail_cmd, cli_ret, disk_wwn_dict = qry_lun_wwn_info(
            context)
        cli_rets += cli_ret
        if is_qry_succ:
            create_lun_info(host_lun_info, disk_wwn_dict)
            host_result_info.set_hosts(host_lun_info)
            create_result_info(context, "nocheck", cli_rets, "",
                               host_result_info)
        else:
            create_result_info(context, "False", cli_rets, fail_cmd,
                               host_result_info)
    except Exception as e:
        log.info(context, "get host result info exception:%s:%s" % (
            e, str(traceback.format_exc())))
        create_result_info(context, "False", cli_rets, '',
                           host_result_info)


def qry_lun_wwn_info(context):
    """
    :param context:
    :return:
    """
    cli = context.get("SSH")
    all_lun_wwn_dict = {}
    is_qry_succ, fail_cmd, cli_ret, disk_letters = query_disks_info(context)
    if not is_qry_succ:
        log.error(context, 'Query array managed by ultrapath failed.')
        return False, fail_cmd, cli_ret, {}

    for disk_letter in disk_letters:
        wwid = ''
        rdisk_ = "odmget -q 'name=%s and attribute=unique_id' CuAt" \
                 % disk_letter

        host_lun_id_cmd = "lspath -F 'name:parent:connection:status' -l %s" \
                          % disk_letter
        try:
            disk_wwn_ret = cli.execCmdWithNoCheckResult(
                rdisk_,
                constants.HOST_CMD_TIMEOUT)
            cli_ret += disk_wwn_ret
            host_lun_id_ret = cli.execCmdWithNoCheckResult(
                host_lun_id_cmd,
                constants.HOST_CMD_TIMEOUT)
            cli_ret += host_lun_id_ret

            for line in disk_wwn_ret.splitlines():
                line = line.strip().lower()

                if not line.startswith('value'):
                    continue
                split_datas = line.split('=')
                value_part = split_datas[-1].strip()
                if len(split_datas) > 1 and len(
                        value_part) >= constants.MAGIC_INT38:
                    wwid = \
                        value_part[constants.MAGIC_INT6:constants.MAGIC_INT38]
            # 查询host_lun_id
            host_lun_id_list = resolve_host_lun_id(context, host_lun_id_ret,
                                                   disk_letter)
            if wwid and wwid not in all_lun_wwn_dict.keys():
                all_lun_wwn_dict[wwid] = dict(disk_name=disk_letter,
                                              host_lun_id=host_lun_id_list)

            log.info(context, 'lun wwns are:' + str(all_lun_wwn_dict))

        except Exception as e:
            log.error(context,
                      'Query array IDs exception:%s:%s' %
                      (str(e), traceback.format_exc()))
            return False, rdisk_, cli_ret, {}

    return True, '', cli_ret, all_lun_wwn_dict


def resolve_host_lun_id(context, cliret, disk_letter):
    """
    提取host_lun_id的列表
    :param context: 上下文
    :param cliret: 回显集合
    :param disk_letter: 硬盘ID
    :return:
    """
    host_lun_id_list = []
    try:
        for line in cliret.splitlines():
            line = line.lower()
            if disk_letter.lower() in line and ':enabled' in line:
                has_host_id_str = line.split(':enabled')[0]
                if "," in has_host_id_str:
                    hex_host_lun_id = has_host_id_str.split(",")[1]
                    # 去除尾部12个字符
                    hex_host_lun_id = hex_host_lun_id[0:-12]
                    # 16进制转换为10进制
                    host_lun_id = int(hex_host_lun_id, 16)
                    host_lun_id_list.append(host_lun_id)
        return list(set(host_lun_id_list))
    except Exception as e:
        log.error(context,
                  'Failed to get host_lun_id:%s:%s' %
                  (str(e), traceback.format_exc()))
        return host_lun_id_list

def query_disks_info(context):
    """
    :param context:
    :return:
    """
    cli = context.get("SSH")
    disks = []
    cli_ret = ''
    vlu_id_cmd = 'lsdev -Cc disk'
    try:
        cli_ret = cli.execCmdWithNoCheckResult(vlu_id_cmd,
                                               constants.HOST_CMD_TIMEOUT)

        for line in cli_ret.splitlines():
            avilable_disk = filter(lambda item: item.lower() == 'available',
                                   line.split())
            if not avilable_disk:
                continue
            disk_name = line.strip().split()[0]
            if disk_name:
                disks.append(disk_name)
        log.info(context, "Query disk is : %s." % disks)
        return True, '', cli_ret, disks
    except Exception as e:
        log.error(context, 'Query disk exception:%s:%s' %
                  (str(e), traceback.format_exc()))
        return False, vlu_id_cmd, cli_ret, []
