# coding=utf-8
__author__ = '******'
# 获取aix主机的多路径信息

from common import util
from common import constants
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import AIX

CLI = None
LANGUAGE = None
cmd_info_id = ["cmd_info_multipath_hwselfdev_version",
               "cmd_info_multipath_path"
               ]
            
cmd_info_desc = ["upadm show version",
                 "upadm show path"
                 ]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    util.updateItemProgress(context, constants.PROG5)
    return cmd_execute(cmd_display, context)


def cmd_execute(cmd_display, context):
    fun_err_msg = ''
    prg_step, steps_unit = util.calcPerStepDetail(constants.PROG85, len(cmd_info_id))
    idx = 0
    for rg in range(len(cmd_info_id)):
        cmd_display_temp = CLI.execCmdNoLogTimout(
            get_sudo_cmd(cmd_info_desc[rg], AIX, context), 60)
        util.itemProgressIncr(context, idx, prg_step, steps_unit)
        idx += 1
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_temp)
        if None == cmd_display_temp or '' == cmd_display_temp \
                or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en" == LANGUAGE:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en" == LANGUAGE:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    return cmd_display
