# coding=utf-8
__author__ = '******'
# 获取aix主机的多路径信息
import os
import sys
path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import contentParse
from common import util
from common import constants
from aix_lun_wwn_info import get_result_info
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import AIX
CLI = None
LANGUAGE = None
CHECK_FAIL = 0
CHECK_PASS = 1


cmd_info_id = ["cmd_info_multipath_status_phypath" ,
               "cmd_info_multipath_status_lun_info",
               "cmd_info_multipath_status_hba_config",
               "cmd_info_multipath_MPIO_config",
               "cmd_info_multipath_AIX_config",
               "cmd_info_multipath_hwselfdev_version",
               "cmd_info_multipath_ultra_vlun"
               ]
                
cmd_info_desc = ["upadm show phypath",
                 "upadm show vlun",
                 "upadm chkconfig",
                 "lslpp -l odmcfg.fcp.MPIO.rte",
                 "lslpp -l odmcfg.fcp.AIX.rte",
                 "upadm show version",
                 "upadm show vlun type=all"
                 ]
lunParams = []
cmdInfoLunIds = []
cmdInfoLunDesc = []

CMD_INFO_LUN_QUERY_CMD = "upadm show vlun type=all |sed '1,2d;$d' |awk '{print $1}'"
HDISK_QUERY_LIST_CMD = "lsdev -Cc disk | grep FC"
HDISK_QUERY_HUAWEI_LIST_CMD = "lsdev -Cc disk|grep -i huawei|awk '{print $1}'"
HDISK_PATH_QUERY_CMD_PRIFIX = "lspath -F\"name:parent:connection:path_id:status\" -l "
QUERY_HDISK_SUFFIX = " |grep -E -i 'Enabled'"
QUERY_HWDISK_CMD_SUFFIX = " |grep -i 'Manufacturer' |grep -E -i 'huawei|huasy|symantec|hs|eisoo|udsafe|marstor|sanm|anystor|sugon|netposa'"
#命令发送超时时间
TIMEOUT = 300
def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmdDisplayMap = context.get("ret_map")
    global CONTEXT
    CONTEXT = context
    get_result_info(context)
    appendVlunInHuawei()
    return cmd_execute(cmdDisplayMap,context)

#新增命令：查询华为盘的Lun信息
def appendVlunInHuawei():
    lunHuaweiListStr = CLI.execCmdHasLog(HDISK_QUERY_HUAWEI_LIST_CMD).splitlines()
    if len(lunHuaweiListStr) > 1:
        for diskId in lunHuaweiListStr[1:]:
            cmd_info_desc.append("odmget -q \"name=%s and attribute=unique_id\" CuAt" % diskId)
            cmd_info_id.append("cmd_info_multipath_disk_luninfo_%s" % diskId)
            cmd_info_desc.append(
                "lspath -F'name:parent:connection:statu"
                "s' -l %s" % diskId)
            cmd_info_id.append("cmd_info_multipath_lspath_luninfo"
                               "_%s" % diskId)
    
    
def appendHdiskQueryCmds(cmdDisplayMap, fun_err_msg):
    '''
    @summary: 将查询hdisk命令进行拼接
    @param param: cmdDisplayMap 结果MAP
    @param fun_err_msg: 错误消息
    '''
    hdiskListStr = CLI.execCmdHasLog(HDISK_QUERY_LIST_CMD)
    if 'command not found' in hdiskListStr:
        return fun_err_msg
    hdiskList = hdiskListStr.splitlines()
    hdiskListDesc = "cmd_disaplay_cmd_info_multipath_hdiskList"
    fun_err_msg = errorMsgHandler(fun_err_msg, hdiskListStr, HDISK_QUERY_LIST_CMD)
    if 'failed' in fun_err_msg or '失败' in fun_err_msg:
        return fun_err_msg
    #将命令回显设置到评估结果和报告    
    contentParse.setCmdRet4EvalAndReport(cmdDisplayMap, hdiskListStr, hdiskListDesc)
    for hdisk in hdiskList[1:]:
        if "disk" not in hdisk:
            continue
        hdiskInfos = hdisk.split()
        cmdInfoLunIds.append("cmd_info_multipath_hdiskinfo_" + hdiskInfos[0])
        cmdInfoLunDesc.append("lscfg -vpl " + hdiskInfos[0] + QUERY_HWDISK_CMD_SUFFIX)
        cmdInfoLunIds.append("cmd_info_multipath_hdiskwwpn_" + hdiskInfos[0])
        cmdInfoLunDesc.append(HDISK_PATH_QUERY_CMD_PRIFIX + hdiskInfos[0] + QUERY_HDISK_SUFFIX)
    
    return fun_err_msg


def appendVlunQueryCmds(cmdDisplayMap, fun_err_msg, context):
    """
    @summary: 将查询Vlun命令进行拼接
    @param param: cmdDisplayMap 结果MAP
    @param fun_err_msg: 错误消息
    :param context: 上下文
    """
    lunListStr = CLI.execCmdHasLog(
        get_sudo_cmd(CMD_INFO_LUN_QUERY_CMD, AIX, context))
    lunListDisplayKey = "cmd_disaplay_cmd_info_multipath_vlunidList"
    fun_err_msg = errorMsgHandler(fun_err_msg, lunListStr, CMD_INFO_LUN_QUERY_CMD)
    contentParse.setCmdRet4EvalAndReport(cmdDisplayMap, lunListStr, lunListDisplayKey)
    lunList = lunListStr.splitlines()
    for lun in lunList[1:]:
        lun = lun.strip()
        if lun.isdigit():
            cmdInfoLunIds.append("cmd_info_multipath_lun_" + lun)
            cmdInfoLunDesc.append(
                get_sudo_cmd("upadm show vlun id=", AIX, context) + lun)
    for j in range(len(cmdInfoLunIds)):
        cmd_info_id.append(cmdInfoLunIds[j])
        cmd_info_desc.append(cmdInfoLunDesc[j])
    return fun_err_msg


def calcReduntPath(multiPaths, cmdDisplayMap, hdiskInfo):
    '''
    @summary: 计算链路是否含有冗余路径
    @param param: cmdDisplayMap 结果MAP
    @param param: hdiskInfo 具体的链路
    '''
    ctrlIdsInPath = []
    for path in multiPaths[1:]:
        strs = path.split(':')
        wwpnStrs = ''
        if len(strs) > 2 and ',' in path:
            wwpnStrs = strs[2][0:strs[2].index(',')]
            util.log.info(CONTEXT, path + "wwpnInfo:" + wwpnStrs)
            ctrlNodeId = util.parseWwpn(CONTEXT, wwpnStrs)
            ctrlIdsInPath.append(ctrlNodeId[-1])
            util.log.info(CONTEXT, "ctrlNodeId:" + str(ctrlNodeId))
    hasReduntPath = util.hasRedundantPathForCtrlIdPath(CONTEXT, ctrlIdsInPath, True)
    contentParse.setCmdRet4Eval(cmdDisplayMap, str(hasReduntPath), "reduntpathInfo:" + hdiskInfo)
    util.log.info(CONTEXT, "hasReduntPath:" + str(hasReduntPath) + "ctrlIds " + str(ctrlIdsInPath))

def cmd_execute(cmdDisplayMap,context):
    '''
    @summary: 程序主入口
    @param cmdDisplayMap: cmdDisplayMap 结果MAP
    '''
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cmdExecRtn = ''
    #拼接查询hdisk命令
    util.updateItemProgress(context, constants.PROG5)
    fun_err_msg = appendHdiskQueryCmds(cmdDisplayMap, fun_err_msg)
    #拼接查询Vlun命令
    fun_err_msg = appendVlunQueryCmds(cmdDisplayMap, fun_err_msg, context)
    util.updateItemProgress(context, constants.PROG10)
    #执行需要执行的命令
    idx = 0
    prgStep, stepsUnit = util.calcPerStepDetail(constants.PROG85, len(cmd_info_id))
    for rg in range(len(cmd_info_id)):
        cmdExecRtn = CLI.execCmdWithNoCheckResult(
            get_sudo_cmd(cmd_info_desc[rg], AIX, context), TIMEOUT)
        util.itemProgressIncr(context, idx, prgStep, stepsUnit)
        idx += 1
        #如果是查询链路信息，则计算是否含冗余路径
        if HDISK_PATH_QUERY_CMD_PRIFIX in cmd_info_desc[rg]:
            multiPaths = cmdExecRtn.splitlines()
            hdiskInfo = cmd_info_desc[rg].replace(HDISK_PATH_QUERY_CMD_PRIFIX, '')
            hdiskInfo = hdiskInfo.replace(QUERY_HDISK_SUFFIX, '')
            if "fscsi" not in cmdExecRtn:
                util.log.info(CONTEXT, "no fscsi cmdExecRtn:" + cmdExecRtn)
                continue
            #计算冗余路径信息
            calcReduntPath(multiPaths, cmdDisplayMap, hdiskInfo)
        #判断命令执行结果返回界面
        displayKey = "cmd_disaplay" + (cmd_info_id[rg])[8:]
        contentParse.setCmdRet4EvalAndReport(cmdDisplayMap, cmdExecRtn, displayKey)
        fun_err_msg = errorMsgHandler(fun_err_msg, cmdExecRtn, cmd_info_desc[rg])
        cmdDisplayMap.put("err_msg", fun_err_msg)
        fun_flag = CHECK_PASS
    return fun_flag, cmdDisplayMap, fun_err_msg

def errorMsgHandler(errorMessage, cmdReturn, cmdDesc):
    '''
    @summary: 计算链路是否含有冗余路径
    @param param: errorMessage 命令返回
    @param param: cmdDesc CMD描述
    '''
    if cmdReturn.find('command not found') > 0 or cmdReturn.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmdReturn.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        if "en" == LANGUAGE:
            errorMessage += cmdDesc + ":\texecute failed\r\n"
        else:
            errorMessage += cmdDesc + u":\t执行失败\r\n"
    else:
        if "en" == LANGUAGE:
            errorMessage += cmdDesc + ":\texecute success\r\n"
        else:
            errorMessage += cmdDesc + u":\t执行成功\r\n"
    return errorMessage
