#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from common.cmd_execute import DES, CMD, change_list_to_tuple, BaseCmdExecute

CMD_LIST = [
    {DES: "cmd_display_odmget_pddv", CMD: "odmget PdDv"},
    {DES: "cmd_display_odmget_pdat", CMD: "odmget PdAt"},
]

ODM_HDISK_CMD_DICTS = [
    {DES: "cmd_display_odm_", CMD: "odmget -q name=%s CuDv"},
]


def execute(context):
    """
    采集Aix主机迁移ODM相关信息
    :param context: 上下文
    :return: 执行结果
    """
    OdmInfo(context).execute()


class OdmInfo(BaseCmdExecute):
    def __init__(self, context):
        BaseCmdExecute.__init__(self, context)

    def execute(self):
        self.cmd_list = CMD_LIST
        self.generate_relative_cmd_list(change_list_to_tuple(self.get_disk_list()), ODM_HDISK_CMD_DICTS)
        self.execute_pure_cmd_list()

    def get_disk_list(self):
        """
        获取hdisk参数
        :return: 数据
        """
        result = []
        cmd = "lsdev -Cc disk"
        for line in self.exec_cmd(cmd).splitlines():
            if not line.strip():
                continue
            hdisk = line.split()[0]
            if hdisk.startswith("hdisk"):
                result.append(hdisk)
        return result
