# coding=utf-8
__author__ = '******'
# 获取linux主机的一些基础信息:名称、版本、CPU、内存等.
import os
import sys
path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common.contentParse import getCommandRet
from hosts.sudo_utils import get_sudo_cmd_desc
from hosts.sudo_utils import AIX

cmd_info_id = ["cmd_display_os_basic_uname",
               "cmd_info_os_basic_oslevel",
               "cmd_info_os_basic_bootinfo",
               "cmd_info_os_basic_prtconf",
               "cmd_info_os_basic_vmstat",
               "cmd_info_os_ifconfig",
               "cmd_info_os_mac",
               "cmd_info_os_route",
               "cmd_info_os_hosts",
               "cmd_info_os_hostnames",
               "cmd_info_install_software_info",
               ]
cmd_info_desc = ["uname -a",
                 "oslevel -s",
                 "bootinfo -K",
                 "prtconf",
                 "vmstat 1 5",
                 "ifconfig -a",
                 "netstat -ain",
                 "netstat -rn",
                 "cat /etc/hosts",
                 "hostname",
                 "lslpp -l",
                 ]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    context["totalPgr"] = constants.PROG85
    return getCommandRet(context, cmd_info_id,
                         get_sudo_cmd_desc(cmd_info_desc, AIX, context))
