﻿# coding=utf-8
__author__ = '******'
# 获取aix主机的storage foundation信息
import os
import re
import sys
path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common import util
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import AIX
CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
cmd_info_id = ["cmd_info_storage_foundation_hastatus_sum",
               "cmd_info_storage_foundation_lltstat_l",
               "cmd_info_storage_foundation_gabconfig_a",
               "cmd_info_storage_foundation_vxfenadm_d",
               "cmd_info_storage_foundation_hagrp_state",
               "cmd_info_storage_foundation_hares_state",
               "cmd_info_storage_foundation_hares_display",
               "cmd_info_storage_foundation_hagrp_display",
               "cmd_info_storage_foundation_hasys_list",
               "cmd_info_storage_foundation_cat_main_cf",
               "cmd_info_storage_foundation_vxddladm_namingscheme",
               "cmd_info_storage_foundation_vxdmpadm_dmpnode",
               "cmd_info_storage_foundation_vxdmpadm_getsubpaths",
               "cmd_info_storage_foundation_vxdmpadm_listctlr",
               "cmd_info_storage_foundation_vxdmpadm_listenclosure",
               "cmd_info_storage_foundation_vxdg_list",
               "cmd_info_storage_foundation_vxprint",
               "cmd_info_storage_foundation_vxprint_ht",
               "cmd_info_storage_foundation_vxprint_vt",
               "cmd_info_storage_foundation_vxprint_pt",
               "cmd_info_storage_foundation_vxdisk_e_list",
               "cmd_info_storage_foundation_vxdisk_list",
               "cmd_info_storage_foundation_vxdisk_o_alldgs_list",
               "cmd_info_storage_foundation_cat_vxfendg",
               "cmd_info_storage_foundation_vxdisk_path",
               "cmd_info_storage_foundation_vxdisk_list_diskname",
               "cmd_info_storage_foundation_VRTS"]
            
cmd_info_desc = ["hastatus -sum",
                 "lltstat -l",
                 "gabconfig -a",
                 "vxfenadm -d",
                 "hagrp -state",
                 "hares -state",
                 "hares -display",
                 "hagrp -display",
                 "hasys -list",
                 "cat /etc/VRTSvcs/conf/config/main.cf",
                 "vxddladm get namingscheme",
                 "vxdmpadm list dmpnode all",
                 "vxdmpadm getsubpaths",
                 "vxdmpadm listctlr all",
                 "vxdmpadm listenclosure all",
                 "vxdg list",
                 "vxprint",
                 "vxprint -ht",
                 "vxprint -vt",
                 "vxprint -pt",
                 "vxdisk -e list",
                 "vxdisk list",
                 "vxdisk -o alldgs list",
                 "cat /etc/vxfendg",
                 "vxdisk path",
                 "vxdisk list ",
                 "lslpp -l | grep VRTS"]
            
cmd_info_vxdisk_list              =   "vxdisk list|awk '{print $1}'"


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(context, cmd_display, CLI, LANGUAGE))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(context, cmd_display, CLI, LANGUAGE):
    tempStep = constants.PROG85 / len(cmd_info_id)
    curStep = tempStep
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    vxdisk_list = CLI.execCmdHasLog(
        get_sudo_cmd(cmd_info_vxdisk_list, AIX, context)).splitlines()
    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        if cmd_info_id[rg]=="cmd_info_storage_foundation_vxdisk_list_diskname":
            for vxdisk in vxdisk_list[2:]:
                cmd_display_temp = CLI.execCmdHasLogTimout(
                    get_sudo_cmd(cmd_info_desc[rg], AIX, context) + vxdisk, 60)
                cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:]+"_"+vxdisk, cmd_display_temp)
                if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg]+ vxdisk + ":\texecute failed\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg]+ vxdisk + u":\t执行失败\r\n"
                else:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg]+ vxdisk + ":\texecute success\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg]+ vxdisk + u":\t执行成功\r\n"
        else:
            cmd_display_temp = CLI.execCmdHasLogTimout(
                get_sudo_cmd(cmd_info_desc[rg], AIX, context), 60)
            cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
            if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
            else:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg