#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

from common import constants
from common import util
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import AIX

CLI = None
LANGUAGE = None
CHECK_FAIL = 0
CHECK_PASS = 1
cmd_info_id = ["cmd_info_multipath_mpio", "cmd_info_multipath_device_mapper"]
cmd_info_desc = ["mpio_get_config -Av", "rpm -qa |grep device-mapper"]

cmd_multipath_EMC_id = ['cmd_info_multipath_version_EMC', 'cmd_info_multipath_path_EMC']
cmd_multipath_EMC_desc = ['powermt version', 'powermt display dev=all']

cmd_multipath_IBM_id = ['cmd_info_multipath_version_IBM', 'cmd_info_multipath_path_IBM']
cmd_multipath_IBM_desc = ['lslpp -L |grep -i sddpcm', 'pcmpath query device']

cmd_multipath_HDS_id = ['cmd_info_multipath_sys_HDS',
                        'cmd_info_multipath_sys_HDS_with_env',
                        'cmd_info_multipath_lu_HDS',
                        'cmd_info_multipath_lu_HDS_with_env',
                        'cmd_info_multipath_path_HDS',
                        'cmd_info_multipath_path_HDS_with_env']

cmd_multipath_HDS_desc = ['dlnkmgr view -sys',
                          '/usr/DynamicLinkManager/bin/dlnkmgr view -sys',
                          'dlnkmgr view  -lu',
                          '/usr/DynamicLinkManager/bin/dlnkmgr view  -lu',
                          'dlnkmgr view -path',
                          '/usr/DynamicLinkManager/bin/dlnkmgr view -path']

cmd_multipath_id = cmd_multipath_EMC_id + cmd_multipath_IBM_id + cmd_multipath_HDS_id
cmd_multipath_desc = cmd_multipath_EMC_desc + cmd_multipath_IBM_desc + cmd_multipath_HDS_desc


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")

    cmd_storage_execute(context, cmd_display, CLI, LANGUAGE, cmd_multipath_id, cmd_multipath_desc)
    return cmd_execute(context, cmd_display, CLI, LANGUAGE)


def cmd_storage_execute(context, cmd_display, CLI, LANGUAGE, cmd_info_id, cmd_info_desc):
    tempStep = constants.PROG45 / len(cmd_info_id)
    curStep = tempStep
    fun_err_msg = ''
    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        cmd_display_temp = CLI.execCmdHasLogTimout(
            get_sudo_cmd(cmd_info_desc[rg], AIX, context), 60)
        if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            continue
        else:
            cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_temp)
            if "en" == LANGUAGE:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg);
    return cmd_display


def cmd_execute(context, cmd_display, CLI, LANGUAGE):
    tempStep = constants.PROG45 / len(cmd_info_id)
    curStep = constants.PROG45
    fun_err_msg = ''
    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        cmd_display_temp = CLI.execCmdHasLogTimout(cmd_info_desc[rg],60)
        if 'not found' not in cmd_display_temp:
            cmd_display_temp=cmd_display_temp.replace('TOOLKIT_EXE_CMD_FAILED','')
        else:
            pass
        cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
        if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg + cmd_display.get("err_msg"))
    return cmd_display
