# coding=utf-8
__author__ = '******'
# 获取aix主机的虚拟化信息
import re
import sys
import os 
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common import util
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import AIX
CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
cmd_info_id = ["cmd_info_virtual_lscfg_vscsi",
               "cmd_info_virtual_lscfg_fcs",
               "cmd_info_virtual_lspath",
               "cmd_info_virtual_lspath_aehl",
               "cmd_info_virtual_lscfg_hdisk",
               "cmd_info_virtual_lsdev_disk",
               "cmd_info_virtual_lsattr_el",
               "cmd_info_virtual_lsvg_pi",
               "cmd_info_virtual_lsvg_li",
               "cmd_info_virtual_lsvg_vgname",
               #命令调整：以下命令在虚拟环境中执行
               "cmd_info_virtual_ioscli_ioslevel",
               "cmd_info_virtual_lsmap_all",
               "cmd_info_virtual_lsmap_npiv_all",               
               "cmd_info_virtual_physical_portinfo",
               "cmd_info_virtual_physical_port_status",
               "cmd_info_virtual_virtual_adapters_info",
               "cmd_info_virtual_physical_volumes_info"]

      
cmd_info_desc = ["lscfg -vpl vscsi*",
                 "lscfg -vpl fcs*",
                 "lspath",
                 "lspath -AEHl ",
                 "lscfg -vl hdisk*",
                 "lsdev -Cc disk",
                 "lsattr -El ",
                 "lsvg -o|lsvg -pi",
                 "lsvg -o|lsvg -li",
                 "lsvg ",
                 #命令调整：以下命令在虚拟环境中执行
                 "lsnports",    
                 "lsdev -dev fcs*",
                 "lsdev -dev vfchost*",
                 "lspv",
                 "ioscli ioslevel",
                 "lsmap -all",
                 "lsmap -npiv -all"]
            
cmd_info_disk_list = "lsdev -Cc disk|grep Available|grep 'Virtual SCSI'|awk '{print $1}'"
cmd_info_vg_list = "lsvg"

def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(context, cmd_display, CLI, LANGUAGE))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(context, cmd_display, CLI, LANGUAGE):
    tempStep = constants.PROG85 / len(cmd_info_id)
    curStep = tempStep
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    disk_list = CLI.execCmdHasLog(cmd_info_disk_list).splitlines()
    vg_list = CLI.execCmdNoLog(cmd_info_vg_list).splitlines()
    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        if cmd_info_id[rg]=="cmd_info_virtual_lsattr_el" or cmd_info_id[rg]=="cmd_info_virtual_lspath_aehl":
            for disk in disk_list[1:]:
                cmd_display_temp=CLI.execCmdHasLogTimout(cmd_info_desc[rg] + disk,60)
                cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:]+"_"+disk, cmd_display_temp)
                if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + disk + ":\texecute failed\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + disk + u":\t执行失败\r\n"
                else:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + disk + ":\texecute success\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + disk + u":\t执行成功\r\n"
        elif cmd_info_id[rg]=="cmd_info_virtual_lsvg_vgname":
            for vgname in vg_list[1:]:
                cmd_display_temp=CLI.execCmdHasLogTimout(cmd_info_desc[rg] + vgname,60)
                cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:]+"_"+vgname, cmd_display_temp)
                if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + vgname + ":\texecute failed\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + vgname + u":\t执行失败\r\n"
                else:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + vgname + ":\texecute success\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + vgname + u":\t执行成功\r\n"
        elif cmd_info_id[rg]=="cmd_info_virtual_ioscli_ioslevel" or cmd_info_id[rg]=="cmd_info_virtual_lsmap_all" or cmd_info_id[rg]=="cmd_info_virtual_lsmap_npiv_all" \
                or cmd_info_id[rg]=="cmd_info_virtual_physical_portinfo" or cmd_info_id[rg]=="cmd_info_virtual_physical_port_status" or cmd_info_id[rg]=="cmd_info_virtual_virtual_adapters_info" \
                or cmd_info_id[rg]=="cmd_info_virtual_physical_volumes_info":
            CLI.execCmdHasLogTimout(get_sudo_cmd("su - padmin", AIX, context),
                                    60)
            cmd_display_temp = CLI.execCmdHasLogTimout(
                get_sudo_cmd(cmd_info_desc[rg], AIX, context), 60)
            #识别当前登录权限，若为虚拟环境，则退出                
            cmd_display_temp_whoami = CLI.execCmdHasLogTimout("whoami",60)
            if "padmin" in cmd_display_temp_whoami.lower():
                CLI.execCmdHasLogTimout("exit",60)
            
            cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
            if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
            else:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
        else:
            cmd_display_temp = CLI.execCmdHasLogTimout(cmd_info_desc[rg],60)
            cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
            if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
            else:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg