# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.
from com.huawei.ism.tool.deploy.entity import DeployHbaInfo
from common.cliUtil import cmd_execute
from common.base_deploy_collect import BaseDeployCollect
import re


def execute(context):
    """
    开局兼容性信息收集入口
    :param context: 传入上下文
    """
    host_info = HostInfo(context)
    host_info.get_info()


class HostInfo(BaseDeployCollect):

    def set_server_model(self):
        """
        设置服务器型号
        :return:
        """
        cmd = "prtconf | grep 'Processor Type: ' | awk -F 'Processor Type:" \
              " ' '{print $2}'|cat"
        _, cli_ret_dmi = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        self.host_info.setServerModel(self.get_last_line(cli_ret_dmi))

    def set_operating_system(self):
        """
        设置操作系统信息
        :return:
        """
        cmd = "oslevel -s|cat"
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        self.host_info.setOperatingSystem(self.get_last_line(cli_ret))

    def set_kernel(self):
        """
        设置内核信息
        :return:
        """
        cmd = "oslevel -s|cat"
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        self.host_info.setKernel(self.get_last_line(cli_ret))

    def set_bus_adapter(self):
        """
        设置HBA卡信息
        :return:
        """
        hba_info_list = list()
        cmd = "lsdev -Cc adapter |grep FC | grep 'Available' | awk '" \
              "{print $1}'|cat"
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        hba_list = cli_ret.splitlines()
        for hba in hba_list:
            if cmd in hba:
                continue
            hba_info_list.append(self.build_interface_info(hba))
        self.host_info.setHbaInfoList(hba_info_list)

    def set_multi_path_info(self):
        """
        设置多路径信息
        注：检查以下3种多路径：UltraPath、VxVM (DMP) 6.0.5、MPIO
        命令：
        upadm show version  --有版本(关键字Software Version)就是UP多路径，
        返回字符串UltraPath
        lslpp -l | grep VRTSaslapm  --有VRTSaslapm软件包(关键字VRTSaslapm)
        回显及其版本就是DMP多路径，需要返回版本信息VxVM (DMP) 6.0.5
        lslpp -l odmcfg.fcp.MPIO.rte ---有关键字odmcfg.fcp.MPIO.rte回显则
        使用了MPIO，返回字符串MPIO

        注：AIX的多路径支持Huawei UltraPath，支持AIX MPIO，支持Veritas VxVM
        (DMP)。
        :return:
        """
        multi_path_list = list()
        cmd = "upadm show version|cat"
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        if flag and "Software Version" in cli_ret:
            multi_path_list.append(self.ULTRA_PATH)

        cmd = "lslpp -l | grep VRTSaslapm|cat"
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )

        if (
                flag and
                re.compile(r"VRTSaslapm\w+\.\w+.*").findall(
                    re.sub('\s', '', cli_ret))

        ):
            multi_path_list.append(self.DMP_PATH)

        cmd = "lslpp -l odmcfg.fcp.MPIO.rte|cat"
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )

        if flag and re.compile(r"odmcfg.fcp.MPIO.rte\w+\.\w+.*").findall(
                re.sub('\s', '', cli_ret)):
            multi_path_list.append(self.MPIO_PATH)
        self.host_info.setMultipathingSoftware(";".join(multi_path_list))

    def build_interface_info(self, hba_card):
        """
        设置每个HBA的详细信息
        hostbusadapter 为主机总线适配器
        hbadriverversion 未HBA卡驱动版本
        hbafirmwareversion 为HBA卡固件版本
        :param hba_card: hba卡名称
        :return:
        """
        hba_info = DeployHbaInfo()
        self.set_interface_bus_adapter(hba_card, hba_info)

        self.set_interface_driver(hba_card, hba_info)

        self.set_interface_firmware(hba_card, hba_info)

        return hba_info

    def set_interface_firmware(self, hba_card, hba_info):
        """
        设置hba卡固件总线适配器
        :param hba_card:
        :param hba_info:
        :return:
        """
        cmd = (
                "lsmcode -A | grep %s | awk -F '!' '{print $2}' | awk -F '.' '"
                "{print $2}'|cat"
                % hba_card
        )
        _, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        hba_info.setHbaFirmwareVersion(self.get_last_line(cli_ret))

    def set_interface_driver(self, hba_card, hba_info):
        """
        设置HBA卡驱动版本
        :param hba_card:
        :param hba_info:
        :return:
        """
        cmd = (
                "lsmcode -A | grep %s | awk -F '!' '{print $2}' | awk -F "
                "'.' '{print $1}'|cat"
                % hba_card
        )
        _, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        hba_info.setHbaDriverVersion(self.get_last_line(cli_ret))

    def set_interface_bus_adapter(self, hba_card, hba_info):
        """
        设置HBA卡固件版本
        :param hba_card:
        :param hba_info:
        :return:
        """
        cmd = (
                "lscfg -vpl %s | grep 'Customer Card ID Number' | awk -F "
                "'Customer Card ID Number.' '{print $2}'|cat"
                % hba_card
        )
        mode_name_flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        if mode_name_flag is True:
            hba_info.setHostBusAdapter(
                self.get_last_line(cli_ret).replace(".", "")
            )
