# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os
import json
import traceback

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_return_from_txt
from common.util import is_digit


def execute(context):
    global logger
    logger = context.get("Logger")
    result = {}
    os_type, os_version = get_type_version(context)
    result["host_ip"] = context.get("ip")
    result["os_type"] = os_type
    result["os_version"] = os_version
    ret_map = context.get("map")
    ret_map.put("data", json.dumps(result))
    return context


def get_type_version(context):
    """
    获取操作系统 版本
    :param context: 上下文
    :return:  版本
    """
    try:
        command = "oslevel -s"
        context["command"] = command
        op_sys_info_list = get_return_from_txt(context)
        if not op_sys_info_list:
            return "AIX", ""
        return "AIX", get_version(op_sys_info_list)
    except Exception:
        logger.error("parse error: %s" % str(traceback.format_exc()))
        return "AIX", ""


def get_version(op_sys_info_list):
    """
    处理版本信息，正常就是回文一行，但是遇见一次有多行的
    :param op_sys_info_list: 版本回文
    :return: 版本
    """
    for line in op_sys_info_list:
        if is_digit(line.replace("-", "")):
            return line
    return ""
