# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os
import json
import ast
import traceback

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_return_from_txt


def execute(context):
    global logger
    logger = context.get("Logger")
    result = {}
    result["host_ip"] = context.get("ip")
    try:
        version = get_version(context)
        voic_list = get_voic_list(context)
        if not version or not voic_list:
            voic_list = get_empty_voic_list()
    except Exception:
        logger.error("parse error: %s" % str(traceback.format_exc()))
        version, voic_list = "", get_empty_voic_list()
    result["vm_version"] = version
    result["vioc_list"] = voic_list

    ret_map = context.get("map")
    ret_map.put("data", json.dumps(result))
    return context


def get_voic_list(context):
    """
    获取voic_list
    :param context: 上下文
    :return: voic列表
    """
    scsi_list = get_scsi_list(context)
    fc_list = get_fc_list(context)
    scsi_fc_list = []
    # scsi与fc通过vioc_id进行相互关联，关联不上的相应字段置为空
    for scsi in scsi_list:
        one_sf = {}
        one_sf["vioc_id"] = scsi.get("vioc_id", "")
        one_sf["scsi_sa"] = scsi.get("scsi_sa", "")
        one_sf["scsi_vtd"] = scsi.get("scsi_vtd", "")
        one_sf["scsi_bd"] = scsi.get("scsi_bd", "")
        one_sf["fc_sa"] = ""
        one_sf["fc_status"] = ""
        one_sf["fc_name"] = ""
        scsi_fc_list.append(one_sf)
    for fc in fc_list:
        flag = False
        for sf in scsi_fc_list:
            if sf.get("vioc_id", "") == fc.get("vioc_id", ""):
                sf["fc_sa"] = fc.get("fc_sa", "")
                sf["fc_status"] = fc.get("fc_status", "")
                sf["fc_name"] = fc.get("fc_name", "")
                flag = True
                break
        if not flag:
            one_sf = {}
            one_sf["vioc_id"] = fc.get("vioc_id", "")
            one_sf["fc_sa"] = fc.get("fc_sa", "")
            one_sf["fc_status"] = fc.get("fc_status", "")
            one_sf["fc_name"] = fc.get("fc_name", "")
            one_sf["scsi_sa"] = ""
            one_sf["scsi_vtd"] = ""
            one_sf["scsi_bd"] = ""
            scsi_fc_list.append(one_sf)
    return scsi_fc_list


def get_fc_list(context):
    """
    获取fc_list
    :param context: 上下文
    :return: fc类型列表
    """
    context["command"] = "lsmap -npiv -all"
    prefix = "Name"
    suffix = "ClntOS"
    fc_info_list = get_vm_info_list(context, prefix, suffix)
    fc_list = []
    for fc_info in fc_info_list:
        one_fc = {}
        flag = False
        for line in fc_info:
            if "----" in line:
                flag = True
                continue
            if flag and len(line.strip().split()) > 2:
                one_fc["fc_sa"] = line.strip().split()[0]
                one_fc["vioc_id"] = line.strip().split()[2]
                flag = False
                continue
            if line.strip().startswith("Status") and ":" in line:
                one_fc["fc_status"] = line.strip().split(":")[-1]
                continue
            if line.strip().startswith("FC name") and ":" in line:
                one_fc["fc_name"] = line.strip().split(":")[1].split()[0]
                continue
        fc_list.append(one_fc)
    return fc_list


def get_scsi_list(context):
    """
    获取scsi_list
    :param context: 上下文
    :return: scsi类型列表
    """
    context["command"] = "lsmap -all"
    prefix = "SVSA"
    suffix = "Client Partition ID"
    scsi_info_list = get_vm_info_list(context, prefix, suffix)
    scsi_list = []
    for scsi_info in scsi_info_list:
        one_scsi = {}
        flag = False
        for line in scsi_info:
            if "----" in line:
                flag = True
                continue
            if flag:
                one_scsi["scsi_sa"] = line.strip().split()[0]
                id_16 = line.strip().split()[-1]
                one_scsi["vioc_id"] = str(ast.literal_eval(id_16))
                flag = False
                continue
            if line.strip().startswith("VTD"):
                one_scsi["scsi_vtd"] = line.strip().split()[-1]
                continue
            if line.strip().startswith("Backing device"):
                one_scsi["scsi_bd"] = line.strip().split()[-1]
                continue
        scsi_list.append(one_scsi)
    return scsi_list


def get_vm_info_list(context, prefix, suffix):
    """
    获取info_list
    :param context: 上下文
    :param prefix: 前缀
    :param suffix: 后缀
    :return: 回文列表
    """
    item_info = get_return_from_txt(context)
    item_info_list = []
    one_item_info = []
    flag = False
    for index, line in enumerate(item_info):
        if line.strip().startswith(prefix) and line.strip().endswith(suffix):
            flag = True
        if line.strip().startswith(prefix) and line.strip().endswith(suffix) \
                and one_item_info:
            item_info_list.append(one_item_info)
            one_item_info = []
        if flag:
            one_item_info.append(line)
        if flag and index == len(item_info) - 1:
            item_info_list.append(one_item_info)
    return item_info_list


def get_version(context):
    """
    获取vios version
    :param context: 上下文
    :return: vios 版本
    """
    context["command"] = "ioslevel"
    version_info = get_return_from_txt(context)
    if version_info and "not found" not in "".join(version_info):
        return version_info[0]
    return ""


def get_empty_voic_list():
    """
    生成空数据
    :return: 空数据
    """
    voic_list = []
    one_empty = {}
    one_empty["vioc_id"] = ""
    one_empty["scsi_sa"] = ""
    one_empty["scsi_vtd"] = ""
    one_empty["scsi_bd"] = ""
    one_empty["vioc_id"] == ""
    one_empty["fc_sa"] = ""
    one_empty["fc_status"] = ""
    one_empty["fc_name"] = ""
    voic_list.append(one_empty)
    return voic_list
