# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_cmd_ret

cmd_info_id = [
    "cmd_info_lvm_lsvg",
    "cmd_info_lvm_lsvg_",
    "cmd_info_lvm_lspv",
    "cmd_info_lvm_lspv_li",
    "cmd_info_lvm_lspv_pi",
    "cmd_info_lvm_df",
    "cmd_info_lvm_vxvm",
]

cmd_info_desc = [
    "lsvg",
    "lsvg ",
    "lspv",
    "lsvg -o|lsvg -li",
    "lsvg -o|lsvg -pi",
    "df -g",
    "hastatus -sum",
]


def execute(context):
    cmd_display = context.get("ret_map")
    cmd_display_temp = ''
    for rg in range(len(cmd_info_id)):
        if cmd_info_id[rg] == "cmd_info_lvm_lsvg_":
            set_vgs(cmd_display, context, cmd_info_id[rg], cmd_info_desc[rg])
            continue
        context["command"] = cmd_info_desc[rg]
        cmd_display_temp = get_cmd_ret(context)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:],
                        cmd_display_temp)
    return cmd_display


def set_vgs(cmd_display, context, id_preffix, cmd):
    """
    组装aix主机的vg详情
    :param id_preffix: 描述前缀
    :param cmd_display: 回文字典
    :param context: 上下文
    """
    context["command"] = "lsvg"
    vg_names = get_cmd_ret(context).splitlines()[1:]
    for line in vg_names:
        if line and "not found" not in line:
            context["command"] = cmd + line.strip()
            cmd_display.put("cmd_display" + id_preffix[8:] + line,
                            get_cmd_ret(context))
