# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_cmd_ret

cmd_info_id = [
    "cmd_info_multipath_info_upadmin_version",
    "cmd_info_multipath_info_powermt_version",
    "cmd_info_multipath_info_hdlm_version",
    "cmd_info_multipath_info_hdlm_version2",
    "cmd_info_multipath_info_mpio",
    "cmd_info_multipath_info_mpio_type",
    "cmd_info_multipath_info_lspv",
    "cmd_info_multipath_info_lscfg",
    "cmd_info_multipath_info_lsattr_el_",
    "cmd_info_multipath_info_bootinfo_",
    "cmd_info_multipath_info_powermt_all",
    "cmd_info_multipath_info_upadm_all",
    "cmd_info_multipath_info_upadm_vlun_",
    "cmd_info_multipath_info_hdlm_disks",
    "cmd_info_multipath_info_hdlm_disks2",
]

cmd_info_desc = [
    "upadm show version",
    "powermt version",
    "dlnkmgr view -sys",
    "/usr/DynamicLinkManager/bin/dlnkmgr view -sys",
    "lsdev -Cc disk",
    "lsdev -Cc disk -F type",
    "lspv -u",
    "lscfg -vl hdisk*",
    "lsattr -El ",
    "bootinfo -s ",
    "powermt display dev=all",
    "upadm show vlun type=all",
    "upadm show vlun id=",
    "dlnkmgr view -path",
    "/usr/DynamicLinkManager/bin/dlnkmgr view -path",
]


def execute(context):
    cmd_display = context.get("ret_map")
    cmd_display_temp = ''
    for rg in range(len(cmd_info_id)):
        if cmd_info_id[rg] == "cmd_info_multipath_info_lsattr_el_" \
                or cmd_info_id[rg] == "cmd_info_multipath_info_bootinfo_" \
                or cmd_info_id[rg] == "cmd_info_multipath_info_upadm_vlun_":
            set_prefix_cmd(cmd_display, context, cmd_info_id[rg],
                           cmd_info_desc[rg])
            continue
        context["command"] = cmd_info_desc[rg]
        cmd_display_temp = get_cmd_ret(context)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:],
                        cmd_display_temp)
    return cmd_display


def set_prefix_cmd(cmd_display, context, id_prefix, cmd_prefix):
    """
    组装通过命令前缀执行的详情
    :param cmd_prefix: 命令前缀
    :param id_prefix: 描述前缀
    :param cmd_display: 回文字典
    :param context: 上下文
    """
    if id_prefix == "cmd_info_multipath_info_lsattr_el_" \
            or id_prefix == "cmd_info_multipath_info_bootinfo_":
        context["command"] = "lsdev -Cc disk|awk '{print $1}'"
    elif id_prefix == "cmd_info_multipath_info_upadm_vlun_":
        context["command"] = \
            "upadm show vlun type=all |sed '1,2d;$d' |awk '{print $1}'"
    disk_list = get_cmd_ret(context).splitlines()[1:]
    for disk_name in disk_list:
        if disk_name and "not found" not in disk_name:
            context["command"] = cmd_prefix + disk_name
            cmd_display.put("cmd_display" + id_prefix[8:] + disk_name,
                            get_cmd_ret(context))
