# --*-- coding:utf-8 --*--
import sys 
import os
import re
reload(sys) 
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import getSingleOrMoreCommandRetFromTxt,check_lst 

'''
执行fcinfo hba - port命令，在回显中
Model的是HBA卡型号，
HBA Port WWN是HBA卡的WWPN，
 Firmware Version是HBA卡固件版本(括号内的不取)，
 Driver Version是HBA卡驱动版本（括号以内的内容不获取），
 过滤掉state不为online的HBA卡。

'''

WwpnCmdDesc = "cmd_display_hba_card_lscfg"
HbaStatusCmdDesc = "cmd_display_hba_card_status_status_"
HbaStatusDCmdDesc = "cmd_display_hba_card_status_D_status_D_"
fwDrCmd = 'cmd_display_hba_card_fc_'

def execute(context):
    '''
    @summary:脚本入口
    @param context:存放脚本处理过的信息
    @return: context 返回处理后的信息
    '''
    global Logger
    Logger = context.get("Logger")
    all_result = ""
    hbaObjs = getAllHbaObjs(context)
    fc_result = getAllWWPNS(hbaObjs)
    iscsi_result = get_iscsi_result(context)

    if fc_result == "NA":
        all_result = iscsi_result
    else:
        if iscsi_result == "NA":
            all_result = fc_result
        else:
            all_result = fc_result + ";" + iscsi_result

    context['result'] = all_result
    return context


def get_iscsi_result(context):
    """
    获取iscsi的wwpn
    :param context:
    :return:
    """
    iscsi_port_lst = get_iscsi_port_lst(context)
    return get_iscsi_wwn(context, iscsi_port_lst)


def get_iscsi_port_lst(context):
    """
    获取iscsi的端口
    :param context:
    :return:
    """
    iscsi_port = []
    cmd_iscsi_desc = "cmd_display_hba_card_lsdev"
    lst = getSingleOrMoreCommandRetFromTxt(context, cmd_iscsi_desc, False)
    for line in lst:
        if "available" in line.lower() and "iscsi protocol device" in \
                line.lower():
            iscsi_port.append(re.split('\\s+', line)[0].strip())
    return iscsi_port


def get_iscsi_wwn(context, iscsi_port_lst):
    """
    获取iscsi的wwn
    :param context:
    :param iscsi_port_lst:
    :return:
    """
    iscsi_wwn = ""
    cmd_iscsi_wwn_desc = "cmd_display_hba_card_iscsi_info"
    for iscsi_port in iscsi_port_lst:
        iscsi_wwn_str = getSingleOrMoreCommandRetFromTxt(context,
                                                         cmd_iscsi_wwn_desc +
                                                         "_" + iscsi_port,
                                                         False)
        for line in iscsi_wwn_str:
            if "initiator_name" in line:
                iscsi_wwn = iscsi_wwn + re.split('\\s+', line)[1].strip() + ";"
    if not iscsi_wwn:
        iscsi_wwn = "NA"
    else:
        iscsi_wwn = iscsi_wwn[0:-1]

    return iscsi_wwn


def getAllWWPNS(hbas):
    '''
    @summary:获取wwpns
    @param hbas:需要处理的hba对象
    @return wwpns:所有wwpn
    '''    
    wwpns = ''
    for hba in hbas:
        if 'na' == hba.getState().lower():
            continue
        wwpns = wwpns + ';' + hba.getHbaWWPN()
    if not wwpns:
        wwpns = 'NA'
    else:
        wwpns = wwpns[1:]
    return wwpns
        
        

def getEachHbaInfo(allHbaLst):
    '''
    @summary:将所有wwpn的回文按单个wwpn分片
    @param allHbaLst:将所有wwpn的回文
    @return: 分片后的列表
    '''
    
    startidx_lst = []
    endidx_lst = []
    eachHbaLst = []
    
    for idx, line in  enumerate(allHbaLst):
        if (line.strip().startswith('fcs')):    
            startidx_lst.append(idx)
            
    for i in range(len(startidx_lst)):
        if i != len(startidx_lst) - 1:
            endidx_lst.append(startidx_lst[i + 1])
        else:
            endidx_lst.append(len(allHbaLst) - 1)
    for idx in range(len(startidx_lst)):
        start = startidx_lst[idx]
        end = endidx_lst[idx]
        eachHbaLst.append(allHbaLst[start:end])
            
    return eachHbaLst
        
def getAllHbaObjs(context):
    '''
    @summary:获取所有hba对象
    @param eachHbaLst:单个对象组成的回文 构成的列表
    @return hba对象列表
    '''
    
    hbaObjLst = []
    lst = getSingleOrMoreCommandRetFromTxt(context, WwpnCmdDesc, False)
    
    eachlst = getEachHbaInfo(lst)
    for hbalst in eachlst:
        hbaObjLst.append(getHbaBySingleInfo(hbalst, context))
    return hbaObjLst
                
        
def getHbaBySingleInfo(hbaLst, context):
    '''
    @summary:返回单个hba对象回文的列表
    @param hbaLst: :单个hba对象回文
    @return:返回hba对象
           回文示例：
    Network Address.............10000000C9AD0B20
    '''

    Logger = context.get("Logger")
    hbaObj = HbaEntity()
    for line in hbaLst:
        
        if ('fcs' in line.lower()):
            hba = re.split('\s\s+', line)[0].strip()
            hbaObj.setHba(hba)
            continue
        
        if ('Network Address'.lower() in line.lower()):
            if '.' in line:
                wwpn = re.split('\.', line)[-1].strip()
                hbaObj.setHbaWWPN(wwpn)
            continue
        if ('Customer Card ID Number'.lower() in line.lower()):
            if '.' in line:
                model = re.split('\.', line)[-1].strip()
                hbaObj.setHbaModel(model)
    #求状态
    status = 'NA'
    statuLineLst = getSingleOrMoreCommandRetFromTxt(context, HbaStatusCmdDesc + hbaObj.getHba(), False)
    statuLineLst = statuLineLst if "Attention Type:" in statuLineLst else getSingleOrMoreCommandRetFromTxt(context, HbaStatusDCmdDesc + hbaObj.getHba(), False)
    for line in statuLineLst:
        if "Attention Type:" in line:
            try:
                status = re.split(':', line)[-1].strip()
                break
            except:
                break
    hbaObj.setState(status)
    fwDrLst = getSingleOrMoreCommandRetFromTxt(context, fwDrCmd + hbaObj.getHba(), False)
    fwDrLst = check_lst(fwDrLst)
    
    fwDrLine = ''
    fwDrIdx = 0 
    
    for idx, fline in enumerate(fwDrLst):
        if 'lsmcode -A |grep'in fline:
            fwDrIdx = idx+1
            break
    try:
        if 0 != fwDrIdx:
            fwDrLine = fwDrLst[fwDrIdx]
    except Exception ,e:
        Logger.info('fw drversion not found.',str(e))
    
    if '' != fwDrLine:
        fwDrLine = fwDrLine.replace('!','.')
        fwDrLine = fwDrLine.replace('-','.')
        fwDrLst = re.split('\.',fwDrLine)
        
        try:
            hbaObj.setDrVersion(fwDrLst[-3].strip())
            hbaObj.setFwVersion(fwDrLst[-1].strip())
        except Exception,e:
            Logger.info('fw dr version not found.',str(e))
    else:
        Logger.info('fwversion and drversion line not found.')
        
    return hbaObj
        
    
class HbaEntity:
    hba = 'NA'
    hbaModel = 'NA'
    wwpn = 'NA'
    fwVersion = 'NA'
    drVersion = 'NA'
    state = 'NA'
    
    def getHba(self):
        return self.hba
    def getHbaModel(self):
        return self.hbaModel
    def getHbaWWPN(self):
        return self.wwpn
    def getFwVersion(self):
        return self.fwVersion
    def getDrVersion(self):
        return self.drVersion
    def getState(self):
        return self.state
    def setHba(self, hba):
        self.hba = hba
    def setHbaModel(self, model):
        self.hbaModel = model
    def setHbaWWPN(self, wwpn):
        self.wwpn = wwpn
    def setFwVersion(self, version):
        self.fwVersion = version
    def setDrVersion(self, drVersion):
        self.drVersion = drVersion
    def setState(self, state):
        self.state = state
        
    
