# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from com.huawei.ism.tool.deploy.entity import DeployHbaInfo
from common.cliUtil import cmd_execute
from common.base_deploy_collect import BaseDeployCollect
import re


def execute(context):
    """
    开局兼容性信息收集入口
    :param context: 传入上下文
    """
    host_info = HostInfo(context)
    host_info.get_info()


class HostInfo(BaseDeployCollect):

    def set_server_model(self):
        """
        设置服务器型号
        :return:
        """
        cmd = "machinfo | grep 'Model:' | awk -F 'Model:' '{print $2}'|cat"
        dmi_flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        if dmi_flag is True:
            self.host_info.setServerModel(
                self.get_last_line(cli_ret).replace('"', "")
            )
        else:
            self.host_info.setServerModel(cli_ret)

    def set_operating_system(self):
        """
        设置操作系统信息
        :return:
        """
        cmd = "machinfo | grep 'Release:' | awk -F 'Release:' '{print $2}'|cat"
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        self.host_info.setOperatingSystem(self.get_last_line(cli_ret))

    def set_kernel(self):
        """
        设置内核信息
        :return:
        """
        cmd = "swlist | grep HPUX11i|cat"
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        self.host_info.setKernel(self.get_last_line(cli_ret))

    def set_bus_adapter(self):
        """
        设置HBA卡信息
        :return:
        """
        hba_info_list = list()
        cmd = "ioscan -funC fc | grep '/dev/fcd' | awk '{print $1}'|cat"
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        hba_list = cli_ret.splitlines()
        for hba in hba_list:
            if cmd in hba:
                continue
            hba_info_list.append(self.build_hba_info(hba))
        self.host_info.setHbaInfoList(hba_info_list)

    def set_multi_path_info(self):
        """
        设置多路径信息
        注：HP-UX的多路径不支持Huawei UltraPath，支持HP-UX NMP，
        支持Veritas VxVM (DMP)。
        注：检查以下2种多路径：VxVM (DMP) 6.0.5、HP-UX NMP
        命令：多路径可能共存
        swlist -l product | grep VRTSaslapm  ----有关键字VRTSaslapm
        软件包回显及其版本就是DMP多路径，需要返回版本信息VxVM (DMP) 6.0.5
        NMP命令：scsimgr get_attr -a leg_mpath_enable  ---
        查看关键字current=true状态，如果为true表示启用NMP系统自带多路径。
        返回字符串HP-UX NMP
        :return:
        """
        multi_path_list = list()
        cmd = "swlist -l product | grep VRTSaslapm|cat"
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        if flag and re.compile(r"VRTSaslapm\w+\.\w+.*").findall(
                re.sub('\s', '', cli_ret)):
            multi_path_list.append(self.DMP_PATH)

        cmd = "scsimgr get_attr -a leg_mpath_enable|cat"
        flag, cli_ret = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )

        if flag and "current=true" in re.sub('\s', '', cli_ret):
            multi_path_list.append("HP-UX NMP")
        self.host_info.setMultipathingSoftware(";".join(multi_path_list))

    def build_hba_info(self, hba_card):
        """
        设置每个HBA的详细信息
        hostbusadapter 为主机总线适配器
        hbadriverversion 未HBA卡驱动版本
        hbafirmwareversion 为HBA卡固件版本
        :param hba_card: hba卡名称
        :return:
        """
        hba_info = DeployHbaInfo()
        self.set_interface_bus_adapter(hba_card, hba_info)

        self.set_interface_driver(hba_card, hba_info)

        self.set_interface_firmware(hba_card, hba_info)

        return hba_info

    def set_interface_firmware(self, hba_card, hba_info):
        """
        设置hba卡固件总线适配器
        :param hba_card:
        :param hba_info:
        :return:
        """
        cmd = (
                "fcmsutil %s vpd | grep 'ROM Firmware version' | awk -F ':' '"
                "{print $2}'"
                % hba_card
        )
        _, cli_ret = cmd_execute(self.cli_ret_list, self.cli, cmd, self.logger)
        hba_info.setHbaFirmwareVersion(self.get_last_line(cli_ret))

    def set_interface_driver(self, hba_card, hba_info):
        """
        设置HBA卡驱动版本
        :param hba_card:
        :param hba_info:
        :return:
        """
        cmd = (
                "fcmsutil %s | grep 'Driver Version' | awk -F '=' '{print $2}'"
                % hba_card
        )
        _, cli_ret = cmd_execute(self.cli_ret_list, self.cli, cmd, self.logger)
        hba_info.setHbaDriverVersion(self.get_last_line(cli_ret))

    def set_interface_bus_adapter(self, hba_card, hba_info):
        """
        设置HBA卡驱动版本
        :param hba_card:
        :param hba_info:
        :return:
        """
        cmd = "ioscan -funC fc|cat"
        modename_flag, cli_ret_modename = cmd_execute(
            self.cli_ret_list, self.cli, cmd, self.logger
        )
        if modename_flag is True:
            cli_ret_list = cli_ret_modename.splitlines()
            for index in range(len(cli_ret_list)):
                if (
                        hba_card in cli_ret_list[index]
                        and index > 0
                        and "INTERFACE" in cli_ret_list[index - 1]
                ):
                    hba_info.setHostBusAdapter(
                        cli_ret_list[index - 1].split("INTERFACE")[-1].strip()
                    )
        else:
            hba_info.setHostBusAdapter(cli_ret_modename)
