# coding=utf-8
import traceback
import sys
import os
import re
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import util
from common import constants
from common import contentParse
ALUA_ENABLED='enabled'
ALUA_NOT_ENABLED = 'not enabled'
ALUA_FIGURE_UNKNOWN = 'unknown'
ALUA_PATH_UNOPEN = 'noBusiness'
def execute(context):
    """
    Function name      : execute
    Input              : context
    Return             : cmd display
    """
    echos = ''
    sshCon = context.get("SSH")
    LANG = context.get("lang")
    cmd_display = context.get("ret_map")
    util.updateItemProgress(context, constants.PROG10)
    isSucess, huawei_disk_letters, echo = get_huawei_disk_ids(context, sshCon, LANG, cmd_display)
    util.updateItemProgress(context, constants.PROG50)
    echos += echo
    if not isSucess:
        #all disk info failed to fetch
        contentParse .saveAluaStatusAndCliRet2ForeEval (ALUA_FIGURE_UNKNOWN, echos, context)
        util.updateItemProgress(context, constants.PROG90)
        return cmd_display
    if not huawei_disk_letters:
        contentParse .saveAluaStatusAndCliRet2ForeEval (ALUA_NOT_ENABLED, echos, context)
        util.updateItemProgress(context, constants.PROG90)
        return cmd_display
    
    util.log.info(context, "current host's huawei disk lists: %s." % ','.join(huawei_disk_letters))
    failedDisks = []
    unopenedDisks = []
    util.log.info(context, "found huawei disks lists as: %s" % str(huawei_disk_letters))
    for disk_letter in huawei_disk_letters:
        util.log.info(context, "start to fetch disk %s's info" % disk_letter)
        cmd_id = "cmd_display_scsimgr_lunmap_" + disk_letter
        cmd = "scsimgr lun_map -D /dev/rdisk/disk" + disk_letter.strip()
        isSucess, echo, resultMsg = execute_cmd_with_timeout(context, sshCon, LANG, cmd)
        cmd_display.put(cmd_id, echo)
        echos += echo
        resultMsg = cmd_display["err_msg"] + resultMsg
        cmd_display.put("err_msg", resultMsg)
        if not isSucess:
            failedDisks.append(disk_letter)
        hasStandBy = False
        hasActive = False
        util.updateItemProgress(context, constants.PROG70)
        last_state_list = []
        state_list = []
        for line in echos.splitlines():
            if re.search('^state\s*=\s*(\w+\s*)+', line.strip(), re.I):
                state_list.append(line.split('=')[1].strip().upper())
            if re.search('^last open or close state\s*=\s*(\w+\s*)+', line.strip(), re.I):
                last_state_list.append(line.split('=')[1].strip().upper())
        alua_states = False
        if 'ACTIVE' in state_list and 'STANDBY' in state_list:
            alua_states = True
        if 'ACTIVE' not in state_list and 'STANDBY' not in state_list \
                and 'UNOPEN' in state_list and 'ACTIVE' in last_state_list \
                and 'STANDBY' in last_state_list:
            alua_states = True
        util.log.info(context, "current lun %s's alua configuration status: %s" % (disk_letter, str(alua_states)))
        
        if alua_states:
            util.log.info(context, "found configuration matched alua feature : %s" % disk_letter)
            contentParse .saveAluaStatusAndCliRet2ForeEval (ALUA_ENABLED, echos, context)
            util.updateItemProgress(context, constants.PROG90)
            return cmd_display
    if failedDisks:
        util.log.info(context, "[solaris]found disk failed querying ALUA info")
        contentParse .saveAluaStatusAndCliRet2ForeEval (ALUA_FIGURE_UNKNOWN, echos, context)
    elif unopenedDisks:
        util.log.info(context, "[solaris]found disks' all path's not functional.")
        contentParse .saveAluaStatusAndCliRet2ForeEval (ALUA_PATH_UNOPEN, echos, context)        
    else:
        util.log.info(context, "[solaris]found all specified disk  ALUA not opened")
        contentParse .saveAluaStatusAndCliRet2ForeEval (ALUA_NOT_ENABLED, echos, context)

    util.updateItemProgress(context, constants.PROG90)
    return cmd_display

def get_huawei_disk_ids(context, sshCon, LANG, cmd_display):
    '''
    @summary: get huawei disk id lists
    @return:  r-disk directory
    '''
    cmd_id = "cmd_display_ioscan_for_hpux"
    cmd = "ioscan -kfNnC disk"
    huawei_disk_letters = []
    util.log.info(context, "start to fetch current host's disk IDs")
    isSucess, echos, resultMsg = execute_cmd_with_timeout(context, sshCon, LANG, cmd)
    cmd_display.put(cmd_id, echos)
    cmd_display.put("err_msg", resultMsg)
    if not isSucess:
        util.log.info(context, "failed to fetch current host's disk IDs")
        return isSucess, [], echos
    util.log.info(context, "parsing IO scan results...")
    isStart = False
    for line in echos.splitlines():
        if line.startswith("disk") and "huawei" in line.lower():
            isStart = True
            continue
        if isStart and line.strip().startswith("/dev/disk/"):
            isStart = False
            disk_letter = line.strip().split()[0][14:]
            util.log.info(context, "disk letter's number is : %s." % disk_letter)
            if disk_letter.isdigit():
                huawei_disk_letters.append(disk_letter)
    return isSucess, huawei_disk_letters, echos


def execute_cmd_with_timeout(context, sshCon, LANG, cmd):
    '''
    @summary: get command echos 
    @return: isSucess, echos, resultMsg
    '''
    resultMsg = ""
    isSucess = True
    echos = sshCon.execCmdWithTimout(cmd, constants.HOST_CMD_TIMEOUT)
    if not echos or\
        'TOOLKIT_SEND_CMD_TIME_OUT' in  echos or\
            'TOOLKIT_EXE_CMD_FAILED' in echos:
        isSucess = False

    if "en" == LANG:
        if isSucess:
            resultMsg = cmd + ":\texecute success\r\n"
        else:
            resultMsg = cmd + ":\texecute failed\r\n"
    else:
        if isSucess:
            resultMsg = cmd + u":\t执行成功\r\n"
        else:
            resultMsg = cmd + u":\t执行失败\r\n"
    return isSucess, echos, resultMsg
