# coding=utf-8
__author__ = '******'
# 获取hp-ux主机的磁盘管理信息
import re
import sys
import os 
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common import util
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import HPUX

reload(sys) 
sys.setdefaultencoding('utf-8')

CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
cmd_info_id = [
               "cmd_info_disk_mgt_diskinfo_disk"             ,
               "cmd_info_disk_mgt_ls_dev"                    ,
               "cmd_info_disk_mgt_cat_fstab"                 ,
               "cmd_info_disk_mgt_mount"                     ,
               "cmd_info_disk_mgt_mount_v"                   ,
               "cmd_info_disk_mgt_bdf"                       ,
               "cmd_info_disk_mgt_scsimgr_wwid"              ,
               "cmd_info_disk_mgt_scsimgr_alua"              ]

cmd_info_desc = [
                 "diskinfo ",
                 "ls -al /dev",
                 "cat /etc/fstab",
                 "mount",
                 "mount -v",
                 "bdf",
                 "scsimgr -p get_attr all_lun -a device_file -a wwid",
                 "scsimgr get_attr -D %s -a alua_enabled"]

cmd_info_rdsk_list                =   "ioscan -funNC disk|grep rdisk"
cmd_info_rdsk_list_1              =   "ioscan -funNC disk|grep rdisk|awk '{print $1}'|grep rdisk/disk"
cmd_info_rdsk_list_2              =   "ioscan -funNC disk|grep rdisk|awk '{print $2}'|grep rdisk/disk"


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(context, cmd_display, CLI, LANGUAGE))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(context, cmd_display, CLI, LANGUAGE):
    tempStep = constants.PROG90 / len(cmd_info_id)
    curStep = tempStep
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    rdsk_list_line = CLI.execCmdHasLog(
        get_sudo_cmd(cmd_info_rdsk_list, HPUX, context)).splitlines()
    rdsk_list_pro = []
    rdsk_list = []
    for rdsk_line in rdsk_list_line[1:]:
        rdsk_list_pro = rdsk_line.split()
        for rdsk in rdsk_list_pro:
            if rdsk.find("rdisk/disk")>=0:
                rdsk_list.append(rdsk)
    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        if cmd_info_id[rg]=="cmd_info_disk_mgt_diskinfo_disk":
            for rdsk in rdsk_list:
                cmd_display_temp = CLI.execCmdNoLogTimout(
                    get_sudo_cmd(cmd_info_desc[rg], HPUX, context) + rdsk, 60)
                cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:]+"_" + rdsk, cmd_display_temp)
                if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + rdsk + ":\texecute failed\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + rdsk + u":\t执行失败\r\n"
                else:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + rdsk + ":\texecute success\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + rdsk + u":\t执行成功\r\n"
        elif cmd_info_id[rg]=="cmd_info_disk_mgt_scsimgr_alua":
            for rdsk in rdsk_list:
                cmd_display_temp = CLI.execCmdNoLogTimout(
                    get_sudo_cmd(cmd_info_desc[rg], HPUX, context) % rdsk, 60)
                cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:]+"_" + rdsk, cmd_display_temp)
                if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg].replace("disk", rdsk) + ":\texecute failed\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg].replace("disk", rdsk) + u":\t执行失败\r\n"
                else:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg].replace("disk", rdsk) + ":\texecute success\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg].replace("disk", rdsk) + u":\t执行成功\r\n"
        else:
            cmd_display_temp = CLI.execCmdNoLogTimout(
                get_sudo_cmd(cmd_info_desc[rg], HPUX, context), 60)
            cmd_display_temp = cmd_display_temp.replace('','')
            cmd_display_temp = cmd_display_temp.replace(' _','_')
            cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
            if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
            else:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg