# coding=utf-8
__author__ = '******'
# 获取hp-ux主机的HBA卡信息
import re
import traceback
import sys
import os 
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common.contentParse import * 
from common.util import *
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import HPUX

global cmd_info_number
cmd_info_number = 0
cmd_info_id_tmo = "cmd_info_hba_card_tmo" 

CLI = None
LANGUAGE = None
CHECK_FAIL = 0
CHECK_PASS = 1
cmd_info_id = ["cmd_info_hba_card_ioscan_funC",
               "cmd_info_hba_card_fcmsutil",
               "cmd_info_hba_card_iscsi"]
            
cmd_info_desc = ["ioscan -funC fc",
                 "fcmsutil ",
                 "iscsiutil -l"]
            
cmd_info_hba_list = "ioscan -funC fc|grep dev|awk '{print $1}'"


#HP-UX的老版本（包括V1和V2），此处只配置大版本，真实的版本号如HP-UX B.11.23
OldDevTypeVersionList = ["B.11.1", "B.11.2"]

GetErrHBATimeoutInfo = {"H/W Path": "Error", "Timeout":"Error"}

def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    util.updateItemProgress(context, constants.PROG20)
    createFwDrStateCmd(CLI, context)
    
    cmd_execute(cmd_display, CLI, LANGUAGE, context)
    errMsgHbaInfo = context.get("ret_map").get("err_msg") 
    
    #获取HBA卡的超时时间
    util.updateItemProgress(context, constants.PROG60)
    getHbaCardTimeout(context)
    errMsgTMO = context.get("ret_map").get("err_msg") 
    errMsgFinal = errMsgHbaInfo + errMsgTMO
    
    context.get("ret_map").put("err_msg", errMsgFinal)
    util.updateItemProgress(context, constants.PROG80)
    return context


def createFwDrStateCmd(cli, context):
    """
    @summary: hba卡型号、驱动版本、状态，需要加命令，此方法拼接命令道命令列表里面
    @parm cli:ssh连接
    """
    hba_list = cli.execCmdNoLog(
        get_sudo_cmd(cmd_info_hba_list, HPUX, context)).splitlines()
    
    for hba in hba_list[1:]:
        # 兼容sudo采集时，第一行回显多余的
        if "last successful login" in hba.lower():
            continue
        cmd = "fcmsutil "
        cmd_info_id.append('cmd_info_hba_card_fcmsutil_modelfw_' + hba)
        cmd_info_desc.append(get_sudo_cmd(cmd, HPUX, context) + hba +
                             " vpd |grep -E 'Part number|ROM Firmware version'"
                             )

        cmd_info_id.append('cmd_info_hba_card_fcmsutil_drstate_' + hba)
        cmd_info_desc.append(get_sudo_cmd(cmd, HPUX, context) + hba +
                             " |grep -E 'Driver Version|Driver state'")


def getCmdIndex():
    '''
    @summary: get index of new command
    @param context: Python execution context.
    @return: None
    '''    
    global cmd_info_number
    
    cmd_info_number += 1
    return cmd_info_id_tmo + "_" + str(cmd_info_number)

def getHbaCardTimeout(context):
    '''
    @summary: get timeout of HBA card in HP-UX system
    @param context: Python execution context.
    @return: None
    '''    
    
    devType = context.get("dev_type")
    isNewDevType = True
    for oldVersion in OldDevTypeVersionList:
        if devType.replace("HP-UX", "").strip().startswith(oldVersion):
            isNewDevType = False
            break
    log.info(context, "this device version is new: " + str(isNewDevType))
    if isNewDevType:
        HbaCardInfoList = getHbaTimo4NewSys(context)
    else:
        HbaCardInfoList = getHbaTimo4OldSys(context)
    log.info(context, "HP-UX device system hba card infomation is:" + str(HbaCardInfoList))
    
    #构造HBA卡超时时间信息并记录
    HbaCardInfoStr = ""
    if HbaCardInfoList is None:
        HbaCardInfoStr = str([GetErrHBATimeoutInfo])
    elif not HbaCardInfoList:
        HbaCardInfoStr = "NA"
    else:
        HbaCardInfoStr = str(HbaCardInfoList)
    getStringRet(context, str(HbaCardInfoStr).replace("u\'", "\'"))
    return

def getHbaTimo4OldSys(context):
    '''
    @summary: get timeout of HBA card in Old HP-UX system
    @param context: Python execution context.
    @return: HbaCardInfoList
    '''
    
    HbaCardInfoList = []
    #获取在线的端口信息
    onlineHwPathList = getOnlineHbaPath4OldSys(context)
    if onlineHwPathList is None:
        #获取信息异常
        return [GetErrHBATimeoutInfo]
    if not onlineHwPathList:
        return []
    
    #使用pvdisplay命令获取HBA卡参数的超时时间
    for hwPath in onlineHwPathList:
        #记录HBA卡信息
        command = "pvdisplay %s" % hwPath
        hbaTimeoutInfo = getSingleCommandPureRet(context, getCmdIndex(), command)
        #获取并记录端口信息
        HbaCardInfoDict = {"H/W Path": hwPath, "Timeout":"Error"}
        if "IO Timeout" in hbaTimeoutInfo:
            for line in hbaTimeoutInfo.splitlines():
                if line.strip().startswith("IO Timeout"):
                    fields = line.split()
                    #获取HBA卡超时时间并记录（存在数字和default的情况）
                    HbaCardInfoDict["Timeout"] = fields[-1].strip()
        HbaCardInfoList.append(HbaCardInfoDict)
    return HbaCardInfoList

def getOnlineHbaPath4OldSys(context):
    '''
    @summary: get online HBA H/W paths in old HP-UX system
    @param context: Python execution context.
    @return: list of online host ids
    '''        
    
    #步骤1：获取当前HBA卡的H/WPath列表
    hbaCardFcPaths = []
    command = "ioscan -fnC fc"
    hbaHwPathResult = getSingleCommandPureRet(context, getCmdIndex(), command)
    if "not found" in hbaHwPathResult:
        return None
    elif "H/W Path" not in hbaHwPathResult:
        return []
    for line in hbaHwPathResult.splitlines():
        if line.strip().startswith("fc"):
            fields = line.split()
            if len(fields) >= 7:
                hbaCardFcPaths.append(fields[2])
    log.info(context, "this system hba card list is:" + str(hbaCardFcPaths))
    if not hbaCardFcPaths:
        return []
    
    #步骤2：获取当前已映射LUN的的HBA卡的H/WPath映射关系
    diskHwPathDict = createDiskHwpathMap(context)
    if diskHwPathDict is None:
        return None
    elif not diskHwPathDict:
        return []
    #只获取在线的HBA卡的path（筛选本地磁盘）（步骤1和步骤2的H/W Path列表求交集）
    hbaHwPaths = []
    for diskHwPath in diskHwPathDict:
        #获取到的diskHwPath格式为：1/0/10/1/0/4/0.116.0.0.0.0.1
        if "." not in diskHwPath:
            continue
        #取点号前面的数据（HBA卡的H/W Path）
        diskHwPathPre = diskHwPath[:diskHwPath.index(".")]
        if diskHwPathPre in hbaCardFcPaths:
            hbaHwPaths += diskHwPathDict.get(diskHwPath)
    if not hbaHwPaths:
        return []
    log.info(context, "this system disk list is:" + str(hbaHwPaths))

    #步骤3：执行多路径软件命令，查看已经有PV创建的H/W Path
    hasPVHwPaths = []
    command = "vgdisplay -v | grep 'PV Name'"
    vgDisplayInfo = getSingleCommandPureRet(context, getCmdIndex(), command)
    if "PV Name" not in vgDisplayInfo:
        return []
    for line in vgDisplayInfo.splitlines():
        if "PV Name" not in line:
            continue
        fields = line.split()
        if len(fields) >= 3:
            hwPathTmp = fields[2]
            if hwPathTmp in hbaHwPaths:
                hasPVHwPaths.append(hwPathTmp)
    log.info(context, "this system online hba card H/W Path which has VP list is:" + str(hasPVHwPaths))
    return hasPVHwPaths

def createDiskHwpathMap(context):
    '''
    @summary: get disk H/W paths in old HP-UX system
    @param context: result of command "ioscan -funC disk"
    @return: map of disk and H/W Path
    '''

    diskHwPathDict = {}
    command = "ioscan -funC disk"
    diskHwPathResult = getSingleCommandPureRet(context, getCmdIndex(), command)
    if "not found" in diskHwPathResult:
        return None
    elif "H/W Path" not in diskHwPathResult:
        return diskHwPathDict
    
    hwPath = ""
    diskPathList = []
    for line in diskHwPathResult.splitlines():
        fields = line.split()
        if line.strip().startswith("disk"):
            #数据全部有效，记录数据(存在一个disk对应多个hw path、存在分多行显示情况)
            if hwPath and diskPathList:
                diskHwPathDict[hwPath] = diskPathList
            #disk path列表清空，继续查询下一个硬盘信息
            diskPathList = []
            if len(fields) >= 7:
                hwPath = fields[2]
        elif "/dev/dsk/" in line:
            for field in fields:
                if field.strip().startswith("/dev/dsk/") and field.strip() not in diskPathList:
                    diskPathList.append(field.strip())
    #最终再记录一次数据
    if hwPath and diskPathList:
        diskHwPathDict[hwPath] = diskPathList

    return diskHwPathDict

def getHbaTimo4NewSys(context):
    '''
    @summary: get timeout of HBA card in Old HP-UX system
    @param context: Python execution context.
    @return: HbaCardInfoList
    '''
        
    HbaCardInfoList = []
    #获取在线的端口信息
    onlineHwPathList = getOnlineHbaPath4NewSys(context)
    if onlineHwPathList is None:
        #获取信息异常
        return [GetErrHBATimeoutInfo]
    if not onlineHwPathList:
        return []
    
    for hwPath in onlineHwPathList:
        if "last successful login" in hwPath.lower():
            continue
        #记录HBA卡信息
        command = "scsimgr get_attr -H %s -a path_fail_secs"
        hbaTimeoutInfo = \
            getSingleCommandPureRet(context, getCmdIndex(),
                                    get_sudo_cmd(command, HPUX,
                                                 context) % hwPath)
        #获取并记录端口信息
        HbaCardInfoDict = {"H/W Path": hwPath, "Timeout":"Error"}
        if "current" in hbaTimeoutInfo:
            for line in hbaTimeoutInfo.splitlines():
                if line.strip().startswith("current"):
                    fields = line.split("=")
                    if len(fields) == 2:
                        #获取HBA卡超时时间并记录
                        HbaCardInfoDict["Timeout"] = fields[1].strip()
        HbaCardInfoList.append(HbaCardInfoDict)
    return HbaCardInfoList
    
def getOnlineHbaPath4NewSys(context):
    '''
    @summary: get HBA card HW paths in new HP-UX system
    @param context: Python execution context.
    @return: list of online host ids
    '''        
    
    #步骤1：先查询所有online的H/Wpath
    onlineDiskPaths = []
    command = "ioscan -P health -C disk"
    hbaHostResult = getSingleCommandPureRet(context, getCmdIndex(),
                                            get_sudo_cmd(command, HPUX,
                                                         context))
    if "not found" in hbaHostResult:
        return None
    elif "online" not in hbaHostResult:
        return []
    
    for line in hbaHostResult.splitlines():
        if "online" in line:
            fileds = line.split()
            if len(fileds) >= 4:
                onlineDiskPaths.append(fileds[2])
    log.info(context, "this device system online disk list is:" + str(onlineDiskPaths))
    if not onlineDiskPaths:
        return []
    
    #步骤2：通过获取SCSI协议筛选掉本地磁盘
    onlineHbaPaths = []
    for hbaPath in onlineDiskPaths:
        if "last successful login" in hbaPath.lower():
            continue
        cmd = "scsimgr lun_map -H %s | grep 'SCSI transport protocol'"
        command = get_sudo_cmd(cmd, HPUX, context) % hbaPath
        hbaProtocalResult = getSingleCommandPureRet(context, getCmdIndex(), command)
        if "fibre_channel" in hbaProtocalResult:
            onlineHbaPaths.append(hbaPath)
    log.info(context, "this device system online hba path list is:" + str(onlineHbaPaths))
    return onlineHbaPaths 


def cmd_execute(cmd_display, CLI, LANGUAGE, context):
    """
    @summary: get HBA card info in HP-UX system
    :param context: context
    :param LANGUAGE: LANGUAGE
    :param CLI: CLI
    :param cmd_display: cmd_display
    """

    fun_err_msg = ''
    hba_list = CLI.execCmdHasLog(
        get_sudo_cmd(cmd_info_hba_list, HPUX, context)).splitlines()
    for rg in range(len(cmd_info_id)):
        if cmd_info_id[rg] == "cmd_info_hba_card_fcmsutil":
            for hba in hba_list[1:]:
                # 兼容sudo采集时，第一行回显多余的
                if "last successful login" in hba.lower():
                    continue
                cmd_display_temp = CLI.execCmdHasLogTimout(
                    get_sudo_cmd(cmd_info_desc[rg], HPUX, context) + hba, 60)
                cmd_display_temp += CLI.execCmdHasLogTimout(
                    get_sudo_cmd(cmd_info_desc[rg], HPUX,
                                 context) + hba + " vpd", 60)
                cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:] + "_" + hba, cmd_display_temp)
                if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en" == LANGUAGE:
                        fun_err_msg += cmd_info_desc[rg] + hba + ":\texecute failed\r\n"
                    else:
                        fun_err_msg += cmd_info_desc[rg] + hba + u":\t执行失败\r\n"
                else:
                    if "en" == LANGUAGE:
                        fun_err_msg += cmd_info_desc[rg] + hba + ":\texecute success\r\n"
                    else:
                        fun_err_msg += cmd_info_desc[rg] + hba + u":\t执行成功\r\n"
        else:
            cmd_display_temp = CLI.execCmdHasLogTimout(
                get_sudo_cmd(cmd_info_desc[rg], HPUX, context), 60)
            cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_temp)
            if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en" == LANGUAGE:
                    fun_err_msg += cmd_info_desc[rg] + ":\texecute failed\r\n"
                else:
                    fun_err_msg += cmd_info_desc[rg] + u":\t执行失败\r\n"
            else:
                if "en" == LANGUAGE:
                    fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
                else:
                    fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    return
