# coding=utf-8
'''
    DocStr: collect HyperMetro feature configuration on hp-ux host
    Since: V3R1C00RC2
'''
import os
import sys
CURRENT_PATH = os.path.dirname(os.path.abspath(__file__))
sys.path.append(CURRENT_PATH)
CURRENT_PATH = os.path.join(CURRENT_PATH, "..\\..")
sys.path.append(CURRENT_PATH)

from common import util
from common import constants
CMD_MAP_OS_VERSION = {'id' : 'hpux_hypermetro_os_version',
                      'cmd' : 'swlist | grep HPUX11i'}
CMD_MAP_MAPPED_DISK = {'id':'hpux_hypermetro_mapped_disk' ,
                  'cmd' : 'ioscan -kfNnC disk'}
CMD_MAP_HYPERMETRO_PATH = {'id':'hpux_hypermetro_path_info' ,
                         'cmd' : 'scsimgr lun_map -D '}
OS_VERSION_V3_FLAG = 'b.11.3'
VENDER_HUAWEI_FLAG = 'huawei'
DISK_PATH_HUAWEI_FLAG = '/dev/rdisk/'

def execute(context):
    '''
    @Function describe  : collect hpux host HyperMetro information
    @param context: context
    '''
    #不需要返回，返回值都放context里面了
    doGrab(context)

def doGrab(context):
    '''
    @summary: 整个采集流程
    '''
    cmdDisplay = context.get("ret_map")
    errMsgs = ""
    util.updateItemProgress(context, constants.PROG20)
    #检查操作系统版本
    util.log.info(context, "[HP-UX] checking os version...")
    status, errMsg , cmdVersionResult = getResultMsg(context, CMD_MAP_OS_VERSION['cmd'])
    cmdDisplay.put("cmd_display_" + CMD_MAP_OS_VERSION['id'], cmdVersionResult)
    errMsgs += errMsg
    util.updateItemProgress(context, constants.PROG40)
    if not status or not isOsVerSupported(context, cmdVersionResult):
        cmdDisplay.put("err_msg", errMsgs)
        util.updateItemProgress(context, constants.PROG90)
        return

    #检查映射的磁盘
    util.log.info(context, "[HP-UX] start to fetch hyperMetro configuration.")
    status, errMsg, cmdMappedDiskResult = getResultMsg(context, CMD_MAP_MAPPED_DISK['cmd'])
    cmdDisplay.put("cmd_display_" + CMD_MAP_MAPPED_DISK['id'], cmdMappedDiskResult)
    errMsgs += errMsg
    util.updateItemProgress(context, constants.PROG60)
    #获取所有华为的磁盘路径
    diskPathList = getHuaweiDiskPathList(context, cmdMappedDiskResult)
    if not status or not diskPathList:
        cmdDisplay.put("err_msg", errMsgs)
        util.updateItemProgress(context, constants.PROG90)
        return

    #检查每个磁盘的路径信息
    util.updateItemProgress(context, constants.PROG80)
    for diskPath in diskPathList:
        cmd = CMD_MAP_HYPERMETRO_PATH["cmd"] + diskPath
        status, errMsg, diskPathInfo = getResultMsg(context, cmd)
        cmdDisplay.put("cmd_display_" + CMD_MAP_HYPERMETRO_PATH['id'] + diskPath, diskPathInfo)
        errMsgs += errMsg

    util.updateItemProgress(context, constants.PROG90)
    cmdDisplay.put("err_msg", errMsgs)

def getHuaweiDiskPathList(context, cmdMappedDiskResult):
    '''
    @summary: get huawei's disk path
    @return: disk path list
    '''
    huaweiDisks = []
    cmdMappedDiskResult = cmdMappedDiskResult.lower()
    isParseStart = False
    for line in cmdMappedDiskResult.splitlines():
        if isParseStart:
            lineParams = line.split()
            for diskPath in lineParams:
                if DISK_PATH_HUAWEI_FLAG in diskPath:
                    huaweiDisks.append(diskPath)
            #下一行不解析，需要再次匹配华为盘标志
            isParseStart = False
            continue

        if VENDER_HUAWEI_FLAG in line:
            isParseStart = True
    util.log.info(context, "[HP-UX] all the huawei disks are : " + str(huaweiDisks))
    return huaweiDisks

def isOsVerSupported(context, cmdVersionResult):
    '''
    @summary: 执行swlist | grep HPUX11i 查询系统信息，如果是V3就继续查询下面的命令，否则直接退出。
    @param cmdVersionResult: cmdVersionResult
    '''
    for line in cmdVersionResult.lower().splitlines():
        if OS_VERSION_V3_FLAG in line:
            return True
    util.log.info(context, "[HP-UX] os version is not V3, break...")
    return False

def getResultMsg(context, stepName):
    '''
    @summary: get result status's message
    @param stepName: 命令
    '''
    sshCon = context.get("SSH")
    lang = context.get("lang")

    cmdResultTemp = sshCon.execCmdWithTimout(stepName, constants.HOST_CMD_TIMEOUT)

    resultMsg = ""
    status = True
    if not cmdResultTemp or\
        'TOOLKIT_SEND_CMD_TIME_OUT' in  cmdResultTemp or\
            'TOOLKIT_EXE_CMD_FAILED' in cmdResultTemp:
        status = False

    if "en" == lang:
        if status:
            resultMsg += stepName + ":\texecute success\r\n"
        else:
            resultMsg += stepName + ":\texecute failed\r\n"
    else:
        if status:
            resultMsg += stepName + u":\t执行成功\r\n"
        else:
            resultMsg += stepName + u":\t执行失败\r\n"


    return status, resultMsg, cmdResultTemp
