# coding=utf-8

# 获取linux主机的逻辑卷信息
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common import util
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import HPUX

cmd_info_id = [
    "cmd_info_logic_volum_lvmadm_1_0",
    "cmd_info_logic_volum_lvmadm_2_0",
    "cmd_info_logic_volum_lvmadm_2_1",
    "cmd_info_logic_volum_lvmadm_2_2",
    "cmd_info_logic_volum_swlist_MirrorDisk",
    "cmd_info_logic_volum_strings_lvmtab",
    "cmd_info_logic_volum_strings_lvmpvg",
    "cmd_info_logic_volum_vgdisplay",
    "cmd_info_logic_volum_swlist_vxvm",
]

cmd_info_desc = [
    "lvmadm -l -V 1.0",
    "lvmadm -l -V 2.0",
    "lvmadm -l -V 2.1",
    "lvmadm -l -V 2.2",
    "swlist|grep MirrorDisk",
    "strings /etc/lvmtab",
    "strings /etc/lvmpvg",
    "vgdisplay -v",
    "swlist -l product | grep vxvm",
]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    cli = context.get("SSH")
    language = context.get("lang")
    cmd_display = context.get("ret_map")
    return cmd_execute(context, cmd_display, cli, language)


def cmd_execute(context, cmd_display, cli, language):
    temp_step = constants.PROG90 / len(cmd_info_id)
    cur_step = temp_step
    fun_err_msg = ''
    for index, id_tmp in enumerate(cmd_info_id):
        cur_step += temp_step
        util.updateItemProgress(context, cur_step)
        cmd_display_temp = cli.execCmdHasLogTimout(get_sudo_cmd(cmd_info_desc[index], HPUX, context), 60)
        cmd_display.put("cmd_display" + id_tmp[8:], cmd_display_temp)
        if not cmd_display_temp \
                or 'TOOLKIT_SEND_CMD_TIME_OUT' in cmd_display_temp \
                or 'TOOLKIT_EXE_CMD_FAILED' in cmd_display_temp:
            if "en" == language:
                fun_err_msg += cmd_info_desc[index] + ":\texecute failed\r\n"
            else:
                fun_err_msg += cmd_info_desc[index] + u":\t执行失败\r\n"
        else:
            if "en" == language:
                fun_err_msg += cmd_info_desc[index] + ":\texecute success\r\n"
            else:
                fun_err_msg += cmd_info_desc[index] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    return cmd_display
