#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@version: SmartKit V200R006C00
@time: 209/10/25
@file: hpux_lun_wwn_info.py
@function:
@modify:
"""

import sys
import os
import traceback

current_absolute_path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(current_absolute_path, "..\\..")
sys.path.append(path)
from common.contentParse import create_result_info
from common import constants
from common.util import log, HostResultInfo, HostLunInfo, \
    create_lun_info, get_host_wwn_info

LAUNCHER = "ioscan -funC fc or iscsiutil -l"


def get_result_info(context):
    """
    :param context:
    :return:
    """
    host_result_info = HostResultInfo()
    host_lun_info = HostLunInfo()
    cli = context.get("SSH")
    host_lun_info.set_host_id(cli.getHost())
    cli_rets = ''

    try:
        # from launcher get initiator info
        _, cli_rets, initiator_wwn = get_host_wwn_info(context)
        if initiator_wwn:
            host_lun_info.set_initiator(initiator_wwn)
            host_result_info.set_hosts(host_lun_info)
        else:
            log.info(context, "Cannot find host initiator info, set pass.")
            create_result_info(context, "True", cli_rets, LAUNCHER,
                               host_result_info)
            return

        is_qry_succ, fail_cmd, cli_ret, disk_wwn_dict = qry_lun_wwn_info(
            context)
        cli_rets += cli_ret
        if is_qry_succ:
            create_lun_info(host_lun_info, disk_wwn_dict)
            host_result_info.set_hosts(host_lun_info)
            create_result_info(context, "nocheck", cli_rets, "",
                               host_result_info)
        else:
            create_result_info(context, "False", cli_rets, fail_cmd,
                               host_result_info)
    except Exception as e:
        log.info(context, "get host result info exception:%s:%s" % (
            e, str(traceback.format_exc())))
        create_result_info(context, "False", cli_rets, '',
                           host_result_info)


def qry_lun_wwn_info(context):
    """
    :param context:
    :return:
    """
    cli = context.get("SSH")
    all_lun_wwn_dict = {}
    is_qry_succ, fail_cmd, cli_ret, disk_letters = query_disks_info(context)
    if not is_qry_succ:
        log.error(context, 'Query array managed by ultrapath failed.')
        return False, fail_cmd, cli_ret, {}

    for disk_letter in disk_letters:
        wwid = ''
        rdisk_ = 'scsimgr lun_map -D /dev/rdisk/'
        try:
            disk_wwn_ret = cli.execCmdWithNoCheckResult(
                rdisk_ + disk_letter,
                constants.HOST_CMD_TIMEOUT)
            cli_ret += disk_wwn_ret
            for line in disk_wwn_ret.splitlines():
                line = line.strip().lower()
                if "world wide identifier" in line:
                    wwid = len(line.split("=")) > 1 \
                           and line.split("=")[1].strip()[2:] or wwid
                if wwid and wwid not in all_lun_wwn_dict.keys():
                    all_lun_wwn_dict[wwid] = disk_letter

            log.info(context, 'lun wwns are:' + str(all_lun_wwn_dict))

        except Exception as e:
            log.error(context,
                      'Query array IDs exception:' + str(e))
            return False, rdisk_ + disk_letter, cli_ret, {}

    return True, '', cli_ret, all_lun_wwn_dict


def query_disks_info(context):
    """
    :param context:
    :return:
    """
    cli = context.get("SSH")
    disk_letters = []
    cli_ret = ''
    vlu_id_cmd = "ioscan -kfNnC disk"
    try:
        cli_ret = cli.execCmdWithNoCheckResult(vlu_id_cmd,
                                               constants.HOST_CMD_TIMEOUT)
        for line in cli_ret.splitlines():
            line = line.strip().lower()
            if line.startswith("/dev/disk/"):
                disk_letter = line.split("/")[3].strip()
                disk_letters.append(disk_letter)
        log.info(context, "disk letter's number is : %s." % disk_letters)
        return True, '', cli_ret, disk_letters
    except Exception as e:
        log.error(context, 'Query disk IDs exception:' + str(e))
        return False, vlu_id_cmd, cli_ret, []
