# coding=utf-8
__author__ = '******'
# 获取hpux主机的多路径信息
import re
import sys 
import os
reload(sys) 
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import util
from common import constants
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import HPUX

CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
cmd_info_id = ["cmd_info_multipath_ioscan_funnc_disk",
               "cmd_info_multipath_ioscan_func_disk",
               "cmd_info_multipath_scsimgr",
               "cmd_info_multipath_ioscan_dsf",
               "cmd_info_multipath_status",
               "cmd_info_multipath_preferred_path",
               "cmd_info_multipath_ioscan_fnc_fc",
               "cmd_info_multipath_ioscan_funnc_disk_grep",
               "cmd_info_multipath_ioscan_funnc_disk_pathinfo",
               "cmd_info_multipath_lun_wwn"]

cmd_info_desc = ["ioscan -funNC disk",
                 "ioscan -funC disk",
                 "scsimgr lun_map",
                 "ioscan -m dsf",
                 "scsimgr get_attr -a leg_mpath_enable",
                 "scsimgr get_attr -a preferred_path -D ",
                 "ioscan -fnC fc",
                 "ioscan -funNC disk|grep 'disk '|awk '{print $2}'",
                 "ioscan -kfnNC lunpath",
                 "scsimgr -p get_attr all_lun -a hw_path -a device_file -a wwid"]

cmd_info_mutipath_disk_list = "ioscan -funNC disk|grep 'disk '|awk '{print $2}'"

def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(cmd_display, CLI, LANGUAGE,context))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(cmd_display, CLI, LANGUAGE, context):
    fun_flag = CHECK_FAIL
    fun_err_msg = ''

    diskInfoStr = CLI.execCmdHasLog(
        get_sudo_cmd(cmd_info_mutipath_disk_list, HPUX, context))
    util.updateItemProgress(context, constants.PROG5)
    disk_list = diskInfoStr.splitlines()
    #修复问题：HP-UX 11i v1、v2老版本不兼容此命令
    if "illegal option" in diskInfoStr:
        disk_list = disk_list[:1]
        
    #命令新增：scsimgr get_info -D /dev/rdisk/<diskid> ；scsimgr get_attr -D  /dev/rdisk/<diskid> -alua_enabled     
    if len(disk_list) > 1:
        for disk in disk_list[1:]:
            if "last successful login" in disk.lower():
                continue
            cmd = "scsimgr get_info -D /dev/rdisk/disk%s"
            cmd_info_desc.append(get_sudo_cmd(cmd, HPUX, context) % disk)
            cmd_info_id.append("cmd_info_multipath_disk_configinfo_%s" % disk)

        for disk in disk_list[1:]:
            if "last successful login" in disk.lower():
                continue
            cmd = "scsimgr get_attr -D  /dev/rdisk/disk%s -a alua_enabled"
            cmd_info_desc.append(get_sudo_cmd(cmd, HPUX, context) % disk)
            cmd_info_id.append("cmd_info_multipath_alua_configinfo_%s" % disk)
    
    ppStep = constants.PROG60 / (len(cmd_info_id) - 1)
    for rg in range(len(cmd_info_id)):
        if  cmd_info_id[rg]=="cmd_info_multipath_preferred_path":
            if len(disk_list) == 1:
                util.addItemProgress(context, constants.PROG25)
            prgStep, stepsUnit = util.calcPerStepDetail(constants.PROG25, len(disk_list[1:]))
            idx = 0
            for disk in disk_list[1:]:
                if "last successful login" in disk.lower():
                    continue
                cmd_display_temp = CLI.execCmdHasLogTimout(
                    get_sudo_cmd(cmd_info_desc[rg], HPUX,
                                 context) + "/dev/rdisk/disk" + disk, 60)
                util.itemProgressIncr(context, idx, prgStep, stepsUnit)
                idx += 1
                cmd_display_temp = cmd_display_temp.replace('','')
                cmd_display_temp = cmd_display_temp.replace(' _','_')
                cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:] + "/dev/rdisk/disk" + disk, cmd_display_temp)
                if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
                else:
                    if "en"==LANGUAGE:
                        fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
                    else:
                        fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
        else:
            cmd_display_temp = CLI.execCmdHasLogTimout(
                get_sudo_cmd(cmd_info_desc[rg], HPUX, context), 60)
            util.addItemProgress(context, ppStep)
            cmd_display_temp = cmd_display_temp.replace('','')
            cmd_display_temp = cmd_display_temp.replace(' _','_')
            cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
            if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
            else:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg