# -*- coding: UTF-8 -*-
#hp-ux 多路径信息检查
import os
import re
import sys
import traceback
from com.huawei.common import MagicNumber

dirPath = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(dirPath, "..\\..")
sys.path.append(path)
sys.path.append(os.path.join(dirPath, ".."))

from common.util import parseWwpn
from vmware.vmware_multipath_info_check import verifyDeivce
import common.constants as CONSTANT
from com.huawei.ism.tool.infograb.context import EvalResultEnum
from com.huawei.ism.tool.infograb.context import ItemEvalResult

CLI = None
LANGUAGE = None
LOG = None
CHECK_FAIL = 0
CHECK_PASS = 1
#total device size
ALL_DEVICE_SIZE = None
NMP_CURRENT = 'current'
NMP_DEFAULT = 'default'
CLAIMED = 'claimed'
ACTIVE = 'active'
HUAWEI = 'huawei'
PATH_FLAG = 'class'
HPUX_NMP_COMMAND = "ioscan -funNC disk"
WWPN_STATE_CMD = "ioscan -P health | grep lunpath"
HPUX = "hp-ux"
HARDWARE_PATH = "hardware path"
STATE = "state"
CLOSE = "close"
LAST_OPEN = "last open"
UNOPEN = "unopen"
DEVICE = "device"
commandNMP = "scsimgr get_attr -a leg_mpath_enable"
COMMAND_DESC = "cmd_display_hpux_mulitipath_check_result_str"
COMMAND_DESC2 = "cmd_display_hpux_mulitipath_status_result_str"
HPUX_NMP_QUERY_FAIL_UNABLE_TIPS = "eval.host.mulitipath.info.check.hpux.nmp.version.query.fail.unable.eval.tips"
MAGIC_INT3 = 3
#存储信息字典
multiInfo = {}
#不通过的设备列表
failDeviceList = []
#执行失败的命令列表
commandFailureList = []
#command execute result list
executeCommandRet = []
#query device failure list
queryDeivceFailList = []
#IP
IP = None

#路径检测执行
def multipathExecute(context):
    """
    @summary: 执行主方法
    @param context: 上下文
    @return: 返回执行结果 
    """
    # 给全局变量赋初始值，传递上下文。
    global CLI
    CLI = context.get("SSH")
    #语言类型
    global LANGUAGE
    LANGUAGE = context.get("lang")
    #get logger
    global LOG
    LOG = context.get("Logger")
    
    global IP
    IP = CLI.getHost()
    LOG.info("***[start executing hpux info check]***")
    try:
        data = checkAndGetResult(context, CLI, LANGUAGE)
        if data[0]:
            LOG.info("***[evaluate pass]***")
        else:
            LOG.info("***[evaluate failure]***")
        #将评估结果写入txt中
        cmd_display = context.get("ret_map")
        result = data[1]
        '''
        #结果 为字典结构。将其转换成字符串，存入txt;
        #读取出该字符串后，使用eval()方法，可以将该结果在换成字典
        '''
        resultStr = ''
        if result:
            resultStr = CONSTANT.RESULT_FLAG + result.getEvalResultJsonString()
        LOG.info("***[evaluate result is: " + resultStr + "]***")
        cmd_display.put(COMMAND_DESC, resultStr)
        #save evaluate result
        cmd_display.put("evalResult", result)
        resultStr2 = CONSTANT.RESULT_FLAG + str(makeMultipathInfo())
        LOG.info("***[multipath status info is: " + resultStr2 + "]***")
        #多路径状态信息写入text
        cmd_display.put(COMMAND_DESC2, resultStr2)
        return cmd_display
    except:
        msg = traceback.format_exc()
        LOG.error("hupx multipath execute ==> " + msg)

def checkAndGetResult(context, CLI, LANGUAGE):
    '''
    @summary: 评估，并返回评估结果
    @param context: 上下文
    @param CLI: SSH
    @param LANGUAGE: 语言类型
    '''
    LOG.info("***[start executing checkAndGetResult()]***")
    flag = False
    result = None
    #若不是可支持的操作系统
    if not isHpuxOs(context):
        LOG.info("***[is not hpux system]***")
        evalMessage = CONSTANT.OS_NOT_SUPPORT_TIPS
        paramList = []
        result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.UNABLE_EVAL, evalMessage, ''.join(executeCommandRet), paramList)
        return flag, result
    #判断是否含有多路径，自研和自带不存在共存的情况
    if hasMultipath(context):
        #多路径类型
        typeFlag = multiInfo[CONSTANT.MULTI_PATH_TYPE]
        #自带多路径
        if typeFlag == CONSTANT.NMP:
            LOG.info("***[entry nmp check]***")
            flag = nmpCheck(context)
        #evaluate fail
        if not flag:
            #get device list fail
            if commandFailureList and HPUX_NMP_COMMAND in commandFailureList:
                multiInfo[CONSTANT.NOT_PASS_DEVICE] = failDeviceList
                paramList = [HPUX_NMP_COMMAND] 
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.donot.get.disk.information', ''.join(executeCommandRet), paramList)
            elif commandFailureList and  WWPN_STATE_CMD in commandFailureList:
                multiInfo[CONSTANT.NOT_PASS_DEVICE] = failDeviceList
                paramList = []
                evalMessage = CONSTANT.CHECK_HPUX_ONLINE_WWPN_UNABLE_TIPS
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage, ''.join(executeCommandRet), paramList)
            else:
                result = multiInfo["result"]         
        #evaluate success
        else:
            result = multiInfo["result"] 
    #不存在多路径，则评估不通过
    else:
        result = multiInfo["result"] 
    return flag, result

def nmpCheck(context):
    '''
    @summary: 自带多路径评估
    @param context : 上下文
    @return: flag
    '''
    LOG.info("***[start executing nmpCheck()]***")
    flag = False
    command = HPUX_NMP_COMMAND
    commandDesc = "hpux_multipath_info_check_nmp"
    try:
        ret = oneCmdExecute(command, commandDesc, context.get("ret_map"), CLI, LANGUAGE)
        #save execute result
        executeCommandRet.append(ret[2])
        devices = []
        if ret[0] == 1:
            lineList = ret[2].splitlines()
            LOG.info("***[lineList = " + str(lineList) + "]***")
            #从第二行截取
            if len(lineList) > 2:
                #读取出device，并装入devices列表
                i = 0
                while i < len(lineList):
                    line = lineList[i]
                    if CLAIMED in line.lower() and HUAWEI in line.lower():
                        index = i + 1
                        if index < len(lineList):
                            item = lineList[index]
                            LOG.info("***[content of device in line : " + item + "]***")
                            item = item.strip()
                            items = re.split('\s+', item)
                            if items and CLAIMED not in item.lower() and DEVICE not in item.lower():
                                devices.append(str(items[-1].strip()))
                                i = index
                    i = i + 1 
            LOG.info("***[devices= " + str(devices) + "]***")
            #对所有设备进行评估
            if devices:
                #save total device size
                ALL_DEVICE_SIZE = len(devices)
                flag = evaluateDevicesMultipath(devices, context)
            else: 
                commandFailureList.append(command)
                return flag    
            #不用过FAILED； 通过，PASS，
            result = None
            if flag:
                evalMessage = ""
                paramList = []
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.PASSED, evalMessage, ''.join(executeCommandRet), paramList)  
            #evaluate fail's condition
            else:
                #query all device info fail
                if ALL_DEVICE_SIZE == len(queryDeivceFailList):
                    LOG.info("***[all device query fail]***")
                    paramList = [str(IP), ','.join(queryDeivceFailList)]
                    result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.self.donot.have.redundant.path', ''.join(executeCommandRet), paramList)
                #query part device info fail
                elif queryDeivceFailList and ALL_DEVICE_SIZE != len(queryDeivceFailList):
                    LOG.info("***[part device query fail]***")
                    paramList = [str(IP), ','.join(queryDeivceFailList + failDeviceList)] 
                    result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.self.donot.have.redundant.path', ''.join(executeCommandRet), paramList)
                #some device fail
                else:
                    LOG.info("***[some device not passed]***")
                    paramList = [str(IP), ','.join(failDeviceList)]
                    LOG.info("***[failDeviceList= " + ','.join(failDeviceList) + "]***")
                    result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.self.donot.have.redundant.path', ''.join(executeCommandRet), paramList)  
                    multiInfo[CONSTANT.NOT_PASS_DEVICE] = failDeviceList
            #将结果写入multiInfo
            multiInfo['result'] = result       
        #命令失败返回什么结果
        else:
            LOG.info("***[command execute failure: " + command + " ]***")
            commandFailureList.append(command)
        
        return flag                  
    except:
        msg = traceback.format_exc()
        LOG.error("nmpCheck ==> " + msg)
        return flag


def addOnlineWwpn2List(onlineWwpnList, ret):
    '''
    @summary:检查所有磁盘是否通过评估
    @param onlineWwpnList : 在线的wwpn集合
    @param ret :命令回文
    '''
    lineList = ret[MagicNumber.INT2].splitlines()
    if 1 < len(lineList):
        for singleLine in lineList:
            if singleLine.lower().startswith("lunpath") and singleLine.lower().endswith("online"):
                tempList = singleLine.split('.')
                if MagicNumber.INT3 == len(tempList):
                    onlineWwpnList.append(tempList[1])
    LOG.info("all online wwpn are: " + str(onlineWwpnList))

def evaluateDevicesMultipath(deviceNames, context):
    '''
    @summary:检查所有磁盘是否通过评估
    @param deviceNames : 磁盘集合
    @param context :上下文
    '''
    LOG.info("***[start executing evaluateDevicesMultipath()]***")
    flag = False
    command = "scsimgr lun_map -D "

    wwpnStateCmdDesc = "hpux_multipath_info_check_wwpn_state"
    cmd_display = context.get("ret_map")
    onlineWwpnList = []

    try:
        #把所有online的wwpn查询出来
        ret = oneCmdExecute(WWPN_STATE_CMD, wwpnStateCmdDesc, cmd_display, CLI, LANGUAGE)
        #save execute result
        executeCommandRet.append(ret[2])
        if ret[0] == 1:
            addOnlineWwpn2List(onlineWwpnList, ret)
            if not onlineWwpnList:
                LOG.info("***[command execute failure: " + WWPN_STATE_CMD + " ]***")
                commandFailureList.append(WWPN_STATE_CMD)
                return False
        else:
            LOG.info("***[command execute failure: " + WWPN_STATE_CMD + " ]***")
            commandFailureList.append(WWPN_STATE_CMD)
            return False

        #检查所有磁盘是否通过评估                
        resultFlag = True
        if deviceNames:
            for deviceName in deviceNames:
                #每个设备返回的结果进行与操作
                currFlag = evaluateDeviceMultipath(command + deviceName, deviceName, context, onlineWwpnList)
                resultFlag = resultFlag and currFlag
            flag = resultFlag
        return flag       
    except:
        msg = traceback.format_exc()
        LOG.error("evaluateDevicesMultipath ==> " + msg)
        return flag

def evaluateDeviceMultipath(command, deviceName, context, onlineWwpnList):
    '''
    @summary:单个磁盘检查是否通过评估
    @param cmmand : 执行命令
    @param deviceName : 设备名称
    @param context :上下文
    '''
    LOG.info("***[start executing evaluateDeviceMultipath()]***")
    flag = False
    commandDesc = "hpux_multipath_info_check_nmp_disk_"
    cmd_display = context.get("ret_map")
    try:
        ret = oneCmdExecute(command, commandDesc + deviceName, cmd_display, CLI, LANGUAGE)
        #save execute result
        executeCommandRet.append(ret[2])
        wwpns = []
        resultDict = {}
        if ret[0] == 1:
            lineList = ret[2].splitlines()
            #处理磁盘信息，获取wwpn列表
            wwpns, isSuccess = getWwpns(lineList, onlineWwpnList)
            LOG.info("***[wwpns=  + " + str(wwpns) + "]")
            #遍历每一个wwpn,并进行转换
            if wwpns:
                for item in wwpns:
                    LOG.info("***[strWwpn=  + " + item + "]")
                    getDictFromWwpn(context, item, resultDict)
                LOG.info("***[resultDict= " + str(resultDict) + "]***")
                flag = verifyDeivce(resultDict)
                
            elif not isSuccess:
                queryDeivceFailList.append(deviceName)
                return flag
            #评估不通过，记录不通过设备名称
            if not flag:
                LOG.info("***[deviceName=  + " + deviceName + "]")    
                failDeviceList.append(deviceName)
        #命令执行失败
        else:
            LOG.info("***[command execute failure: " + command + " ]***")
            commandFailureList.append(command)
            #query fail,save device name
            queryDeivceFailList.append(deviceName)
        return flag         
    except:
        msg = traceback.format_exc()
        LOG.error("evaluateDeviceMultipath ==> " + msg)
        return flag

def getWwpns(lineList, onlineWwpnList):
    '''
    @summary: 读取含wwpn的字符串，并进行相应字符串处理
    @param lineList:  执行命令后取得的磁盘信息列表
    '''
    flag = False
    try:
        i = 0
        wwpns = []
        while i < len(lineList):
            '''
            #从class所在行开始读取数据，
            #每一个lunpath均包含class
            '''
            line = lineList[i]
            #进入一个path的标志
            if PATH_FLAG in line.lower():
                num = 0
                wwpn = ''
                stateLine = ''
                lastOpenLine = ''
                index = i + 1
                while index < len(lineList):
                    item = lineList[index]
                    if HARDWARE_PATH in item.lower():
                        datas = item.split('=')
                        data = datas[1].strip()
                        wwpn = data.split('.')[1]
                        num = num + 1
                    elif STATE in item.lower() and not (CLOSE in item.lower()):
                        stateLine = item
                        num = num + 1
                    #读取到含有last open 的行时，即可跳出该内层循环
                    elif LAST_OPEN in item.lower():
                        lastOpenLine = item
                        num = num + 1
                    elif PATH_FLAG in item.lower():
                        break
                    elif num == MAGIC_INT3:
                        break
                    #内循环index自增1
                    index = index + 1
                if num == MAGIC_INT3 and wwpn in onlineWwpnList:
                    #路径满足条件，将wwpn装入列表
                    wwpns.append(wwpn)
                    flag = True
                elif not flag and stateLine and lastOpenLine:
                    flag = True
                    
                i = index
            #i自增1，读取下一行
            else:
                i = i + 1
                
        return wwpns, flag                  
    except:
        msg = traceback.format_exc()
        LOG.error("evaluateDeviceMultipath ==> " + msg)
        return wwpns, False
        
def transStr2Wwpn(strWwpn):
    '''
    @summary:将字符串转换成整数
    @param strWwpn : 字符串wwpn，每个字节以冒号分隔
    '''
    LOG.info("***[start executing transStr2Wwpn()]***")
    LOG.info("***[strWwpn= " + strWwpn + "]")
    #先将字符串转换成int型整数
    intWwpn = int(strWwpn, 16)
    return intWwpn

def getDictFromWwpn(context, strWwpn, resultDict):
    '''
    @summary:将字符串转换成整数
    @param strWwpn : 字符串wwpn，以0x开头
    @param resultDict: 保存控制引擎及节点映射的数据
    @return: 返回数据字典 
    '''
    if strWwpn.startswith('0x'):
        isSuccess, ctrlEncMac, nodeId = parseWwpn(context, strWwpn)
        if not isSuccess:
            LOG.info("***[Parse WWPN failed]***")
        else:
            if ctrlEncMac in resultDict:
                nodeDict = resultDict[ctrlEncMac]
            else:
                nodeDict = {}
                # 将0、1面均初始化为 0
                nodeDict['0'] = 0
                nodeDict['1'] = 0
            nodeDict[str(nodeId % 2)] = 1
            resultDict[ctrlEncMac] = nodeDict
    else:
        LOG.info("***[wwpn is not hex]***")
            
def hasMultipath(context):
    '''
    @summary:判断是否安装了自研或者自带多路径
    @param context : 上下文
    '''
    LOG.info("***[start executing hasMultipath()]***")
    flag = False
    try:
        '''
        #当前只支持自带多路径
        #判断是否有自带多路径
        '''
        flag = hasNMP(context)
        if flag:
            LOG.info("***[this host has nmp]***")
        elif commandNMP in commandFailureList:
            return flag
        else:
            paramList = []
            result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.self.donot.exist', ''.join(executeCommandRet), paramList)
            multiInfo["result"] = result   
        return flag
    except:
        msg = traceback.format_exc()
        LOG.error("hasMultipath ==> " + msg)
        return flag     

def hasNMP(context):
    '''
    @summary:判断是否带有自带多路径
    @param context : 上下文
    '''
    LOG.info("***[start executing hasNMP()]***")
    flag = False
    commandDesc = "hpux_multipath_info_check_has_nmp"
    cmd_display = context.get("ret_map")
    try:
        ret = oneCmdExecute(commandNMP, commandDesc, cmd_display, CLI, LANGUAGE)
        #save execute result
        executeCommandRet.append(ret[2])
        #检查是否命令执行成功
        if ret[0] == 1:
            containCurrent = ''
            containDefault = ''
            lineList = ret[2].splitlines()
            for line in lineList:
                LOG.info("***[" + line + "]***")
                if NMP_CURRENT in line.lower():
                    containCurrent = line
                elif NMP_DEFAULT in line.lower():
                    containDefault = line
            if 'true' in containCurrent.lower() and 'true' in containDefault.lower():
                flag = True
                multiInfo[CONSTANT.MULTI_PATH_TYPE] = CONSTANT.NMP
                LOG.info("***[NMP is enable]***") 
        else:
            LOG.info("***[command execute failure: " + commandNMP + "]***")
            commandFailureList.append(commandNMP)
            paramList = [] 
            result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.self.donot.exist', ''.join(executeCommandRet), paramList)
            multiInfo["result"] = result
        #返回前记录NMP是否含有，用于多路径评估使用
        if flag:
            multiInfo["SelfMultiPath"] = "enabled"
        else:
            multiInfo["SelfMultiPath"] = "disabled"
        return flag
    except:
        msg = traceback.format_exc() 
        LOG.error("hasNMP ==> " + msg)
        return flag   
    
def isHpuxOs(context):
    '''
    @summary: 检查操作系统是否为HP-UX
    @param context: 上下文
    '''
    LOG.info("***[start executing isHpuxOs()]***")
    flag = False
    command = "uname -a"
    commandDesc = "hpux_multipath_info_check_os"
    cmd_display = context.get("ret_map")
    try:
        ret = oneCmdExecute(command, commandDesc, cmd_display, CLI, LANGUAGE)
        if ret[0]:
            osType = ret[2]
            if osType:
                if HPUX in osType.lower():
                    flag = True
        return flag
    except:    
        msg = traceback.format_exc() 
        LOG.error("isHpuxOs ==> " + msg)
        return flag 

def oneCmdExecute(command, commandDesc, cmd_display, CLI, LANGUAGE):
    '''
    @summary:获取单一命令执行结果
    @param command : shell 命令
    @param commandDesc: 命令描述
    @param cmd_display: 保存结果的map
    @param CLI: SSH连接
    @param LANGUAGE: 语言类型
    '''
    flag = CHECK_FAIL
    errMsg = ''
    LOG.info("***[execute command: " + command + "]***") 
    result = CLI.execCmdWithNoCheckResult(command, CONSTANT.HOST_CMD_TIMEOUT)
    cmd_display.put("cmd_display_" + commandDesc, result)
    regx = ["toolkit_send_cmd_time_out","toolkit_exe_cmd_failed", "not found", "unknown command", "can't find"]
    if None == result or '' == result or filter(lambda x : x in result.lower(), regx):
        if "en" == LANGUAGE:
            errMsg += command + ":\texecute failed\r\n"
        else:
            errMsg += command + u":\t执行失败\r\n"
    else:
        if "en" == LANGUAGE:
            errMsg += command + ":\texecute success\r\n"
        else:
            errMsg += command + u":\t执行成功\r\n"
        
        flag = CHECK_PASS 
        
    oldErrMsg = None
    try:
        oldErrMsg = cmd_display.get('err_msg')
    except:
        LOG.error('get old error message failed.')
    if oldErrMsg:
        errMsg = oldErrMsg + errMsg
    
    cmd_display.put("err_msg", errMsg)
    LOG.info("***[" + errMsg + "]***")
    return flag, cmd_display, result

#构造多路径信息，评估使用
def makeMultipathInfo():
    '''
    @summary: 构造多路径信息，评估使用
    '''
    dataDict = {}
    versionStr = 'NA'
    if "version" in multiInfo:
        versionStr = str(multiInfo["version"])
    dataDict["HuaweiMultipathVersion"] = versionStr
    dataDict["SelfMultiPath"] = multiInfo["SelfMultiPath"]
    dataStr = str(dataDict)
    return dataStr
