# -*- coding: UTF-8 -*-
#hp-ux 多路径信息检查
import os
import sys
import traceback

dirPath = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(dirPath, "..\\..")
sys.path.append(path)
sys.path.append(os.path.join(dirPath, ".."))
from common import util
from common import constants
from common.util import parseWwpn
from vmware.vmware_multipath_info_check import verifyDeivce
import common.constants as CONSTANT
from com.huawei.ism.tool.infograb.context import EvalResultEnum
from com.huawei.ism.tool.infograb.context import ItemEvalResult
CLI = None
LANGUAGE = None
LOG = None
IP = None

#评估结果： 评估通过、评估不通过(需要提示什么原因) ，无法评估
MAIN_PV = 'mainPv'
BACK_PV = 'backPv'
DISK_EVAL_RESULT = 'evalResult'

DISK_PATH_STATE = 'mainPvState'
BAK_PV_STATE = 'bakPvState'


CMD_IDS = 'cmdids'
CMD_DESC = 'cmddescs'

CAN_NOT_VOL = "Couldn't find the volume group to which"
CAN_NOT_DISPHY = "Cannot display physical volume"

#评估结果
PV_CANOT_EVAL = 'pvCanNotEval'
PASS = 'pass'
NOT_PASS = 'notPass'
PVSTATE_NOTEVAL = 'pvStateCanNot'


#hwpath状态
CLAIMED = 'CLAIMED'
NO_HW = 'NO_HW'


COMMAND_CHECK_DESC = "cmd_display_hpux_mulitipath_check_result_str"
COMMAND_STATUS_DESC = "cmd_display_hpux_mulitipath_status_result_str"

BACK_PATH_DESC = 'alternate'
MAIN_PATH_DESC = 'mainpath'

#命令
HW_PATH_CMD = "ioscan -funC fc"
PATH_DISK_CMD = "ioscan -funC disk"
PV_DISK_CMD = "pvdisplay "

pvDisplayDevLst = []
#多路径相关命令的回文，单个元素是单个命令回文
executeCommandRetLst = []

#各种命令集合
cmdInfoId = []
cmdInfoDesc = []

#检查是否有冗余路径命令集合
cmdInfoPvIdLst = []
cmdInfoPvDescLst = []

#冗余路径list
pathFcxLst = []           # ioscan -funC fc 方法：getPathFcxLst
hwPathDiskPathObjLst = [] #ioscan -funC disk 方法：getPathDiskMatchLst
redundancyPvLst = []      # pvdisplay /dev/dsk/c22t0d3 | grep 'PV Name'   方法：excuteCheckPvCmds()

multiInfo = {}

#hp v1v2版本多路径冗余检查
def multipathExecuteHpV1V2(context):
    """
    @summary: 执行主方法
    @param context: 上下文
    @return: 返回执行结果 
    """
    global CLI
    global LOG
    global IP

    global pathFcxLst
    global hwPathDiskPathObjLst
    global redundancyPvLst
    global pvDisplayDevLst
    
    
    global contextDisplay

    LOG = context.get("Logger")
    CLI = context.get("SSH")
    IP = CLI.getHost()
    contextDisplay = context.get("ret_map")

    #自带多路径是否可用 ：默认为disabled
    multiInfo["SelfMultiPath"] = "disabled"

    #构造 无参命令、查询主备路径的命令
    createMultiCmds(CLI)

    #步骤 二、三
    excuteCmds(context, cmdInfoId, cmdInfoDesc, None)

    #步骤四：执行命令pvdisplay /dev/dsk/ c41t0d1 | grep 'PV Name', 找到主备路径
    excuteCheckPvCmds(context, cmdInfoPvIdLst, cmdInfoPvDescLst)
    
    #如果 命令 ioscan -funC fc,ioscan -funC disk ,pvdisplay /dev/dsk/xxx 回显无效则直接不通过
    result = handleCmdException()
    
    if result:
        putResult(context, result)
        putMultipathInfo()
        return contextDisplay
    
    #如果无Claimed 且回显正常，则直接通过
    if isFunCdiskRetNormal(CLI) and (not checkClaimed()):
        LOG.info('ioscan funC disk has no Claimed.')
        evalMessage = ""
        result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.PASSED, evalMessage, ''.join(executeCommandRetLst), [])
        putResult(context, result)
        putMultipathInfo()
        return contextDisplay
    
    #无华为磁盘，且回显要正常 ，则直接通过
    if isFunCdiskRetNormal(CLI) and (not hasHuaweiDisk(hwPathDiskPathObjLst)):
        LOG.info("ioscan funC disk Ret has no huawei disk.")
        evalMessage = ""
        result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.PASSED, evalMessage, ''.join(executeCommandRetLst), [])
        putResult(context, result)
        putMultipathInfo()
        return contextDisplay
    
    #构造wwpn查询命令
    createWwpnCmds()

    LOG.info('multipathExecuteHpV1V2 pathFcxLst len = ' + str(len(pathFcxLst)))
    LOG.info('multipathExecuteHpV1V2 hwPathDiskPathObjLst len = ' + str(len(hwPathDiskPathObjLst)))
    
    if not pathFcxLst:
        LOG.info('pathFcxLst len = 0')
        result = createCmdFailedResult("ioscan -funC fc")
        
        putResult(context, result)
        putMultipathInfo()
        return contextDisplay
    
    elif not hwPathDiskPathObjLst:
        LOG.info('hwPathDiskPathObjLst len = 0')
        result = createCmdFailedResult("ioscan -funC disk")
        
        putResult(context, result)
        putMultipathInfo()
        return contextDisplay
    else:
        evalPv(context)
        putMultipathInfo()
        return contextDisplay

def isFunCdiskRetNormal(CLI):
    '''
    @summary: 检查ioscan－funC disk 回显是否正常。正常返回 True，否则返回False
            回显中至少有一行是disk开头则正常
            本来ioscan -funC disk的回显，在某个地方会执行，但是有可能遇到异常、或者可能会提前退出检查。所以此处再执行一次
    '''
    cmdRet = ""
    
    try:
        cmdRet = CLI.execCmdHasLogTimout(PATH_DISK_CMD, 60*20)
    except:
        LOG.info('ioscan -funC disk exe error.')
    
    isNomal = not isFcDiskRetError(cmdRet)
    return isNomal 


def isFunCFcRetNormal(CLI):
    '''
    @summary: 检查ioscan -funC fc 回显是否正常。正常返回 True，否则返回False
          本来ioscan -funC fc 的回显，在某个地方会执行，但是有可能遇到异常、或者可能会提前退出检查。所以此处再执行一次
    '''
    cmdRet = ""
    
    try:
        cmdRet = CLI.execCmdHasLogTimout(HW_PATH_CMD, 60*20)
    except:
        LOG.info('ioscan -funC disk exe error.')
        
    lst = cmdRet.splitlines()
    if not cmdRet.strip():
        return False
    
    for line in lst:
        if line.strip().lower().startswith('fc'):
            return True
    return False


def handleCmdException():
    ''''
    @summary: 命令异常，则统一处理(命令未空，则认为 异常)；
            提示：问题原因：执行命令""{0}""，｛1｝。
    ioscan -funC disk = 未查询到磁盘 
    ioscan -funC fc = 未查询到HBA信息 "
    '''
    result = None
    
    # ioscan -funC disk 失败
    if not isFunCdiskRetNormal(CLI):
        result = createCmdFailedResult("ioscan -funC disk")
        return result
    # ioscan -funC fc 失败
    if not isFunCFcRetNormal(CLI):
        result = createCmdFailedResult("ioscan -funC fc")
        return result
    
    #pvdisplay /dev/dsk/c22t0d3 | grep 'PV Name'
    if pvDisplayDevLst:
        LOG.info('pvdisplay /dev/xxx ret has empty.')
        evalMessage = CONSTANT.EVAL_FAILED_PV
        paramList = [','.join(pvDisplayDevLst), "messageKey:" + CONSTANT.EVAL_FAILED_PV_REASON]
        
        result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage, ''.join(executeCommandRetLst), paramList)
        return result
    else:
        LOG.info('pvdisplay lst is empty.')
    return result

def createCmdFailedResult(cmd):
    result = None
    paramList = []
    evalMessage = ''
    
    #ioscan -funC disk
    if PATH_DISK_CMD == cmd:
        evalMessage = CONSTANT.EVAL_FAILED_FCDISK
        paramList = [PATH_DISK_CMD,"messageKey:" + CONSTANT.EVAL_FAILED_FCDISK_REASON]
        result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage, ''.join(executeCommandRetLst), paramList)
        LOG.info('ioscan -funC disk cmdRet is empty.')
        return result
    
    #ioscan -funC fc
    if HW_PATH_CMD == cmd:
        evalMessage = CONSTANT.EVAL_FAILED_FCNOT
        paramList = [HW_PATH_CMD,"messageKey:" + CONSTANT.EVAL_FAILED_FCNOT_REASON]
        result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage, ''.join(executeCommandRetLst), paramList)
        LOG.info('ioscan -funC fc ret　is empty.')
        return result
        
def putMultipathInfo():
    #2.写多路径状态信息写入txt: cmd_display_hpux_mulitipath_status_result_str
    resultStr2 = CONSTANT.RESULT_FLAG + str(makeMultipathInfo())
    contextDisplay.put(COMMAND_STATUS_DESC, resultStr2)


def getGroupPvEvalResult(pvDict):
    '''
    @summary: 根据一组pv的状态去判断评估是否通过 
           如果正常状态 <=1 且其他状态 <1，则评估失败；
           如果正常状态 > 1 则调用奇偶平面 是否冗余评估逻辑；
          如果正常状态 < =1 且其他状态 >=1 则无法评估；
    pvDict = {'evalResult': '评估结果，此时 可能为：PV_CANOT_EVAL', 
    'bakPvState': [备路径状态1、备路径状态2.。。],
    'mainPvState':'主路径状态'
    
    }
    '''
    pvStates = []
    try:
        pvStates = pvDict[BAK_PV_STATE]
        pvStates.append(pvDict[DISK_PATH_STATE])
    except:
        LOG.error('eval Pv bakPvState is not pvDic key')

    okStateNum = 0  #CLAIMED
    noHwStateNum = 0 #NO_HW
    otherStateNum = 0 #其他状态
    
    if not pvStates:
        return PV_CANOT_EVAL
    
    for state in pvStates:
        if CLAIMED == state:
            okStateNum = okStateNum + 1
            continue
        elif NO_HW == state:
            noHwStateNum = noHwStateNum + 1
            continue
        else:
            otherStateNum = otherStateNum + 1
    #如果只有一条命令，则为不通过
    if (NOT_PASS == pvDict[DISK_EVAL_RESULT]):
        return NOT_PASS
    
    if (pvDict[DISK_EVAL_RESULT] == PV_CANOT_EVAL):
        return PV_CANOT_EVAL
    
    #根据状态判断是否通过
    if okStateNum <= 1 and otherStateNum < 1:
        return NOT_PASS
    if okStateNum > 1:
        return ''
    if okStateNum <= 1 and otherStateNum >= 1:
        return PVSTATE_NOTEVAL

    
def evalPv(context):
    '''
    @summary: 单个disk评估结果有三种，按优先级排序：不通过、pv无法评估、通过
    @param context: 上下文 
    '''
    paramList = []
    evalResultDiskLst = []
    LOG.info('evalPv start redundancyPvLst = ' + str(redundancyPvLst))
    for pvDic in redundancyPvLst:
        #某段冗余路径首先判断状态，只有正常状态的路径数至少大于2的时候才去调用 奇偶平面 冗余路径判断逻辑
        pvResult = getGroupPvEvalResult(pvDic)
        mainPvLun = pvDic[MAIN_PV]
        
        if pvResult != '':
            if pvResult == NOT_PASS:
                evalResultDiskLst.append(pvResult)
                paramList.append(mainPvLun)
            else:
                evalResultDiskLst.append(pvResult)
        else:
            cmdIdLst = pvDic[CMD_IDS]
            cmdDescLst = pvDic[CMD_DESC]
            
            diskIsPass = False
            diskIsPass = excuteCmds(context, cmdIdLst, cmdDescLst, checkWwpns)
            if diskIsPass and pvDic[DISK_PATH_STATE] != NOT_PASS:
                evalResultDiskLst.append(PASS)
            else:
                evalResultDiskLst.append(NOT_PASS)
                paramList.append(mainPvLun)
            LOG.info('diskIsPass = ', str(diskIsPass))
            
    #评估结果：不通过>无法评估>通过
    LOG.info('evalPv evalResultDiskLst = ')
    LOG.info(str(evalResultDiskLst))
    if NOT_PASS in evalResultDiskLst:
        #评估不通过
        LOG.info('evalPv redundancy eval not pass.')
        evalMessage = CONSTANT.EVAL_RETOK_NOTPASS
        paramList = [str(IP), ','.join(paramList)]
        result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage, ''.join(executeCommandRetLst), paramList)

        putResult(context, result)
        return
    elif PV_CANOT_EVAL in evalResultDiskLst:
        #优化：pvdisplay /dev/dsk/xxx 命令无有效回显则，评估不通过
        paramList = []
        LOG.info('pvdisplay /dev/xxx ret has empty.')
        evalMessage = CONSTANT.EVAL_FAILED_PV
        paramList = [','.join(pvDisplayDevLst), "messageKey:" + CONSTANT.EVAL_FAILED_PV_REASON]
        result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage, ''.join(executeCommandRetLst), paramList)
        putResult(context, result)
        return
    elif PVSTATE_NOTEVAL in evalResultDiskLst:
        #优化：ioscan -funC disk 无法评估改为评估：不通过
        result = createCmdFailedResult("ioscan -funC disk")
        putResult(context, result)
        return

    elif PASS in evalResultDiskLst:
        LOG.info('evalPv redundancy eval pass')
        #通过
        evalMessage = ""
        result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.PASSED, evalMessage, ''.join(executeCommandRetLst), [])
        putResult(context, result)




def putResult(context, result):
    '''
    @summary: 将结果放入上下文
    @param contex:上下文
    @param result: 评估结果对象 
    '''
    context.get("ret_map").put(DISK_EVAL_RESULT, result)
    resultStr = result.getEvalResultJsonString()
    context.get("ret_map").put(COMMAND_CHECK_DESC, resultStr)

def excuteCmds(context, cmdInfoIds, cmdInfoDesc, businessFuction):
    '''
    @summary: 执行若干命令，并保存每个命令的回文
    '''
    funErrMsg = ''

    CLI = context.get("SSH")
    LANGUAGE = context.get("lang")
    cmdDisplay = context.get("ret_map")

    #与业务相关的回文保存下来，业务处理需要使用
    businessRetLst = []
    totalCmd = 1 if len(cmdInfoIds) == 0 else len(cmdInfoIds)
    prgStep = constants.PROG10 / totalCmd
    curstep = constants.PROG5
    util.updateItemProgress(context, curstep)
    for rg in range(len(cmdInfoIds)):
        cmdDisplayTemp = CLI.execCmdHasLogTimout(cmdInfoDesc[rg], 60*20)
        curstep += prgStep
        util.updateItemProgress(context, curstep)
        #把回文保存下来，需要写到txt 中 
        executeCommandRetLst.append(cmdDisplayTemp)

        cmdTemp = "cmd_display" + (cmdInfoIds[rg])[8:] + '\n' + cmdDisplayTemp

        businessRetLst.append(cmdTemp)

        cmdDisplay.put("cmd_display" + (cmdInfoIds[rg])[8:], cmdDisplayTemp)

        if None == cmdDisplayTemp or '' == cmdDisplayTemp or cmdDisplayTemp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmdDisplayTemp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en" == LANGUAGE:
                funErrMsg += cmdInfoDesc[rg] + ":\texecute failed\r\n"
            else:
                funErrMsg += cmdInfoDesc[rg] + u":\t执行失败\r\n"
        else:
            if "en" == LANGUAGE:
                funErrMsg += cmdInfoDesc[rg] + ":\texecute success\r\n"
            else:
                funErrMsg += cmdInfoDesc[rg] + u":\t执行成功\r\n"
    cmdDisplay.put("err_msg", buildNewErrMsg(context,funErrMsg))

    if None == businessFuction:
        LOG.info('bussin functon = none')
        return
    elif 'checkWwpns' == businessFuction.__name__:
        checkResult = checkWwpns(context, businessRetLst)
        return checkResult
    else:
        businessFuction(context, businessRetLst)



def checkWwpns(context, retLst):
    '''
    @summary: 检查一对主备路径是否通过
    @param context: 上下文
    @param retLst: 业务回文 
    '''
    wwpnLst = []

    resultDict = {}
    flag = False
    LOG.info('checkWwpns retLst ')

    for ret in retLst:
        for line in ret.splitlines():
            if '=' in line:
                wwpn = line.split('=')[-1].strip()
                wwpnLst.append(wwpn)

    if wwpnLst:
        for item in wwpnLst:
            LOG.info("***[strWwpn=  + " + item + "]")
            getDictFromWwpn(context, item, resultDict)

        LOG.info('begin verifyDeivce...')
        flag = verifyDeivce(resultDict)

    return flag


def createWwpnCmds():
    '''
    @构造查询wwpn的命令，这里将一对主备路径分组，与之相关的命令放在全局变量redundancyPvLst中
    '''
    #步骤六:使用第二步查询出的对应的fcdX信息及FCID查询wwpn
    if 0 == len(redundancyPvLst):
        LOG.info('redundancy Pv is Empty.')
        return

    LOG.info('createWwpnCmds start redundancyPvLst = ' + str(redundancyPvLst))

    for pvDict in redundancyPvLst:
        backPvLst = []
        
        cmdWwpnIds = []
        cmdWwpnDescs = []
        mainPv = ''
        if MAIN_PV in pvDict.keys():
            mainPv = pvDict.get(MAIN_PV)
        hwState = getHwPathState(mainPv, hwPathDiskPathObjLst)
        
        #主路径状态或者评估结果
        pvDict[DISK_PATH_STATE] = hwState
        for pathFcx in pathFcxLst:
            if '' == mainPv:
                continue
            fcID , hwTag = getFcIdHwTag(mainPv, hwPathDiskPathObjLst)
            #求fcdX
            fcdX = ''
            if hwTag.strip().startswith(pathFcx.getHwPath().strip()):
                fcdX = pathFcx.getFcx()
                #将mainPv拼接到命令描述中，评估失败的时候需要
                if fcdX and fcID:
                    cmdWwpnIds.append('cmd_info_' + MAIN_PATH_DESC + '_' + fcID + fcdX + '_' + mainPv)
                    cmdWwpnDescs.append('fcmsutil ' + fcdX + ' get remote ' + fcID + ' | grep ' + "'Target Port World Wide Name'")
        #拼备路径命令
        for pvItem in pvDict:
            if pvItem.startswith(BACK_PV):
                backPvLst.append(pvDict[pvItem])

        LOG.info('backPvLst = ' + str(backPvLst))
        bakStateLst = []
        for bakPv in backPvLst:
            bakHwState = getHwPathState(bakPv, hwPathDiskPathObjLst)
            bakStateLst.append(bakHwState)
            
            for pathFcx in pathFcxLst:
                fcIDb = ''
                fcIDb, hwTagb = getFcIdHwTag(bakPv, hwPathDiskPathObjLst)
                #只有状态正常才把备路径命令放在列表中
                if CLAIMED == bakHwState: 
                    #求fcdX
                    fcdXb = ''
                    if hwTagb.strip().startswith(pathFcx.getHwPath().strip()):
                        fcdXb = pathFcx.getFcx()
                    if fcIDb and fcdXb:
                        cmdWwpnIds.append('cmd_info_' + BACK_PATH_DESC + '_' + fcIDb + fcdXb + '_' + bakPv)
                        cmdWwpnDescs.append('fcmsutil ' + fcdXb + ' get remote ' + fcIDb + ' | grep ' + "'Target Port World Wide Name'")
        
        pvDict[BAK_PV_STATE] = bakStateLst
        pvDict[CMD_IDS] = cmdWwpnIds
        pvDict[CMD_DESC] = cmdWwpnDescs
    LOG.info('createWwpnCmds end redundancyPvLst = ' + str(redundancyPvLst))


def getFcIdHwTag(Pv, hwPathDiskPathObjs):
     #求FCID
    fcID = ''
    hwTag = ''
    for hwPathDisk in hwPathDiskPathObjs:
        if isValueEquealLstOne(Pv, hwPathDisk.getDiskLst()):
            fcID = hwPathDisk.getFcId()
            hwTag = hwPathDisk.getHwPathTag()
            break

    return fcID, hwTag


def getHwPathState(Pv, hwPathDiskPathObjs):
    pathState = ''
    for hwPathDisk in hwPathDiskPathObjs:
        if isValueEquealLstOne(Pv, hwPathDisk.getDiskLst()):
            pathState = hwPathDisk.getPathState()
            break
    return pathState

def isValueEquealLstOne(value, lst):
    if value == None:
        return False

    for v in lst:
        if value == v:
            return True
    return False


def createMultiCmds(cli):
    '''
    @summary: 需要将采集到的原始信息保存到txt或者html中，此处构造需要执行的命令
    ioscan -funC fc
    ioscan -funC disk 
    pvdisplay /dev/dsk/xxx | grep 'PV Name'
    '''

    #步骤二：执行命令ioscan -funC fc 获取当前HP-UX的HBA卡的H/W Path列表
    pathResult = cli.execCmdHasLogTimout(HW_PATH_CMD, 60*20)
    pathResultLst = []

    cmdInfoId.append("cmd_info_multipath_ioscan_fc")
    cmdInfoDesc.append(HW_PATH_CMD)

    if pathResult:
        pathResultLst = pathResult.splitlines()

    #构造 hwPath 与fcx映射列表，ioscan -funC fc
    pathFcxLst = getPathFcxLst(pathResultLst)

    #步骤三：执行命令ioscan -funC disk 获取当前映射的disk device列表，根据H/W Path进行匹配
    
    
    lst = getPathDiskMatchLst(pathFcxLst, cli, PATH_DISK_CMD)
    
    for hw in lst:
        hwPathDiskPathObjLst.append(hw)


    #查询主备 路径的命令
    for hwPathDisk in hwPathDiskPathObjLst:
        for disk in hwPathDisk.getDiskLst():
            cmdInfoPvIdLst.append('cmd_info_pvdisplay_' + disk)
            cmdInfoPvDescLst.append(PV_DISK_CMD + disk + " | grep 'PV Name'")



def excuteCheckPvCmds(context, cmdInfoIdLstParm, cmdInfoDescLstParm):
    '''
    @summary:某主pv有冗余pv则将其保存到全局变量 redundancyPvLst ，这里将会做一个检查 排除下面回文的情况
    # pvdisplay /dev/dsk/c22t0d3 | grep 'PV Name'
    PV Name                     /dev/dsk/c45t0d3
    PV Name                     /dev/dsk/c22t0d3    Alternate Link

    # pvdisplay /dev/dsk/c45t0d3 | grep 'PV Name'
    PV Name                     /dev/dsk/c45t0d3
    PV Name                     /dev/dsk/c22t0d3    Alternate Link    
    '''
    funErrEsg = ''
    CLI = context.get("SSH")
    LANGUAGE = context.get("lang")
    cmdDisplay = context.get("ret_map")
    #去重
    cmdInfoIdLst = sorted(set(cmdInfoIdLstParm), key = cmdInfoIdLstParm.index)
    cmdInfoDescLst = sorted(set(cmdInfoDescLstParm), key = cmdInfoDescLstParm.index)
    LOG.info('excuteCheckPvCmds cmdInfoIdLstParm = ' + str(cmdInfoIdLstParm))
    totalCmd = 1 if len(cmdInfoIdLst) == 0 else len(cmdInfoIdLst)
    prgStep = constants.PROG35 / totalCmd
    for rg in range(len(cmdInfoIdLst)):
        cmdDisplayTemp = CLI.execCmdHasLogTimout(cmdInfoDescLst[rg], 60*20)
        util.addItemProgress(context, prgStep)
        #如果pvdisplay /dev/xxx 回显异常，则要提示相关信息
        #为空、None、pvdisplay /dev/dsk/c45t0d3 | grep 'PV Name'只有一条命令，则为异常 情况
        if isPvdisplayError(cmdDisplayTemp):
            pvDisplayDevLst.append(cmdInfoDescLst[rg])

        tempResult = "cmd_display" + (cmdInfoIdLst[rg])[8:] + '\n' + cmdDisplayTemp
        executeCommandRetLst.append(cmdDisplayTemp)

        #此字典 = {'主路径名','通过回文评估的结果：无法评估/空','评估结果','命令'}
        pvDict = {}
        #单个disk的默认评估结果为 空
        pvDict[DISK_EVAL_RESULT] = ''

        #如果满足冗余pv标识则保存至redundancyPvLst = []
        #main pv

        mainPvFlag = ''

        lst = cmdInfoDescLst[rg].split()
        if len(lst) > 1:
            mainPvFlag = lst[1].strip()
        else:
            LOG.info('pv cmd not found.')
            continue

        if 'alternate link' in tempResult.lower():
            handleBakDiskPath(tempResult, pvDict, mainPvFlag)

        elif (CAN_NOT_VOL.lower() in tempResult.lower()) or (CAN_NOT_DISPHY.lower() in tempResult.lower()):
            #Couldn't find the volume group to which或包含Cannot display physical volume单个disk 无法评估
            LOG.info("Couldn't find the volume group to which，eval pass")
            pvDict[DISK_EVAL_RESULT] = PV_CANOT_EVAL
            pvDict[MAIN_PV] = mainPvFlag

            redundancyPvLst.append(pvDict)
        elif isJustOneDisk(cmdDisplayTemp):
            pvDict[DISK_EVAL_RESULT] = NOT_PASS
            pvDict[MAIN_PV] = mainPvFlag
            redundancyPvLst.append(pvDict)
        else:
            pvDict[DISK_EVAL_RESULT] = PV_CANOT_EVAL
            pvDict[MAIN_PV] = mainPvFlag
            redundancyPvLst.append(pvDict)

        cmdDisplay.put("cmd_display" + (cmdInfoIdLst[rg])[8:], cmdDisplayTemp)
        if None == cmdDisplayTemp or '' == cmdDisplayTemp or cmdDisplayTemp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmdDisplayTemp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en" == LANGUAGE:
                funErrEsg += cmdInfoDescLst[rg] + ":\texecute failed\r\n"
            else:
                funErrEsg += cmdInfoDescLst[rg] + u":\t执行失败\r\n"
        else:
            if "en" == LANGUAGE:
                funErrEsg += cmdInfoDescLst[rg] + ":\texecute success\r\n"
            else:
                funErrEsg += cmdInfoDescLst[rg] + u":\t执行成功\r\n"
    LOG.info('excuteCheckPvCmds redundancyPvLst = ' + str(redundancyPvLst))
    cmdDisplay.put("err_msg", buildNewErrMsg(context,funErrEsg))
    
    
def buildNewErrMsg(context,errMsgParm):
    try:
        errMsgOld = context.get("ret_map").get('err_msg')
        if errMsgOld:
            return errMsgOld + errMsgParm
        return errMsgParm
    except:
        LOG.error('has no err_msg')
        return errMsgParm
    
    
def isPvdisplayError(cmdRet):
    '''
    @summary: 检查pvdisplay /dev/dsk/xxx | grep 'PV Name' 回显是否异常；异常：return True，正常：return False
            回显为：None、空、回显除了命令外没有其他值 ，三种情况则为异常
    '''
    if not cmdRet:
        return True
    if not cmdRet.strip():
        return True
    if cmdRet.count('PV Name') <= 1:
        return True
    
    return False
        
    

def isJustOneDisk(diskTemp):
    '''
    @summary: 判断某链路是否只有一条路径，如：
    @param diskTemp: pvdisplay xxx回文 
    #pvdisplay /dev/dsk/c7t0d3 | grep 'PV Name'
    PV Name                     /dev/dsk/c7t0d3
          此情况为不通过
    '''
    
    pvNum = 0
    diskLines = diskTemp.splitlines()
    for line in diskLines:
        if line.strip().startswith('PV Name'):
            pvNum = pvNum + 1
    if 1 == pvNum:
        return True
    return False
            


def handleBakDiskPath(tempResultParm, pvDict, mainPvFlag):
    #如果有冗余路径则表示 自带多路径可用
    multiInfo["SelfMultiPath"] = "enabled"

    pvLines = tempResultParm.splitlines()
    #是否是主路径回文
    #通过回文查出来的主路径
    mainPv = ''
    for pvLine in pvLines:
        if (pvLine and pvLine.strip().startswith('PV Name')):
            lst = pvLine.split()
            if('alternate link' not in pvLine.lower()) and len(lst) > 2:
                mainPv = lst[2]
                LOG.info('mainPv select = ' + mainPv)
                break
    LOG.info('handleBakDiskPath mainPvFlag mainPv = ' + mainPvFlag + ' ,' + mainPv)
    if(mainPv and mainPvFlag == mainPv):
        LOG.info('mainPvFlag == mainPv')
        i = 0
        for line in pvLines:
            if (line and line.strip().startswith('PV Name')):
                lst = line.split()
                if('alternate link' in line.lower()):
                    pvDict[BACK_PV + str(i)] = lst[2]
                    i = i + 1
                else:
                    LOG.info('mainPvFlag == mainPv MAINPV =' + lst[2])
                    pvDict[MAIN_PV] = lst[2]
        LOG.info('pvDict = ' + str(pvDict))
        redundancyPvLst.append(pvDict)
    else:
        #此情况不是查询的主路径的回文，过滤掉
        LOG.info(mainPvFlag + ' is not main disk')

def isDickeyInLst(lst, dic):
    '''
    @summary:判断list中有没有与传入的字典key相同的元素，有则为True
    @param dic: 传入的字典
    @param lst:lst 
    '''
    if dic.keys() == []:
        return False
    for d in lst:
        if dic.keys()[0] == d.keys()[0]:
            return True
    return False


def getPathFcxLst(lst):
    '''
    @summary:获取hw/path 和 /dev/fcdX的对应关系
    @param lst: ioscan -funC fc 回文 
    '''
    if not checkFcxLines(lst):
        LOG.info('getPathFcxLst ioscan -funC fc lines is empty.')
        return []
    for idx, line in enumerate(lst):
        if line.lower().strip().startswith('fc'):
            hwPathFcxObj = HwPathFcxEntity()
            pathLst = line.split()
            if len(pathLst) > 2:
                path = pathLst[2]
                hwPathFcxObj.setHwPath(path)
            else:
                LOG.info("hw/path not found.")

            fcxResult = lst[idx + 1].strip()

            hwPathFcxObj.setFcx(fcxResult)
            pathFcxLst.append(hwPathFcxObj)
    
    return pathFcxLst


def checkFcxLines(lst):
    '''
    @summary: 检查ioscan -funC fc命令回文是否正常，如果不正常则返回False
            如果找到某行以fc开头 且空格分隔长度大于等于2，他的下一行同样符合这种规律则认为回文异常或者：物理链路状态不正常
    @param lst: 回文表 
            正常回显：
    # ioscan -funC fc
    Class     I  H/W Path        Driver   S/W State   H/W Type     Description
    ===========================================================================
    fc        0  1/0/8/1/0/4/0   fcd      CLAIMED     INTERFACE    HP AD193-60001 PCI/PCI-X Fibre Channel 1-port 4Gb FC/1-port 1000B-T Combo Adapter (FC Port 1)
                            /dev/fcd0
    fc        1  1/0/10/1/0/4/0  fcd      CLAIMED     INTERFACE    HP AD193-60001 PCI/PCI-X Fibre Channel 1-port 4Gb FC/1-port 1000B-T Combo Adapter (FC Port 1)
                            /dev/fcd1
    '''
    if not lst:
        return False

    result = True
    devIdx = 0
    for s in lst:
        if s.strip() == '':
            lst.remove(s)

    for idx, line in enumerate(lst):
        temp = line.strip().lower()
        if temp.startswith('fc'):
            devIdx = idx + 1
            if (devIdx != 0) and (devIdx < len(lst)):
                devTemp = lst[devIdx]

                if devTemp.strip().lower().startswith('fc'):
                    result = result & False
                else:
                    result = result & True

    return result

def getPathDiskMatchLst(pthFcxLstParm,cli,cmdParm):
    '''
    @summary: hw/path 与disk 映射关系。执行命令ioscan -funC disk获取当前映射的disk device列表，根据H/W Path进行匹配
    @param pthFcxLstParm:  ioscan -funC fc 回文对象列表
    @param cmdParm: ioscan -funC disk 
    '''
    pthFcidDiskLines = []
    hwPathDiskPathObjs = []

    try:
        diskCliRet = cli.execCmdHasLogTimout(cmdParm, 60*10)        
        #ioscan -funC disk 检查回显
        if isFcDiskRetError(diskCliRet):
            return []
        
        executeCommandRetLst.append(diskCliRet)
        
        pthFcidDiskLines = diskCliRet.splitlines()
    except:
        LOG.error("get path fc lst error,cmd:" + cmdParm)
        return []

    noDisk = False
    for line in pthFcidDiskLines:
        if line.strip().lower().startswith('disk'):
            noDisk = True
            break
    if not noDisk:
        return []
    # 值是对的
    for pthFcx in pthFcxLstParm:
        for idx, hwPathFcxLine in  enumerate(pthFcidDiskLines):
            items = hwPathFcxLine.split()
            if len(items) > 2:
                if items[2].startswith(pthFcx.getHwPath()):
                    hwPathDiskPathObj = HwPathDiskPathEntity()
                    
                    if checkHuaweiDisk(hwPathFcxLine):
                        hwPathDiskPathObj.setHuaweiFlag(True)
                        
                    hwPathDiskPathObj.setHwPathTag(items[2])
                    #步骤五.提取到的HBA端口的所对应的FCID
                    fcid = getFcIdByHwPath(items[2], pthFcx.getHwPath())

                    hwPathDiskPathObj.setFcId(fcid)
                    #当前HW/Path的disk
                    diskLst = []
                    diskLines = pthFcidDiskLines[idx + 1:]
                    diskIdx = 0
                    while len(diskLines) > diskIdx and diskLines[diskIdx].strip().startswith('/'):
                        for disktemp in diskLines[diskIdx].split():
                            if '/rdsk/' not in disktemp:
                                diskLst.append(disktemp)
                        diskIdx = diskIdx + 1
                    hwPathDiskPathObj.setDiskLst(diskLst)
                    if (hwPathDiskPathObj.getFcId() != 'NA'):
                        hwPathDiskPathObjs.append(hwPathDiskPathObj)
                    if (len(items) > 4):
                        hwPathDiskPathObj.setPathState(items[4])
                    else:
                        hwPathDiskPathObj.setPathState('other')

                else:
                    continue
            else:
                continue
    
    return hwPathDiskPathObjs

def checkHuaweiDisk(diskLineRet):
    '''
    @summary: ioscan -funC disk 回显行中是华为盘
            如果回显中有：huawei|huasy|symantec|hs|eisoo|udsafe|marstor|sanm|anystor|sugon|netposa，之一则为华为磁盘
    return True:是华为磁盘 ； False：不是华为磁盘
    '''
    huaweiDiskTag = 'huawei|huasy|symantec|hs|eisoo|udsafe|marstor|sanm|anystor|sugon|netposa'
    lst = huaweiDiskTag.split('|')
    for tag in lst:
        if tag in diskLineRet.lower():
            return True
    return False 
    

def checkClaimed():    
    '''
    @summary:ioscan -funC disk 回显有则为True,否则为False
    '''
    fcDiskRet = ""
    try:
        fcDiskRet = CLI.execCmdHasLogTimout(PATH_DISK_CMD,60*20)
    except:
        LOG.info('execute ioscan -funC disk failed.')
    #回显为空
    if (not fcDiskRet) or (not fcDiskRet.strip()):
        return False 
    
    fcDiskLines = fcDiskRet.splitlines()
    #无CLAIMED 或者命令异常（异常则肯定无CLAIMED状态）
    for line in fcDiskLines:
        if (line.strip().lower().startswith('disk')) and ('claimed' in line.lower()):
            LOG.info('ioscan -funC disk has at least one claimed.')
            return True
    return False


def hasHuaweiDisk(lst):
    '''
    @summary: 是否有华为磁盘 ，为True则有华为磁盘，为False则无华为磁盘
    '''
    for disk in lst:
        if disk.isHuaweiDisk():
            return True
    return False
        

def isFcDiskRetError(cmdRet):
    '''
    @summary: 检查ioscan -funC disk回显
            如果回显为空，或者回显中没有一行是disk开头，则回显为异常
    @return: True:回显为异常 ，False：回显正常
    '''
    result = True
    if not cmdRet:
        return result
    if not cmdRet.strip():
        return result
    
    lst = cmdRet.splitlines()
    for line in lst:
        if line.strip().startswith('disk'):
            result = False
            LOG.info('ioscan funC disk Ret not Error.')
            break
    return result
    

def getFcIdByHwPath(value, path):
    '''
    @summary: 根据hw/path求FCID，1/0/10/1/0/4/0.116.9.0.0.0.1  =>FCID = 0x740900
    @param value: 匹配的hw/path 行的值
    @param path:hw/path 
    '''
    LOG.info('getFcIdByHwPath value = ', value , ' path = ', path)

    fcid = ''
    try:
        value = value.replace(path, '') #.116.9.0.0.0.1
        values = value.split('.')
        if len(values) > 3:
            values = values[1:4]

        id1 = str(hex(int(values[0]))).replace('0x', '')
        id2 = str(hex(int(values[1]))).replace('0x', '')
        id3 = str(hex(int(values[2]))).replace('0x', '')

        if int(values[0]) < 16:
            id1 = '0' + id1

        if int(values[1]) < 16:
            id2 = '0' + id2

        if int(values[2]) < 16:
            id3 = '0' + id3
        fcid = '0x' + id1 + id2 + id3

    except:
        LOG.error('getFcIdByHwPath = ' + str(traceback.format_exc()))
    return fcid


def getDictFromWwpn(context, strWwpn, resultDict):
    '''
    @summary:将字符串转换成整数
    @param strWwpn : 字符串wwpn，以0x开头
    @param resultDict: 保存控制引擎及节点映射的数据
    @return: 返回数据字典 
    '''
    if strWwpn.startswith('0x'):
        isSuccess, ctrlEncMac, nodeId = parseWwpn(context, strWwpn)
        if not isSuccess:
            LOG.info("***[Parse WWPN failed]***")
        else:
            if ctrlEncMac in resultDict:
                nodeDict = resultDict[ctrlEncMac]
            else:
                nodeDict = {}
                # 将0、1面均初始化为0,0:奇平面，1：偶平面
                nodeDict['0'] = 0
                nodeDict['1'] = 0
            nodeDict[str(nodeId % 2)] = 1
            resultDict[ctrlEncMac] = nodeDict
    else:
        LOG.info("***[wwpn is not hex]***")



class HwPathFcxEntity:
    hwPath = 'NA'
    fcX = 'NA'
    #get
    def getHwPath(self):
        return self.hwPath
    def getFcx(self):
        return self.fcX

    #set
    def setHwPath(self, path):
        self.hwPath = path
    def setFcx(self, fcx):
        self.fcX = fcx
    
    
class HwPathDiskPathEntity:
    #H/W Path 和 disk FCID对象
    hwPathFcIdTag = 'NA'
    fcId = 'NA'
    pathState = 'NA'
    diskLst = []
    isHuaweiFlag = False
    
    #get
    def getHwPathTag(self):
        return self.hwPathFcIdTag
    def getFcId(self):
        return self.fcId
    def getDiskLst(self):
        return self.diskLst
    def getPathState(self):
        return self.pathState
    def isHuaweiDisk(self):
        return self.isHuaweiFlag
    #set 
    def setHwPathTag(self, path):
        self.hwPathFcIdTag = path
    def setFcId(self, idParm):
        self.fcId = idParm
    def setDiskLst(self, disks):
        self.diskLst = disks
    def setPathState(self, state):
        self.pathState = state
    def setHuaweiFlag(self,flag):
        self.isHuaweiFlag = flag

def makeMultipathInfo():
    '''
    @summary: 构造多路径信息，评估使用
    '''
    dataDict = {}
    versionStr = 'NA'
    if "version" in multiInfo:
        versionStr = str(multiInfo["version"])
    dataDict["HuaweiMultipathVersion"] = versionStr
    dataDict["SelfMultiPath"] = multiInfo["SelfMultiPath"]
    dataStr = str(dataDict)
    return dataStr
