# coding=utf-8
__author__ = '******'
# 获取hpux主机的多路径信息
import os
import sys
path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
path = os.path.join(path, "..\\..")
sys.path.append(path)
from hpux_multipath_info_check import multipathExecute
from hpux_multipath_info_checkv1v2 import multipathExecuteHpV1V2
from hpux_lun_wwn_info import get_result_info
from common import util
from common import constants
CLI = None
LANGUAGE = None
LOG = None

CHECK_FAIL          =       0
CHECK_PASS          =       1
cmd_info_id = ["cmd_info_multipath_status_storage",
               "cmd_info_multipath_status_hba_card" ,
               "cmd_info_multipath_status_fc_link"
               ]
            
cmd_info_desc = ["ioscan -funC disk",
                 "ioscan -fnC fc",
                 "fcmsutil "
                 ]

cmd_info_hba_list              =   "ioscan -funC fc|grep dev|awk '{print $1}'"
multipathCheckErrorMsg = ''
def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    global LANGUAGE
    global LOG
    global multipathCheckErrorMsg
    
    CLI = context.get("SSH")
    LOG = context.get("Logger")
    LANGUAGE = context.get("lang")

    get_result_info(context)
    if isHpV1V2(CLI):
        multipathExecuteHpV1V2(context)
        multipathCheckErrorMsg += getErrMsg(context)
    else:
        multipathExecute(context)
        multipathCheckErrorMsg += getErrMsg(context)
        util.updateItemProgress(context, constants.PROG25)
    
    
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(cmd_display, CLI, LANGUAGE,context))


def getErrMsg(context):
    errMsg = context.get("ret_map").get('err_msg')
    if errMsg:
        return errMsg
    else:
        return ""


def isHpV1V2(cli):
    '''
    @summary: 判断是是否是hp v1 或v2版本
    B.11.11对应HP-UX 11i v1;
    B.11.23对应HP-UX 11i v2;
           回文：
    # uname -a
    HP-UX HPV2 B.11.23 U ia64 1918308022 unlimited-user license
    @param cli: ssh连接对象 
    @return True:是v1 v2 ，False:不是v1/v2
    '''
    unameLineLst = cli.execCmdNoLogTimout("uname -a",60).splitlines()
    
    if not unameLineLst:
        return False
    
    osLine = unameLineLst[-1].lower()
    if ('B.11.11'.lower() in osLine):
        LOG.info('B.11.11 -> v1')
        return True
    if ('B.11.23'.lower() in osLine):
        LOG.info('B.11.23 -> v2')
        return True
    
    return False



# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(cmd_display, CLI, LANGUAGE,context):
    fun_flag = CHECK_FAIL
    fun_err_msg = ''

    hba_list = CLI.execCmdHasLog(cmd_info_hba_list).splitlines()
    for rg in range(len(cmd_info_id)):
        if  cmd_info_id[rg]=="cmd_info_multipath_status_fc_link":
            cmd_display_temp = ''
            fun_err_msg_status = ''

            if len(hba_list[1:])>0:
                prgStep = constants.PROG35 / len(hba_list[1:])
                for idx,hba in enumerate(hba_list[1:]):
                    cmd_display_temp = ''
                    hba = hba.strip()
                    cmd_display_temp = cmd_display_temp + CLI.execCmdHasLogTimout(cmd_info_desc[rg] + hba,60)
                    util.addItemProgress(context, prgStep)
                    cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:]+'dev'+str(idx), cmd_display_temp)
                    
                    if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                        if "en"==LANGUAGE:
                            fun_err_msg_status        +=cmd_info_desc[rg] + hba + ":\texecute failed\r\n"
                        else:
                            fun_err_msg_status        +=cmd_info_desc[rg]  + hba+ u":\t执行失败\r\n"
                    else:
                        if "en"==LANGUAGE:
                            fun_err_msg_status        +=cmd_info_desc[rg]  + hba+ ":\texecute success\r\n"
                        else:
                            fun_err_msg_status        +=cmd_info_desc[rg] + hba + u":\t执行成功\r\n"
            else:
                util.addItemProgress(context, constants.PROG20)
                break
        else:
            cmd_display_temp = CLI.execCmdHasLogTimout(cmd_info_desc[rg],60)
            util.addItemProgress(context, constants.PROG5)
            cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
            if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
            else:
                if "en"==LANGUAGE:
                    fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
                else:
                    fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    global multipathCheckErrorMsg
    fun_err_msg = multipathCheckErrorMsg + fun_err_msg + fun_err_msg_status
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    util.updateItemProgress(context, constants.PROG90)
    return fun_flag, cmd_display, fun_err_msg