# coding=utf-8
__author__ = '******'
# 获取linux主机的一些基础信息:名称、版本、CPU、内存等.
import os
import re
import sys
path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..")
sys.path.append(path)
from common.contentParse import getCommandRet
from common import constants
from common import util

cmd_info_id = ["cmd_info_machinfo",
               "cmd_info_uname"   ,
               "cmd_info_date"    ,
               "cmd_info_ips"     ,
               "cmd_info_kernel_bit",
               "cmd_info_os_hosts",
               ]
            
cmd_info_desc = ["machinfo",
                 "uname -a",
                 "date",
                 "netstat -in",
                 "getconf KERNEL_BITS",
                 "cat /etc/hosts",
                 ]

def getCommandRet(context, cmd_info_id, cmd_info_desc):
    tempStep = constants.PROG90 / len(cmd_info_id)
    curStep = tempStep
    fun_err_msg = ''

    CLI = context.get("SSH")
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    
    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        cmd_display_temp = CLI.execCmdHasLogTimout(cmd_info_desc[rg],60)
        cmd_display_temp = cmd_display_temp.replace('','')
        cmd_display_temp = cmd_display_temp.replace(' _','_')
        cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
                
        if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
        cmd_display.put("err_msg", fun_err_msg)
    return cmd_display


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    
    return getCommandRet(context,cmd_info_id,cmd_info_desc)