# coding=utf-8

# 获取hp-ux主机的虚拟化信息
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common import util
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import HPUX

cmd_info_id = [
    "cmd_info_virtual_hpvmstatus",
    "cmd_info_virtual_ioscan",
    "cmd_info_virtual_parstatus",
    "cmd_info_virtual_ioscan_fnk",
    "cmd_info_virtual_vparstatus",
    "cmd_info_virtual_vparstatus_v",
    "cmd_info_virtual_vparstatus_p",
    "cmd_info_virtual_swlist_par",
    "cmd_info_virtual_swlist_ignite",
    "cmd_info_virtual_vparstatus_m",
    "cmd_info_virtual_parstatus_v_p",
    "cmd_info_virtual_setboot_v",
    "cmd_info_logic_volum_vgdisplay",
    "cmd_info_disk_mgt_cat_fstab",
    "cmd_info_disk_mgt_mount",
    "cmd_info_disk_mgt_mount_v"
]

cmd_info_desc = [
    "hpvmstatus",
    "ioscan",
    "parstatus",
    "ioscan -fnk",
    "vparstatus",
    "vparstatus -v",
    "vparstatus -p ",
    "swlist |grep -i par",
    "swlist -l bundle |grep Ignite",
    "vparstatus -m",
    "parstatus -V -p 0",
    "setboot -v",
    "vgdisplay -v",  # 9月19日 从hpux_logic_volume_info移入
    "cat /etc/fstab",  # 9月19日从hpux_disk_mgt_info移入
    "mount",  # 9月19日从hpux_disk_mgt_info移入
    "mount -v"  # 9月19日从hpux_disk_mgt_info移入
]

cmd_info_vpar_list = "vparstatus -v|grep Name|awk '{print $2}'"


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    cli = context.get("SSH")
    language = context.get("lang")
    cmd_display = context.get("ret_map")
    return cmd_execute(context, cmd_display, cli, language)


def cmd_execute(context, cmd_display, cli, language):
    temp_step = constants.PROG90 / len(cmd_info_id)
    cur_step = temp_step
    fun_err_msg = ''
    vpar_list = (cli.execCmdHasLog(
        get_sudo_cmd(cmd_info_vpar_list, HPUX, context))).splitlines()
    for index, id_tmp in enumerate(cmd_info_id):
        cur_step += temp_step
        util.updateItemProgress(context, cur_step)
        if id_tmp == "cmd_info_virtual_vparstatus_p":
            cmd_pre = get_sudo_cmd(cmd_info_desc[index], HPUX, context)
            for vpar in vpar_list[1:]:
                if vpar.find('vparstatus') >= 0:
                    continue
                cmd_display_temp = cli.execCmdHasLogTimout(cmd_pre + vpar + " -v", 60)
                cmd_display.put("cmd_display" + id_tmp[8:] + "_" + vpar + "_v", cmd_display_temp)
                if cmd_display_temp is None or '' == cmd_display_temp \
                        or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                        or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en" == language:
                        fun_err_msg += cmd_info_desc[index] + vpar + " -v" + ":\texecute failed\r\n"
                    else:
                        fun_err_msg += cmd_info_desc[index] + vpar + " -v" + u":\t执行失败\r\n"
                else:
                    if "en" == language:
                        fun_err_msg += cmd_info_desc[index] + vpar + " -v" + ":\texecute success\r\n"
                    else:
                        fun_err_msg += cmd_info_desc[index] + vpar + " -v" + u":\t执行成功\r\n"
        else:
            cmd_display_temp = cli.execCmdHasLogTimout(get_sudo_cmd(cmd_info_desc[index], HPUX, context), 60)
            cmd_display.put("cmd_display" + id_tmp[8:], cmd_display_temp)
            if not cmd_display_temp \
                    or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                    or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en" == language:
                    fun_err_msg += cmd_info_desc[index] + ":\texecute failed\r\n"
                else:
                    fun_err_msg += cmd_info_desc[index] + u":\t执行失败\r\n"
            else:
                if "en" == language:
                    fun_err_msg += cmd_info_desc[index] + ":\texecute success\r\n"
                else:
                    fun_err_msg += cmd_info_desc[index] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    return cmd_display
