# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os
import json
import traceback

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_return_from_txt
from common.util import is_digit
from common.util import chang_unit2_gb
from hosts.common.migra_summary_util import get_ret_list


def execute(context):
    result = get_result(context)
    ret_map = context.get("map")
    ret_map.put("data", json.dumps(result))
    return context


def get_result(context):
    """
    获取vg相关数据
    :param context:上下文
    :return: vg数据
    """
    logger = context.get("Logger")
    result = {}
    result["host_ip"] = context.get("ip")
    try:
        result["vg_info_list"] = get_volume_result_list(context)
    except Exception:
        logger.error("parse error: %s" % str(traceback.format_exc()))
        result["vg_info_list"] = [get_empty_result()]
    return result


def get_volume_result_list(context):
    """
    获取vg_info_list返回值
    :param context:上下文
    :return: vg数据
    """
    vg_info_list = []
    vg_list = get_vg_info(context)
    # 没有vg数据，返回一个空格式
    if not vg_list:
        return [get_empty_result()]
    fs_list = get_filesystem_info(context)
    # 循环vg列表，组装数据
    for vg in vg_list:
        one_vg = {}
        lvs = []
        vg_name = vg.get("vg_name", "")
        one_vg["vg_name"] = vg_name
        one_vg["vg_state"] = vg.get("vg_state", "")
        one_vg["vg_size"] = vg.get("vg_size", "")
        one_vg["pvs"] = vg.get("pvs", [])
        lv_list = vg.get("lvs", [])
        # 组装lvm+file
        for lv in lv_list:
            one_lv = {}
            one_lv["lv_name"] = lv.get("lv_name", "")
            one_lv["lv_state"] = lv.get("lv_state", "")
            one_lv["lv_size"] = lv.get("lv_size", "")
            one_lv = get_filesystem(vg_name, one_lv, fs_list)
            lvs.append(one_lv)
        one_vg["lvs"] = lvs
        vg_info_list.append(one_vg)
    return vg_info_list


def get_filesystem(vg_name, one_lv, fs_list):
    """
    组装filesystem必须包含有 lv_name
    :param vg_name: vg_name
    :param one_lv: one_lv
    :param fs_list: fs_list
    :return: one_lv
    """
    flag = False
    if "/" in vg_name:
        vg_name = vg_name.split("/")[-1]
    lv_name = one_lv.get("lv_name", "")
    if "/" in lv_name:
        lv_name = lv_name.split("/")[-1]
    for fs in fs_list:
        filesystem = fs.get("filesystem", "")
        names = filesystem.split("/")
        if lv_name == names[-1] and vg_name == names[-2]:
            one_lv["filesystem"] = fs.get("filesystem", "")
            one_lv["fs_total_size"] = fs.get("fs_total_size", "")
            one_lv["fs_used_size"] = fs.get("fs_used_size", "")
            one_lv["fs_mount_point"] = fs.get("fs_mount_point", "")
            flag = True
            break
    if not flag:
        one_lv["filesystem"] = ""
        one_lv["fs_total_size"] = ""
        one_lv["fs_used_size"] = ""
        one_lv["fs_mount_point"] = ""
    return one_lv


def get_size_by_ppsize(pp_size, pps):
    """
    计算容量size，单位MiB pp_size单位只有mib
    :param pp_size:
    :param pps:
    :return:
    """
    float_value = 0.0
    if not is_digit(pp_size) or not is_digit(pps):
        return float_value
    size = round(float(pp_size.strip()) * float(pps.strip()) / 1024, 2)
    return str(size) + " GiB"


def get_vg_info(context):
    """
    获取vg 的相关数据
    :param context:  context
    :return: vg 数据
    """
    vg_info_list = get_vg_info_list(context)
    vg_list = []
    for one_vg_info in vg_info_list:
        one_vg = get_one_vg(one_vg_info)
        lv_info_list = get_ret_list(one_vg_info, "LV Name")
        pv_info_list = get_ret_list_special(one_vg_info, "PV Name")
        lvs = []
        for lv in lv_info_list:
            one_lv = {}
            for line in lv:
                if "LV Name" in line:
                    one_lv["lv_name"] = line.split()[-1]
                    continue
                if "LV Status" in line:
                    one_lv["lv_state"] = line.split()[-1]
                    continue
                if "LV Size (Mbytes)" in line:
                    one_lv["lv_size"] = get_size_by_ppsize("1",
                                                           line.split()[-1])
                    lvs.append(one_lv)
        one_vg["lvs"] = lvs
        pvs = []
        for pv in pv_info_list:
            pv_name = ""
            pv_size = ""
            for line in pv:
                if "PV Name" in line and not pv_name and len(line.strip().split()) == 3:
                    pv_name = line.split()[-1]
                    continue
                if "Total PE" in line:
                    pv_size = \
                        get_size_by_ppsize(one_vg.get("pp_size", "0"),
                                           line.split()[-1])
            if pv_name:
                pv_tmp = {}
                pv_tmp["pv_name"] = pv_name
                pv_tmp["pv_pvid"] = ""
                pv_tmp["pv_size"] = pv_size
                pvs.append(pv_tmp)
        if not pvs:
            pvs.append({"pv_name": "", "pv_size": "", "pv_pvid": ""})
        one_vg["pvs"] = pvs
        vg_list.append(one_vg)
    return vg_list


def get_ret_list_special(result, symbol):
    """
    通过标志进行分割(HPUX主机可能使用pv_link多路径软件，出现多个pv name，进行兼容)
    :param result: 回文
    :param symbol: 标志
    :return: 结果
    """
    flag = False
    lists = []
    one = []
    for index, line in enumerate(result):
        if line.strip().startswith(symbol):
            flag = True
        if not line.strip() and one:
            lists.append(one)
            one = []
            flag = False
        if flag:
            one.append(line)
    return lists


def get_one_vg(one_vg_info):
    """
    封装one_vg数据
    :param one_vg_info: vg info
    :return: vg
    """
    one_vg = {}
    for line in one_vg_info:
        if "VG Name" in line:
            one_vg["vg_name"] = line.split()[-1]
            continue
        if "VG Status" in line:
            one_vg["vg_state"] = line.replace("VG Status", "").strip()
            continue
        if "PE Size (Mbytes)" in line:
            one_vg["pp_size"] = line.split()[-1]
            continue
        if "Total PE" in line:
            one_vg["pp_total"] = line.split()[-1]
            one_vg["vg_size"] = get_size_by_ppsize(one_vg.get("pp_size", "0"),
                                                   one_vg.get("pp_total", "0"))
            return one_vg
    return one_vg


def get_vg_info_list(context):
    """
    获取vg_info s
    :param context: context
    :return: vg_info s
    """
    context["command"] = "vgdisplay -v"
    vg_info = get_return_from_txt(context)
    return get_ret_list(vg_info, "VG Name")


def get_filesystem_info(context):
    """
    获取filesystem 数据
    :param context: 上下文
    :return: filesystem数据
    """
    context["command"] = "bdf"
    file_system_info = get_return_from_txt(context)

    file_info = []
    all_info = []
    flag = False
    for line in file_system_info:
        if "Filesystem" in line and "Mounted on" in line:
            flag = True
            continue
        if flag and line.strip():
            all_info.extend(line.split())
    line_num = len(all_info) / 6
    for i in range(0, line_num):
        one_file = {}
        one_file["filesystem"] = all_info[6 * i]
        total_size = all_info[6 * i + 1] + " kb"
        use_size = all_info[6 * i + 2] + " kb"
        one_file["fs_total_size"] = str(
            round(chang_unit2_gb(total_size), 2)) + " g"
        one_file["fs_used_size"] = str(
            round(chang_unit2_gb(use_size), 2)) + " g"
        one_file["fs_mount_point"] = all_info[6 * i + 5]
        file_info.append(one_file)
    return file_info


def get_empty_result():
    """
    空数据格式
    :return: 空数据
    """
    lvs = []
    one_vg_na = {}
    one_vg_na["vg_name"] = ""
    one_vg_na["vg_state"] = ""
    one_vg_na["vg_size"] = ""
    one_vg_na["pvs"] = [{"pv_name": "", "pv_size": "", "pv_pvid": ""}]
    one_lv = {}
    one_lv["lv_name"] = ""
    one_lv["lv_state"] = ""
    one_lv["lv_size"] = ""
    one_lv["filesystem"] = ""
    one_lv["fs_total_size"] = ""
    one_lv["fs_used_size"] = ""
    one_lv["fs_mount_point"] = ""
    lvs.append(one_lv)
    one_vg_na["lvs"] = lvs
    return one_vg_na
