# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os
import json

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from hosts.common.migra_summary_util import get_hp_nmp_multi
from hosts.common.migra_summary_util import get_power_multi


def execute(context):
    result = get_result(context)
    ret_map = context.get("map")
    ret_map.put("data", json.dumps(result))
    return context


def get_result(context):
    """
    获取数据结果
    :param context: 上下文
    :return: 数据结果
    """
    result = {}
    host_ip = context.get("ip")
    result["host_ip"] = host_ip
    result["multipaths"] = get_multipaths(context)
    return result


def get_multipaths(context):
    """
    获取多路径信息
    :param context: 上下文
    :return: 多路径信息
    """
    result = []
    nmp_flag, nmp_multi = get_hp_nmp_multi(context)
    power_flag, power_multi = get_power_multi(context, "hpux")
    if nmp_flag:
        result.append(nmp_multi)
    if power_flag:
        result.append(power_multi)
    if not result:
        result.append(get_empty_multi())
    return result


def get_empty_multi():
    """
    生成空数据
    :return: 空数据
    """
    result = {}
    result["multipath_type"] = ""
    result["version"] = ""
    disk_list = []
    one_disk = {}
    one_disk["disk_name"] = ""
    one_disk["lun_size"] = ""
    one_disk["lun_wwn"] = ""
    one_disk["vendor"] = ""
    one_disk["product"] = ""
    one_disk["reserve_policy"] = ""
    disk_list.append(one_disk)
    result["disk_list"] = disk_list
    return result
