# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os
import json
import traceback

reload(sys)
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_return_from_txt


def execute(context):
    result = get_result(context)
    ret_map = context.get("map")
    ret_map.put("data", json.dumps(result))
    return context


def get_result(context):
    """
    获取vg相关数据
    :param context:上下文
    :return: vg数据
    """
    logger = context.get("Logger")
    result = {}
    result["host_ip"] = context.get("ip")
    result["cluster_version"] = get_serviceguard_version(context)
    try:
        cluster_name, cluster_state, nodes_info = get_cluster_and_nodes(context)
    except Exception:
        logger.error("parse error: %s" % str(traceback.format_exc()))
        cluster_name, cluster_state, nodes_info = "", "", []

    result["cluster_name"] = cluster_name
    result["cluster_status"] = cluster_state
    if not nodes_info:
        nodes = get_empty_node()
    else:
        nodes = get_cluster_nodes(nodes_info)
    result["nodes"] = nodes
    return result


def get_cluster_nodes(nodes_info):
    """
    解析为nodes
    :param nodes_info: nodes_info
    :return: nodes
    """
    nodes = []
    for node in nodes_info:
        node_name = ""
        lock_vg = ""
        lock_disk = ""
        lock_status = ""
        node_flag = False
        lock_flag = False
        pack_flag = False
        has_pack = False
        for line in node:
            if "NODE" in line and "STATUS" in line and \
                    "STATE" in line and len(line.strip().split()) == 3:
                node_flag = True
                continue
            if node_flag:
                splits = line.strip().split()
                if len(splits) == 3:
                    node_name = splits[0]
                    node_flag = False
            if "VOLUME_GROUP" in line and "PHYSICAL_VOLUME" in line and \
                    "STATUS" in line and len(line.strip().split()) == 3:
                lock_flag = True
                continue
            if lock_flag:
                splits = line.strip().split()
                if len(splits) == 3:
                    lock_vg = splits[0]
                    lock_disk = splits[1]
                    lock_status = splits[2]
                    lock_flag = False
            if "PACKAGE" in line and "STATUS" in line and "STATE" in line and \
                    "AUTO_RUN" in line and "NODE" in line and \
                    len(line.strip().split()) == 5:
                pack_flag = True
                continue
            if pack_flag:
                splits = line.strip().split()
                if len(splits) == 5:
                    package_name = splits[0]
                    package_status = splits[1]
                    package_state = splits[2]
                    package_node = splits[4]
                    one_node = {}
                    one_node["node_name"] = node_name
                    one_node["lock_vg"] = lock_vg
                    one_node["lock_disk"] = lock_disk
                    one_node["lock_status"] = lock_status
                    one_node["package_name"] = package_name
                    one_node["package_state"] = package_state
                    one_node["package_status"] = package_status
                    one_node["package_node"] = package_node
                    has_pack = True
                    nodes.append(one_node)
                else:
                    pack_flag = False
        if not has_pack:
            one_node = {}
            one_node["node_name"] = node_name
            one_node["lock_vg"] = lock_vg
            one_node["lock_disk"] = lock_disk
            one_node["lock_status"] = lock_status
            one_node["package_name"] = ""
            one_node["package_state"] = ""
            one_node["package_status"] = ""
            one_node["package_node"] = ""
            nodes.append(one_node)
    return nodes


def get_cluster_and_nodes(context):
    """
    获取集群名字、状态，及节点数据
    :param context: context
    :return: 集群名字、状态，及节点数据
    """
    context["command"] = "cmviewcl -v"
    ret_info = get_return_from_txt(context)
    cluster_name = ""
    cluster_state = ""
    cluster_flag = False
    flag = False
    node_lists = []
    one_node = []
    for index, line in enumerate(ret_info):
        if "CLUSTER" in line and "STATUS" in line:
            cluster_flag = True
            continue
        if cluster_flag:
            splits = line.strip().split()
            if len(splits) == 2:
                cluster_name = splits[0]
                cluster_state = splits[1]
            cluster_flag = False
        if "NODE" in line and "STATUS" in line and "STATE" in line and \
                len(line.strip().split()) == 3:
            flag = True
        if "NODE" in line and "STATUS" in line and "STATE" in line \
                and len(line.strip().split()) == 3 and one_node:
            node_lists.append(one_node)
            one_node = []
        if flag:
            one_node.append(line)
        if flag and index == len(ret_info) - 1:
            node_lists.append(one_node)
    return cluster_name, cluster_state, node_lists


def get_serviceguard_version(context):
    """
    获取serviceguard集群的version
    :param context: context
    :return: version
    """
    context["command"] = "cmversion"
    version_info = get_return_from_txt(context)
    if not version_info and "not found" in version_info[0]:
        return ""
    return version_info[0].strip()


def get_empty_node():
    """
    生成空数据
    :return: 空数据
    """
    nodes = []
    one_node = {}
    one_node["node_name"] = ""
    one_node["lock_vg"] = ""
    one_node["lock_disk"] = ""
    one_node["lock_status"] = ""
    one_node["package_name"] = ""
    one_node["package_state"] = ""
    one_node["package_status"] = ""
    one_node["package_node"] = ""
    nodes.append(one_node)
    return nodes
