# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_cmd_ret

cmd_info_id = [
    "cmd_info_multipath_info_upadmin_version",
    "cmd_info_multipath_info_powermt_version",
    "cmd_info_multipath_info_nmp_disk",
    "cmd_info_multipath_info_diskinfo_",
    "cmd_info_multipath_info_power_disk",
]

cmd_info_desc = [
    "upadm show version",
    "powermt version",
    "scsimgr -p get_attr all_lun -a device_file -a wwid",
    "diskinfo ",
    "powermt display dev=all",
]


def execute(context):
    cmd_display = context.get("ret_map")
    cmd_display_temp = ''
    for rg in range(len(cmd_info_id)):
        if cmd_info_id[rg] == "cmd_info_multipath_info_diskinfo_":
            set_prefix_cmd(cmd_display, context, cmd_info_id[rg],
                           cmd_info_desc[rg])
            continue
        context["command"] = cmd_info_desc[rg]
        cmd_display_temp = get_cmd_ret(context)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:],
                        cmd_display_temp)
    return cmd_display


def set_prefix_cmd(cmd_display, context, id_prefix, cmd_prefix):
    """
    组装通过命令前缀执行的详情
    :param cmd_prefix: 命令前缀
    :param id_prefix: 描述前缀
    :param cmd_display: 回文字典
    :param context: 上下文
    """
    if id_prefix == "cmd_info_multipath_info_diskinfo_":
        context["command"] = \
            "ioscan -funNC disk|grep rdisk|" \
            "awk '{ for(i = 1;i<NF+1;i++) print $i }'|grep rdisk/disk"
        rdisk_dev_list = get_cmd_ret(context).splitlines()[1:]
        for disk_name in rdisk_dev_list:
            if disk_name and "not found" not in disk_name:
                context["command"] = cmd_prefix + disk_name
                cmd_display.put("cmd_display" + id_prefix[8:] + disk_name,
                                get_cmd_ret(context))
