# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_cmd_ret

cmd_info_id = [
    "cmd_info_os_basic_uname",
    "cmd_info_os_basic_hba",
    "cmd_info_os_basic_hba_list_",
    "cmd_info_os_basic_hosts_conf",
    "cmd_info_os_oslevel",
    "cmd_info_os_olsnodes",
]

cmd_info_desc = [
    "uname -a",
    "ioscan -funC fc",
    "fcmsutil ",
    "cat /etc/hosts",
    "oslevel -s",
    "olsnodes -s",
]


def execute(context):
    cmd_display = context.get("ret_map")
    cmd_display_temp = ''
    for rg in range(len(cmd_info_id)):
        if cmd_info_id[rg] == "cmd_info_os_basic_hba_list_":
            set_prefix_cmd(cmd_display, context, cmd_info_id[rg],
                           cmd_info_desc[rg])
            continue
        context["command"] = cmd_info_desc[rg]
        cmd_display_temp = get_cmd_ret(context)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:],
                        cmd_display_temp)
    return cmd_display


def set_prefix_cmd(cmd_display, context, id_prefix, cmd_prefix):
    """
    组装通过命令前缀执行的详情
    :param cmd_prefix: 命令前缀
    :param id_prefix: 描述前缀
    :param cmd_display: 回文字典
    :param context: 上下文
    """
    if id_prefix == "cmd_info_os_basic_hba_list_":
        context["command"] = "ioscan -funC fc|grep dev|awk '{print $1}'"
        dev_list = get_cmd_ret(context).splitlines()[1:]
        for dev_name in dev_list:
            if dev_name and "not found" not in dev_name:
                context["command"] = cmd_prefix + dev_name
                cmd_display.put("cmd_display" + id_prefix[8:] + dev_name,
                                get_cmd_ret(context))
