# --*-- coding:utf-8 --*--
import sys 
import os
import re
reload(sys) 
sys.setdefaultencoding('utf-8')
path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import getSingleOrMoreCommandRetFromTxt,is_belong_lst

HBA_MODEL_FW_CMDS = "cmd_display_hba_card_fcmsutil_modelfw_"
HBA_DRVER_STATE_CMDS = 'cmd_display_hba_card_fcmsutil_drstate_'
HBA_WWPN = 'cmd_display_hba_card_fcmsutil_'

def execute(context):
    '''
    @summary:脚本入口
    @param context:上下文
    '''
    global Logger
    Logger = context.get("Logger")
    hbaObjs = getAllHbaObjs(context)
    all_result = ""
    fc_result = getAllWWPNS(hbaObjs)
    iscsi_result = get_iscsi_wwn(context)

    if fc_result == "NA":
        all_result = iscsi_result
    else:
        if iscsi_result == "NA":
            all_result = fc_result
        else:
            all_result = fc_result + ";" + iscsi_result

    context['result'] = all_result
    return context


def get_iscsi_wwn(context):
    """
    获取iscsi的wwn
    :param context:
    :return:
    """
    iscsi_wwn = ""
    cmd_iscsi_wwn_desc = "cmd_display_hba_card_iscsi"
    iscsi_wwn_str = getSingleOrMoreCommandRetFromTxt(context,
                                                     cmd_iscsi_wwn_desc,
                                                     False)
    for line in iscsi_wwn_str:
        if "Initiator Name" in line and ":" in line:
            iscsi_wwn = iscsi_wwn + re.split(':', line)[1].strip() + ";"
    if not iscsi_wwn:
        iscsi_wwn = "NA"
    else:
        iscsi_wwn = iscsi_wwn[0:-1]
    return iscsi_wwn


def getAllWWPNS(hbas):
    '''
    @summary:过滤掉state不为online的HBA卡。
    @param hbas:对象列表
    @return wwpns:wwpn
    '''
    wwpns = ''
    for hba in hbas:
        if 'ONLINE'.lower() != hba.getState().lower():   
            continue
        wwpns = wwpns +';'+ hba.getHbaWWPN()
    if not wwpns:
        wwpns = 'NA'
    else:
        wwpns = wwpns[1:]
    return wwpns
        
        
def getAllHbaObjs(context):
    '''
    @summary: 获取所有的hba对象
    @param context:上下文
    @return hbaObjLst:所有hba对象列表
    '''
    global Logger
    Logger = context.get("Logger")
    hbaObjLst = []
    
    eachHbaModelFwLst = getSingleOrMoreCommandRetFromTxt(context, HBA_MODEL_FW_CMDS,True)
    eachHbaDriStateLst = getSingleOrMoreCommandRetFromTxt(context, HBA_DRVER_STATE_CMDS,True)
    eachHbaWwpnLst = getSingleOrMoreCommandRetFromTxt(context, HBA_WWPN,True) 
    for hbalst in eachHbaModelFwLst:
        hbaObjLst.append(getSingleHbaInfo(context, hbalst))

    setHbaDriverStateInfo(hbaObjLst,eachHbaDriStateLst) 
    #放入wwpn数据  ，其中eachHbaWwpnLst为遍历fcmsutil的结果
    setHpHbaWwpn(hbaObjLst, eachHbaWwpnLst)   
    return hbaObjLst

#18年4月18日加入HP的wwpn的写入
def setHpHbaWwpn(hbaObjLst,eachHbaWwpnLst):
    for hbaObj in hbaObjLst:
        arg = hbaObj.getHbaArg()
        wwpnLst = []
        for lst in eachHbaWwpnLst:
            if is_belong_lst(arg,lst):
                wwpnLst = lst
                break
        for line in wwpnLst:
            if ('N_Port Port World Wide Name'.lower() in line.lower()) and ('=' in line):
                wwpn = re.split('=',line)[-1].strip()
                if wwpn.lower().startswith('0x'):
                    wwpn = wwpn[2:]
                hbaObj.setHbaWWPN(wwpn)
                Logger.info('set HP WWPN success.')
                break
       
       
def setHbaDriverStateInfo(hbaObjLst,driStateLst):
    for hbaObj in hbaObjLst:
        arg = hbaObj.getHbaArg()
        
        driStateLineLst = []
        for lst in driStateLst:
            if is_belong_lst(arg,lst):
                driStateLineLst = lst
                break
        for dLine in driStateLineLst:
            if ('Driver'.lower() in dLine.lower()) and ('state' in dLine.lower()):
                if '=' in dLine:
                    state = re.split('=',dLine)[-1].strip()
                    hbaObj.setState(state)
                continue
            
            if ('Driver'.lower() in dLine.lower()) and ('Version'.lower() in dLine.lower()):
                drLst = re.split('\s+',dLine)
                for idx,drValue in enumerate(drLst):
                    try:
                        if 'fcd' in drValue.lower():
                            drVersion = drLst[idx+1]
                            hbaObj.setDrVersion(drVersion)
                    except Exception,e:
                        Logger.info('hba drversion not found.',str(e))
                

def getSingleHbaInfo(context, hbaLst):
    global Logger
    Logger = context.get("Logger")
    hbaObj = HbaEntity()
    for line in hbaLst:
        if HBA_MODEL_FW_CMDS in line:
            hhaArg = line.replace(HBA_MODEL_FW_CMDS,'').strip()
            hbaObj.setHbaArg(hhaArg)
        
        if ('Part number'.lower()  in line.lower()) and (':' in line):
            model = ''
            lst = re.split(':',line)
            try:
                model = re.split('\s+',lst[-1].strip())[0]
                hbaObj.setHbaModel(model)
            except Exception,e:
                Logger.info('hba model not found.',str(e))
            continue
        if ('ROM Firmware version'.lower() in line.lower()) and (':' in line):
            fwVersion = ''
            try:
                fwVersion = re.split(':',line)[-1].strip()
                hbaObj.setFwVersion(fwVersion)
            except Exception,e:
                Logger.info('fwVersion not found.',str(e))
    return hbaObj
                    
class HbaEntity:
    hbaArg = ''
    hbaModel = 'NA'
    wwpn = 'NA'
    fwVersion = 'NA'
    drVersion = 'NA'
    state = 'NA'
    
    def getHbaArg(self):
        return self.hbaArg 
    def getHbaModel(self):
        return self.hbaModel
    def getHbaWWPN(self):
        return self.wwpn
    def getFwVersion(self):
        return self.fwVersion
    def getDrVersion(self):
        return self.drVersion
    def getState(self):
        return self.state

    def setHbaModel(self,model):
        self.hbaModel = model
    def setHbaWWPN(self,wwpn):
        self.wwpn = wwpn
    def setFwVersion(self,version):
        self.fwVersion = version
    def setDrVersion(self,drVersion):
        self.drVersion = drVersion
    def setState(self,state):
        self.state = state
    def setHbaArg(self,arg):
        self.hbaArg = arg
        
        
