# coding=utf-8
__author__ = '******'
# 数据迁移: 获取linux主机: 阵列信息，磁盘信息，文件系统信息等
import re
import sys
import os 
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common import util
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import XENSERVER
CLI = None
LANGUAGE = None
CHECK_FAIL = 0
CHECK_PASS = 1
cmd_info_id = [
               "cmd_info_migrate_disklunwwn",
               
               "cmd_info_migrate_cluster_hba", #获取磁盘列表
               "cmd_info_migrate_cluster_lvversion",
               "cmd_info_migrate_cluster_pvdisplay",
               "cmd_info_migrate_cluster_vgdisplay",
               
               "cmd_info_migrate_cluster_vgdiply",
               "cmd_info_migrate_cluster_lvdiply",
               "cmd_info_migrate_cluster_dfh",
               "cmd_info_migrate_cluster_dth",
            ]
            
cmd_info_desc = [
                  "ls -al /dev/disk/by-id/",
                  
                 "smartctl -a /dev/hda",
                 "lvm version", #逻辑卷版本
                 "pvdisplay",
                 "vgdisplay",
                 
                 "vgdisplay -v",
                 "lvdisplay",
                 "df -h",
                 "df -TH"
                 ]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(context, cmd_display, CLI, LANGUAGE))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(context, cmd_display, CLI, LANGUAGE):
    tempStep = constants.PROG90 / len(cmd_info_id)
    curStep = tempStep
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        cmd_display_temp = CLI.execCmdHasLogTimout(
            get_sudo_cmd(cmd_info_desc[rg], XENSERVER, context), 60)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:], cmd_display_temp)
        if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en" == LANGUAGE:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en" == LANGUAGE:
                fun_err_msg += cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg += cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg
