# coding=utf-8
__author__ = '******'
# 获取XunServer主机的HBA卡信息
import sys
import os
import re
path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..")
sys.path.append(path)
from common.contentParse import getCommandRet, getSingleCommandRet
from common import constants
from common import util
from hosts.sudo_utils import get_sudo_cmd_desc
from hosts.sudo_utils import XENSERVER

cmd_info_id = ["cmd_info_modelname",
               "cmd_info_port_name",
               "cmd_info_hba_card_port_name_ls",
               "cmd_info_hba_card_port_name_cat",
               "cmd_info_hba_card_model_ls",
               "cmd_info_hba_card_model_cat",
               "cmd_info_hba_card_driver_version_ls",
               "cmd_info_hba_card_fw_version_ls",
               "cmd_info_hba_card_Folder",
               "cmd_info_hba_card_iSCSI_node",
               "cmd_info_hba_card_lspci",
               ]
            
cmd_info_desc = ["cat /sys/class/scsi_host/host4/modelname",
                 "cat /sys/class/fc_host/hostX/port_name",
                 "ls /sys/class/fc_host/host*/port*name",
                 "cat  /sys/class/fc_host/host*/port*name",
                 "ls /sys/class/scsi_host/host*/model*name",
                 "cat  /sys/class/scsi_host/host*/model*name",
                 "ls /sys/class/scsi_host/host*/*version |awk '/lpfc_drvr_version|driver_version/'",
                 "ls /sys/class/scsi_host/host*/*fw* |awk '/fwrev|optrom_fw_version/'",
                 "ls /sys/class/fc_remote_ports/",
                 "iscsiadm -m node",
                 "lspci -vvnn | grep -iA2 'Fibre Channel'",
                 ]


cmd_info_id_fw_version = "cmd_info_hba_card_fw_version_cat" 
cmd_info_id_hba_driver_version = "cmd_info_hba_card_driver_version_cat"
cmd_info_id_tmo = "cmd_info_hba_card_tmo" 

def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    errMsg = ''
    # 获取HBA 端口 型号 驱动版本信息
    util.updateItemProgress(context, constants.PROG15)
    getCommandRet(context, cmd_info_id,
                  get_sudo_cmd_desc(cmd_info_desc, XENSERVER, context))
    errMsg += context.get("ret_map").get("err_msg")
    #获取HBA驱动版本信息
    util.updateItemProgress(context, constants.PROG30)
    getHbaDrvVersion(context)
    errMsg += context.get("ret_map").get("err_msg")
    #获取FW Version命令信息
    util.updateItemProgress(context, constants.PROG45)
    getFwVersion(context)
    errMsg += context.get("ret_map").get("err_msg")
    #获取HBA卡的超时时间
    util.updateItemProgress(context, constants.PROG60)
    getHbaCardTMO(context)
    errMsg += context.get("ret_map").get("err_msg")
    
    util.updateItemProgress(context, constants.PROG85)
    context.get("ret_map").put('err_msg', errMsg)
    return context
  
def getHbaDrvVersion(context):
    #获取FW Version命令信息
    CLI = context.get("SSH")
    hbzFrvVersionCmd = ""
    hbaHbaDrvVersionCmd_list = CLI.execCmdHasLog(cmd_info_desc[4]).splitlines()
    for cmd in hbaHbaDrvVersionCmd_list[1:]:
        if cmd == "" or "No such file or directory" in cmd or "TOOLKIT_EXE_CMD_FAILED" in cmd or "ls:" in cmd:
            continue
        hbzFrvVersionCmd += "cat " + cmd + ";"  
    if hbzFrvVersionCmd == "":
        return  
    #获取固件信息 
    getSingleCommandRet(context, cmd_info_id_hba_driver_version, hbzFrvVersionCmd) 
      
def getFwVersion(context):
    #获取FW Version命令信息
    CLI = context.get("SSH")
    fwVersionCmd = ""
    hbaFwVersionCmd_list = CLI.execCmdHasLog(cmd_info_desc[5]).splitlines()
    for cmd in hbaFwVersionCmd_list[1:]:
        if cmd == "" or "No such file or directory" in cmd or "TOOLKIT_EXE_CMD_FAILED" in cmd or "ls:" in cmd:
            continue
        fwVersionCmd += "cat " + cmd + ";"  
    if fwVersionCmd == "":
        return  
    #获取固件信息 
    getSingleCommandRet(context, cmd_info_id_fw_version, fwVersionCmd)  
    


def getHbaCardTMO(context):
    #获取HBA目录命令信息
    CLI = context.get("SSH")
    tmoCmd = ""
    hbaCardFolderCmd_list = CLI.execCmdHasLog(cmd_info_desc[6]).splitlines()
    hbaCardIscsiCmd_list  = CLI.execCmdHasLog(cmd_info_desc[7]).splitlines()
    for cmd in hbaCardFolderCmd_list[1:]:
        if cmd == "" or "No such file or directory" in cmd or "TOOLKIT_EXE_CMD_FAILED" in cmd or "ls: " in cmd:
            break
        cmdList = cmd.split()
        for i in range(0, len(cmdList)):
            tmoCmd += "cat /sys/class/fc_remote_ports/" + cmdList[i] + "/dev_loss_tmo\n"  
    nodeIpList = []
    for cmd in hbaCardIscsiCmd_list[1:]:
        if cmd == "" or "iscsiadm" in cmd or "TOOLKIT_EXE_CMD_FAILED" in cmd or "command not found" in cmd:
            break
        nodeIp = cmd.split(":")[0].strip()
        if nodeIp in nodeIpList:
            continue
        else:
            nodeIpList.append(nodeIp)
        tmoCmd += "iscsiadm -m node -p " + nodeIp + " | grep replacement_timeout\n" 
        
    if tmoCmd == "":
        return  
    getSingleCommandRet(context, cmd_info_id_tmo, tmoCmd)   