# coding=utf-8
__author__ = '******'
# 获取XunServer主机的数据存储信息
import re
import sys
import os 
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common import util
from hosts.sudo_utils import get_sudo_cmd
from hosts.sudo_utils import XENSERVER

CLI = None
LANGUAGE = None
CHECK_FAIL          =       0
CHECK_PASS          =       1
cmd_info_id = [
               "cmd_info_os_name",
               "cmd_info_os_basic_manufacturer",
               "cmd_info_os_release",
               
               "cmd_info_sr_list",
               "cmd_info_vdi-list",
               "cmd_info_pbd-list",
               "cmd_info_vbd-list",
               "cmd_info_sr-param",
               "cmd_info_vdi-param",
               "cmd_info_ip",

               "cmd_info_os_basic_cputype",
               "cmd_info_os_basic_cpunum",
               "cmd_info_os_basic_cpuratio",
               "cmd_info_os_basic_memnumanduse",
                ]
            
cmd_info_desc = ["uname -a",
                 "dmidecode -s system-manufacturer",
                 "cat /etc/*-release",
                 
                 "xe sr-list",
                 "xe vdi-list",
                 "xe pbd-list",
                 "xe vbd-list",
                 "sr-param-list",
                 "vdi-param-list",
                 "ip addr",
                 
                  "less /proc/cpuinfo |grep model",
                 "cat /proc/cpuinfo",
                 "vmstat 1 5",
                 "cat /proc/meminfo",
                  
                 ]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return check_and_get_result(cmd_execute(context, cmd_display, CLI, LANGUAGE))


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """
    :rtype : object
    """
    return result


def cmd_execute(context, cmd_display, CLI, LANGUAGE):
    tempStep = constants.PROG90 / len(cmd_info_id)
    curStep = tempStep
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    for rg in range(len(cmd_info_id)):
        curStep += tempStep
        util.updateItemProgress(context, curStep)
        cmd_display_temp = CLI.execCmdHasLogTimout(
            get_sudo_cmd(cmd_info_desc[rg], XENSERVER, context), 60)
        cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
        if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)
    fun_flag = CHECK_PASS
    return fun_flag, cmd_display, fun_err_msg